#include <windows.h>
//#include <memory.h>
//#include <malloc.h>
#include <string.h>
#include "hugemem.h"
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <io.h>
#include "epaint.h"
#include "bitmap.h"

/**************************************************************************
*  Function Name: loadBMPFile
**************************************************************************/
int loadBMPFile (char *szFileName, BITMAPINFO **pp_binfo, LOGPALETTE **pp_pal, 
				 unsigned char _huge **php_bits)
{
BITMAPINFOHEADER  bmHead;                //bitmap header
int               k;
int               *piColorIndex;
int               hfile=0;           //handle to bitmap file
WORD 				w_colors;

		// read file header
    if ((hfile=readBMPFileHeader (szFileName, (BYTE *)&bmHead)) < 0) {
		if (hfile)
			_close (hfile);	
		return -1;
    } //End if (error reading file header)

		//compute number colors in bitmap
    w_colors=(1 << (bmHead.biBitCount*bmHead.biPlanes));

		//allocate bitinfo structure and palette	
    if (allocBinfoAndPal (w_colors, pp_binfo, pp_pal) < 0) {
		_close (hfile);
		return -1;
	}

		//copy BMP header to bitinfo structure
    memcpy (&(*pp_binfo)->bmiHeader, &bmHead, sizeof (BITMAPINFOHEADER));

		//compute the size of the image
    (*pp_binfo)->bmiHeader.biSizeImage = getBMPSize(*pp_binfo);

        // read in the color table
    _read(hfile, &(*pp_pal)->palPalEntry[0], w_colors*sizeof(PALETTEENTRY));

    piColorIndex = (int *) &(*pp_binfo)->bmiColors[0];
    for (k=0; k<(int)w_colors;k++)
    {  
		(*pp_pal)->palPalEntry[k].peFlags = (*pp_pal)->palPalEntry[k].peRed;
		(*pp_pal)->palPalEntry[k].peRed=(*pp_pal)->palPalEntry[k].peBlue;	
		(*pp_pal)->palPalEntry[k].peBlue=(*pp_pal)->palPalEntry[k].peFlags;
		(*pp_pal)->palPalEntry[k].peFlags = 0;
		piColorIndex[k] = k;
    } //End for (each color in the bitmap color table)
    (*pp_pal)->palVersion = 0x300;              //Win. 3.0 palette
    (*pp_pal)->palNumEntries = w_colors;     //Number of colors in logical palette

	    //Allocate bit buffer
    if ((*php_bits= (unsigned char _huge *)HugeAlloc
            ((*pp_binfo)->bmiHeader.biSizeImage/*, sizeof(char)*/))==NULL) {
		_close (hfile);
		free (*pp_pal);
		free (*pp_binfo);
        return -1;
	}

        //Read in the bitmap data
    _hread (hfile, *php_bits, (*pp_binfo)->bmiHeader.biSizeImage);

    _close(hfile);

    return 0;
} //End function (swiDisplayBMPFile)
/******************************************************************************
Function : dispBitmap
Purpose  : place pixels on screen
******************************************************************************/
void dispBitmap (HDC h_dc, HDC h_memDC, HBITMAP h_bmp, 
				BITMAPINFO *p_binfo, BYTE _huge *hp_bits)
{
    SetDIBits(h_memDC, h_bmp, 0, p_binfo->bmiHeader.biHeight, hp_bits, 
			p_binfo, DIB_PAL_COLORS);

    BitBlt(h_dc, 0, 0, p_binfo->bmiHeader.biWidth, p_binfo->bmiHeader.biHeight,
			 h_memDC, 0, 0, SRCCOPY);
} //End function (dispBitmap)
/******************************************************************************
Function : readBMPFileHeader
Purpose  : Reads the file header
******************************************************************************/
int readBMPFileHeader (char *psz_fname, BYTE *p_buf)
{
int   h_file;
		//read in BMP file header
	if ((h_file = readFileHeader (psz_fname, p_buf, sizeof(BITMAPFILEHEADER))) < 0)
		return -1;
        //  Read in the BMP info header
    if( _read(h_file, p_buf, sizeof(BITMAPINFOHEADER))< sizeof(BITMAPINFOHEADER)) {
        return -1;
    }  //End if (error reading the file header)

    return h_file;
} //End function (readFileHeader)
/******************************************************************************
Function : readFileHeader
Purpose  : Reads the file header
******************************************************************************/
int readFileHeader (char *fname, BYTE *buf, int size)
{
int h_file;
        //  Open the file
    if ((h_file =  _open (fname, O_BINARY | O_RDONLY))==-1)    {
        return -1;
    } //End if (error opening file)
        //  Read in the bitmapinfo header
    if( _read(h_file, buf, size)< size)    {
        return -1;
    }  //End if (error reading the file header)

    return h_file;
} //End function (readFileHeader)
/**************************************************************************
*  Function Name: createBMDC
**************************************************************************/
DWORD createBMDC (HDC h_dc, HDC *p_memDC, BITMAPINFO *p_binfo, 
	    			LOGPALETTE *p_pal)
{
HBITMAP  h_bmp;
HPALETTE h_pal;
    h_bmp = CreateDIBitmap (h_dc, &p_binfo->bmiHeader, 0, NULL, NULL, 0);
    *p_memDC = CreateCompatibleDC (h_dc);
    SelectObject (*p_memDC, h_bmp);
    h_pal = CreatePalette (p_pal);
    SelectPalette (*p_memDC, h_pal, FALSE);
    RealizePalette (*p_memDC);
	//DeleteObject (h_pal);
    return MAKELONG (h_bmp, h_pal);
} //End function (createBMDC)
/**************************************************************************
*  Function Name: allocBinfoAndPal
**************************************************************************/
int allocBinfoAndPal (WORD wNumColors, BITMAPINFO **pp_binfo, LOGPALETTE **pp_pal)
{
        // Allocate enough space for BITMAPINFO structure with
        // proper sized color table
    if ((*pp_binfo = (BITMAPINFO *)malloc (sizeof(BITMAPINFO)+(wNumColors-1)*sizeof(int))) == NULL) {
        return -1;
    } //End if (no memory)
    if ((*pp_pal = (LOGPALETTE *)malloc (sizeof(LOGPALETTE) +(wNumColors-1)*sizeof(PALETTEENTRY))) == NULL)
    {   free (*pp_binfo);
        return -1;
    } //End if (error allocating palette)
    return 0;
} //End function (allocBinfoAndPal)
/**************************************************************************
*  Function Name: getBMPSize
**************************************************************************/
long getBMPSize (BITMAPINFO *p_binfo)
{
long bytesPerScanline;

	bytesPerScanline= ( p_binfo->bmiHeader.biWidth*
						p_binfo->bmiHeader.biPlanes*
						p_binfo->bmiHeader.biBitCount/8);

    if (bytesPerScanline % 4)
    {
        bytesPerScanline &= ~3;
        bytesPerScanline += 4;
    } //End if (not a multiple of 4 bytes per scanline)
    return bytesPerScanline* (DWORD)p_binfo->bmiHeader.biHeight;
} //end function (getBMPSize)

