#define BIT0    0x00000001
#define BIT2    0x00000004
#define BIT15   0x00008000
#define BIT16   0x00010000
#define BIT17   0x00020000
#define SEQ     (BIT17)

/**************************************************************************
*  Function Name: bmpBlocks
**************************************************************************/
int bmpBlocks (HDC hDC, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
unsigned long seed;
unsigned long value, maxvalue;
unsigned long x, y, i;
unsigned long fill, mask= (BIT16 | BIT15 | BIT2 | BIT0);
unsigned long tmp, cnt, shft;
unsigned long width = p_binfo->bmiHeader.biWidth/BLOCK, 
			  height = p_binfo->bmiHeader.biHeight;

		/* maximum random value that is useful */
		maxvalue = height/BLOCK* width;
        seed = SEQ-1;

		SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, p_binfo, DIB_PAL_COLORS);

        for (i=0, value=seed;;i++)
        {
                fill = 0L;
                /* mask out randomize bits */
                tmp = (value & mask);
                /* if the number of bits is odd, fill with a one */
                shft = BIT0;
                cnt = 0;
                while (shft < SEQ) {
                        if (tmp & shft)
                                cnt++;
                        shft <<= 1;
                }
                if (cnt & BIT0)
                        fill = BIT0;
                /* range and fill */
                value <<= 1;
                value |= fill;
                value &= (SEQ-1);
                if (value == seed)
                        break;
				/* discard value if out of range */
				if (value > maxvalue)
					continue;
				/* compute x and y coordinates to display block */
				y = (value/width) * BLOCK;
				x = (value % width) * BLOCK;
                BitBlt(hDC, (WORD)x, (WORD)y, BLOCK, BLOCK, h_memDC, (WORD)x, (WORD)y, SRCCOPY);
        }

		/* fill 0,0 */
        BitBlt(hDC, 0, 0, BLOCK, BLOCK, h_memDC, 0, 0, SRCCOPY);

		return 0;

} /* end function (bmpBlocks) */

