#include <windows.h>
#include <memory.h>
#include <stdlib.h>
#include "epaint.h"
#include "bitmap.h"

#define BLOCK  4

BITMAPINFO *p_binfo;
LOGPALETTE *p_pal;
BYTE _huge *hp_bits;
HDC  h_memDC;
HBITMAP h_bmp;
HPALETTE h_pal;

VOID UsePalette(HDC hDC, BOOL bNoStatic);

extern HWND hwndMain;

/**************************************************************************
*  Function Name: bmpCrush
**************************************************************************/
int bmpCrush (HDC hDC, int effect, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
int x, y;
int left=0, top=0, right=(int)p_binfo->bmiHeader.biWidth-BLOCK,
    bot=(int)p_binfo->bmiHeader.biHeight-BLOCK;

    SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, p_binfo, DIB_PAL_COLORS);

    if (effect == IDM_VERTCRUSH) {
        while (top < bot)
        {
            for (x=left;x<=right;x+=BLOCK)
               BitBlt(hDC, x, top, BLOCK, BLOCK, h_memDC, x, top, SRCCOPY);
            top += BLOCK;
            for (x=left;x<=right;x+=BLOCK)
                BitBlt(hDC, x, bot, BLOCK, BLOCK, h_memDC, x, bot, SRCCOPY);
            bot -= BLOCK;
        } //end while (not at center)
    } //End if (vertical crush)

    if (effect == IDM_HORZCRUSH) {
        while (left < right)
        {
	        for (y=top;y<=bot;y+=BLOCK)
    	        BitBlt(hDC, right, y, BLOCK, BLOCK, h_memDC, right, y, SRCCOPY);
            right -= BLOCK;
            for (y=top;y<=bot;y+=BLOCK)
    	        BitBlt(hDC, left, y, BLOCK, BLOCK, h_memDC, left, y, SRCCOPY);
            left += BLOCK;
        } //end while (not at center)
    } //End if (horizontal crush)

    return 0;
} //End function (bmpCrush)
/**************************************************************************
*  Function Name: bmpDiagonal
**************************************************************************/
int bmpDiagonal (HDC hDC, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
int left=0, top=0, right=(int)p_binfo->bmiHeader.biWidth-BLOCK,
    bot=(int)p_binfo->bmiHeader.biHeight-BLOCK;
int startcolumn, startrow, column, row;
DWORD nextTime;

    SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, p_binfo, DIB_PAL_COLORS);

	/* scan diagonals along the top edge*/
	nextTime = GetTickCount() + 10;
	startcolumn = left;
	while (startcolumn <= right) {
		column= startcolumn;
		row= top;
		while (column >= left && row <= bot) {
   	        BitBlt(hDC, column, row, BLOCK, BLOCK, h_memDC, column, row, SRCCOPY);
			column -= BLOCK;
			row += BLOCK;
		} /* end while (more columns in diagonal */
		startcolumn += BLOCK;
        while (GetTickCount() < nextTime);
        nextTime += 10;
	} /* end while (more diagonals to scan along top edge) */

	/* scan diagonals down the right side */
	nextTime = GetTickCount() + 10;
	startrow = top+BLOCK;
	while (startrow <= bot) {
		column = right;
		row = startrow;
		while (column >= left && row <= bot) {
   	        BitBlt(hDC, column, row, BLOCK, BLOCK, h_memDC, column, row, SRCCOPY);
			column -= BLOCK;
			row += BLOCK;
		} /* end while (more columns in diagonal */
		startrow += BLOCK;
        while (GetTickCount() < nextTime);
        nextTime += 10;
	} /* end while (more diagonals to scan along right edge) */

    return 0;
} //End function (bmpDiagonal)
/**************************************************************************
*  Function Name: bmpSpiral
**************************************************************************/
int bmpSpiral (HDC hDC, int effect, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
int left=0, top=0, right=(int)p_binfo->bmiHeader.biWidth-BLOCK,
    bot=(int)p_binfo->bmiHeader.biHeight-BLOCK;
int width = (int)p_binfo->bmiHeader.biWidth-BLOCK, 
	height = (int)p_binfo->bmiHeader.biHeight-BLOCK;
int x, y;
DWORD nextTime = GetTickCount() + 50;

    SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, p_binfo, DIB_PAL_COLORS);

		if (effect  == IDM_INWARDSPIRAL) {
				while (left < right && top < bot) {
			        /* top edge */
                    for (x=left;x<=right;x+=BLOCK)
                        BitBlt(hDC, x, top, BLOCK, BLOCK, h_memDC, x, top, SRCCOPY);
                    top += BLOCK;
	    		    /* right edge */
                    for (y=top;y<=bot;y+=BLOCK)
                        BitBlt(hDC, right, y, BLOCK, BLOCK, h_memDC, right, y, SRCCOPY);
                    right -= BLOCK;
			        /* bottom edge */
                    for (x=right;x>=left;x-=BLOCK)
                        BitBlt(hDC, x, bot, BLOCK, BLOCK, h_memDC, x, bot, SRCCOPY);
                    bot -= BLOCK;
	    		    /* left edge */
                    for (y=bot;y>=top;y-=BLOCK)
                        BitBlt(hDC, left, y, BLOCK, BLOCK, h_memDC, left, y, SRCCOPY);
                    left += BLOCK;

			        while (GetTickCount() < nextTime);
			        nextTime += 50;

                } //end while (not at center)
		} /* end if (inward spiral */

		if (effect  == IDM_OUTWARDSPIRAL) {
				left = width/2 - (width/2) % BLOCK;
				right = left;
				top = height/2 - (height/2) % BLOCK;
				bot = top;
				/* initial block */
                BitBlt(hDC, left, top, BLOCK, BLOCK, h_memDC, left, top, SRCCOPY);
				while (bot < height || right < width) {
			        /* top edge */
					if (top > 0) {
	                    top -= BLOCK;
	                    for (x=left;x<=right;x+=BLOCK)
    	                    BitBlt(hDC, x, top, BLOCK, BLOCK, h_memDC, x, top, SRCCOPY);
					} /* end if (more to go on top edge) */
	    		    /* right edge */
					if (right < width) {
	                    right += BLOCK;
	                    for (y=top;y<=bot;y+=BLOCK)
    	                    BitBlt(hDC, right, y, BLOCK, BLOCK, h_memDC, right, y, SRCCOPY);
					} /* end if (more to go on right edge) */
			        /* bottom edge */
					if (bot < height) {
	                    bot += BLOCK;
	                    for (x=right;x>=left;x-=BLOCK)
    	                    BitBlt(hDC, x, bot, BLOCK, BLOCK, h_memDC, x, bot, SRCCOPY);
					} /* end if (more to go on bottom edge) */
	    		    /* left edge */
					if (left >0) {
	                    left -= BLOCK;
	                    for (y=bot;y>=top;y-=BLOCK)
    	                    BitBlt(hDC, left, y, BLOCK, BLOCK, h_memDC, left, y, SRCCOPY);
					} /* end if (more to go on left edge) */


			        while (GetTickCount() < nextTime);
			        nextTime += 50;
                } //end while (not done spiral out)
		} /* end if (outward spiral */


	return 0;
} /* end function (bmpSpiral) */


#define BIT0    0x00000001
#define BIT2    0x00000004
#define BIT15   0x00008000
#define BIT16   0x00010000
#define BIT17   0x00020000
#define SEQ     (BIT17)

/**************************************************************************
*  Function Name: bmpBlocks
**************************************************************************/
int bmpBlocks (HDC hDC, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
unsigned long seed;
unsigned long value, maxvalue;
unsigned long x, y, i;
unsigned long fill, mask= (BIT16 | BIT15 | BIT2 | BIT0);
unsigned long tmp, cnt, shft;
unsigned long width = p_binfo->bmiHeader.biWidth/BLOCK, 
			  height = p_binfo->bmiHeader.biHeight;

		/* maximum random value that is useful */
		maxvalue = height/BLOCK* width;
        seed = SEQ-1;

		SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, p_binfo, DIB_PAL_COLORS);

        for (i=0, value=seed;;i++)
        {
                fill = 0L;
                /* mask out randomize bits */
                tmp = (value & mask);
                /* if the number of bits is odd, fill with a one */
                shft = BIT0;
                cnt = 0;
                while (shft < SEQ) {
                        if (tmp & shft)
                                cnt++;
                        shft <<= 1;
                }
                if (cnt & BIT0)
                        fill = BIT0;
                /* range and fill */
                value <<= 1;
                value |= fill;
                value &= (SEQ-1);
                if (value == seed)
                        break;
				/* discard value if out of range */
				if (value > maxvalue)
					continue;
				/* compute x and y coordinates to display block */
				y = (value/width) * BLOCK;
				x = (value % width) * BLOCK;
                BitBlt(hDC, (WORD)x, (WORD)y, BLOCK, BLOCK, h_memDC, (WORD)x, (WORD)y, SRCCOPY);
        }

		/* fill 0,0 */
        BitBlt(hDC, 0, 0, BLOCK, BLOCK, h_memDC, 0, 0, SRCCOPY);

		return 0;

} /* end function (bmpBlocks) */
/**************************************************************************
*  Function Name: bmpFade
**************************************************************************/
int bmpFade (HDC hDC, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
				HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
LOGPALETTE 	*p_fadepal;
HPALETTE 	h_fadepal;
WORD 		w_colors;
int 		k;
DWORD 		nextTime = GetTickCount() + 200;

	/* make sure the driver supports palette animateion */
	if (!(RC_PALETTE & GetDeviceCaps (hDC, RASTERCAPS)))	{
		MessageBox (NULL, "Palette Animation not Supported","",MB_OK);
		return -1;
	} /* end if (palette animation not supported) */

	/* compute number colors in image */
	if (p_binfo->bmiHeader.biClrUsed != 0)
		w_colors = p_binfo->bmiHeader.biClrUsed;
	else
	    w_colors=(1 << (p_binfo->bmiHeader.biBitCount*p_binfo->bmiHeader.biPlanes));

	/* allocate animation palette	 */
    if ((p_fadepal = (LOGPALETTE *)malloc (sizeof(LOGPALETTE) +
					(w_colors-1)*sizeof(PALETTEENTRY))) == NULL)
    {   return -1;
    } //End if (error allocating palette)

    /* copy the image palette to the animatoin palette */
    memcpy (p_fadepal, p_pal, (sizeof(LOGPALETTE) + (w_colors-1)*sizeof(PALETTEENTRY)));

	/* create the initial animation palette; all white except for the first and last entries, which
	are probably white and black */
    for (k=1; k<(int)w_colors-1;k++) {
		p_fadepal->palPalEntry[k].peGreen = 255;
		p_fadepal->palPalEntry[k].peRed= 255;	
		p_fadepal->palPalEntry[k].peBlue= 255;
		p_fadepal->palPalEntry[k].peFlags = PC_RESERVED;
	}

	/* grab the system palette entries */
	UsePalette (h_memDC, TRUE);

	/* realize the animation palette into the display context */	
	h_fadepal = CreatePalette (p_fadepal);
    SelectPalette (h_memDC, h_fadepal, FALSE);
    RealizePalette (h_memDC);

	/* blast up the bitmap - it will appear in only the limited colors of the animation palette */
	SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, 
				p_binfo, DIB_PAL_COLORS);
	BitBlt(hDC, 0, 0, (WORD)p_binfo->bmiHeader.biWidth, 
			(WORD)p_binfo->bmiHeader.biHeight,
			 h_memDC, 0, 0, SRCCOPY);

	/* animate palette one color at a time */
    for (k=1; k<(int)w_colors-1;k++) {  
		AnimatePalette (h_fadepal, k, 1, &p_pal->palPalEntry[k]);
    	while (GetTickCount() < nextTime);
		/* compute wait interval - this formula shrinks the wait interval from 
		200ms for 16 color images to 5ms for 256 color images */
 		nextTime += 213L - ((LONG)w_colors*(195L))/240L;
	}

	/* release use of system palette */
	UsePalette (h_memDC, FALSE);

	/* restore things to the way they were */
	UnrealizeObject (h_pal);
    SelectPalette (hDC, h_pal, FALSE);
    SelectPalette (h_memDC, h_pal, FALSE);
	RealizePalette (hDC);
	RealizePalette (h_memDC);

	/* clean up resources */
	free (p_fadepal);
	DeleteObject (h_fadepal);

	/* prevent paint update of window which causes flicker */
	ValidateRect (hwndMain, NULL);

	return 0;

} /* end function (bmpFade) */
//***********************************************************************
// Function: UsePalette
//
// Purpose: Takes over or relinquishes the static area of the system palette
//
// Parameters:
//    hDC       == handle to DC to use
//    bNoStatic == flag indicating action to take
//
// Returns: No return
//
// Comments:
//  UsePalette does the following:
//  
//  1. If bNoStatic is TRUE, sets the system palette use to allow using 254
//  colors in the system palette, eliminating 18 of the 20 reserved colors.
//  Also, saves the system colors (for caption bars, window borders, etc.)
//  and changes them to black and white.
//
//  2. If bNoStatic is FALSE, sets the system palette use to restore the
//  18 reserved colors, so you can only use 236 colors. Also, restores
//  the system colors to their original values.
//
//  Borrowed from another sample, but forgot which.
//
// History: Date      Author        Reason
//
//***********************************************************************

#define RGBBlack    0x00000000L
#define RGBWhite    0x00FFFFFFL

VOID UsePalette(HDC hDC, BOOL bNoStatic)
{
  // Flag for whether we've initialized dwSysColors yet or not.
  static BOOL  fHaveSysColors = FALSE;

  // Array for holding old system colors
  static DWORD dwSysColors[21];

  // Black and white values for when we change the system colors
  static DWORD dwBWSysColors[21]
              = { RGBWhite,   // scrollbar
                  RGBWhite,   // background
                  RGBWhite,   // active caption
                  RGBWhite,   // inactive caption
                  RGBWhite,   // menu
                  RGBWhite,   // window
                  RGBBlack,   // window frame
                  RGBBlack,   // menu text
                  RGBBlack,   // window text
                  RGBBlack,   // caption text
                  RGBWhite,   // active border
                  RGBBlack,   // inactive border
                  RGBWhite,   // app workspace
                  RGBBlack,   // highlight
                  RGBWhite,   // highlight text
                  RGBWhite,   // button face
                  RGBBlack,   // button shadow
                  RGBBlack,   // gray text
                  RGBBlack,   // button text

                  RGBBlack,   // inactive caption text
                  RGBWhite }; // button highlight


  // Index array for setting the system colors
  static int iSysColorNdx[21] = { 0,1,2,3,4,5,6,7,8,9,10,11,
                                  12,13,14,15,16,17,18,19,20 };

  // If this is the first time we've been called, we need to 
  // get the current system colors.

  if (!fHaveSysColors)
    {
    int i;

    for(i=0; i<21; i++)
      dwSysColors[i] = GetSysColor(i);

    fHaveSysColors = TRUE;
    }

  // If we are taking over the palette, we want to change the
  // system colors first, so the appearance of flashing is
  // minimized. If we are releasing use of the whole palette,
  // we will do it at the end.
    
  if(bNoStatic)
    {
    // Set the system colors to black and white
    SetSysColors(21, iSysColorNdx ,dwBWSysColors);

    // Broadcast WM_SYSCOLORCHANGE
    SendMessage((HWND)0xFFFF, WM_SYSCOLORCHANGE, 0, 0L);
    }

  SetSystemPaletteUse(hDC, bNoStatic ? SYSPAL_NOSTATIC : SYSPAL_STATIC);

  // If we are releasing use of the whole palette, we change the
  // system colors back at the end to minimize the appearance of
  // flashing from the palette changes.

  if(!bNoStatic)
    {
    // Set the system colors to original colors
    SetSysColors(21, iSysColorNdx ,dwSysColors);

    // Broadcast WM_SYSCOLORCHANGE
    SendMessage((HWND)0xFFFF, WM_SYSCOLORCHANGE, 0, 0L);
    }
}

