/****************************************************************************

    PROGRAM: epaint.c

    PURPOSE: epaint template for Windows applications

    FUNCTIONS:

    WinMain() - calls initialization function, processes message loop
    InitApplication() - initializes window data and registers window
    InitInstance() - saves instance handle and creates main window
    MainWndProc() - processes messages
    About() - processes messages for "About" dialog box

    COMMENTS:

    Windows can have several copies of your application running at the
    same time.  The variable hInst keeps track of which instance this
    application is so that processing will be to the correct window.

****************************************************************************/

#include <windows.h>                /* required for all Windows applications */
#include <commdlg.h>
#include <stdlib.h>
#include <malloc.h>
#include "epaint.h"                /* specific to this program              */
#include "bitmap.h"
#include "hugemem.h"

HANDLE hInst;                       /* current instance                      */
HWND hwndMain;                  //handle to main window

char *szBMPFilter[] = {"BMP Files (*.BMP)","*.BMP",""};
static OPENFILENAME ofn;
extern BITMAPINFO *p_binfo;
extern LOGPALETTE *p_pal;
extern BYTE _huge *hp_bits;
extern HDC  h_memDC;
extern HBITMAP h_bmp;
extern HPALETTE h_pal;

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

    Windows recognizes this function by name as the initial entry point
    for the program.  This function calls the application initialization
    routine, if no other instance of the program is running, and always
    calls the instance initialization routine.  It then executes a message
    retrieval and dispatch loop that is the top-level control structure
    for the remainder of execution.  The loop is terminated when a WM_QUIT
    message is received, at which time this function exits the application
    instance by returning the value passed by PostQuitMessage().

    If this function must abort before entering the message loop, it
    returns the conventional value NULL.

****************************************************************************/

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                                 /* message                      */

    if (!hPrevInstance)                  /* Other instances of app running? */
    if (!InitApplication(hInstance)) /* Initialize shared things */
        return (FALSE);              /* Exits if unable to initialize     */

    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
    return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg,        /* message structure                      */
        NULL,                  /* handle of window receiving the message */
        NULL,                  /* lowest message to examine              */
        NULL))                 /* highest message to examine             */
    {
    TranslateMessage(&msg);    /* Translates virtual key codes           */
    DispatchMessage(&msg);     /* Dispatches message to window           */
    }
    return (msg.wParam);           /* Returns the value from PostQuitMessage */
}
/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

    This function is called at initialization time only if no other
    instances of the application are running.  This function performs
    initialization tasks that can be done once for any number of running
    instances.

    In this case, we initialize a window class by filling out a data
    structure of type WNDCLASS and calling the Windows RegisterClass()
    function.  Since all instances of this application use the same window
    class, we only need to do this when the first instance is initialized.


****************************************************************************/
BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;                    /* Class style(s).                    */
    wc.lpfnWndProc = (WNDPROC)MainWndProc;       /* Function to retrieve messages for  */
                    /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
    wc.lpszMenuName =  "epaintMenu";   /* Name of menu resource in .RC file. */
    wc.lpszClassName = "epaintWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));

}
/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

    This function is called at initialization time for every instance of
    this application.  This function performs initialization tasks that
    cannot be shared by multiple instances.

    In this case, we save the instance handle in a static variable and
    create and display the main program window.

****************************************************************************/

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = hwndMain = CreateWindow(
    "epaintWClass",                /* See RegisterClass() call.          */
    "Effects Sample Application",   /* Text for window title bar.         */
    WS_OVERLAPPEDWINDOW,            /* Window style.                      */
    CW_USEDEFAULT,                  /* Default horizontal position.       */
    CW_USEDEFAULT,                  /* Default vertical position.         */
    CW_USEDEFAULT,                  /* Default width.                     */
    CW_USEDEFAULT,                  /* Default height.                    */
    NULL,                           /* Overlapped windows have no parent. */
    NULL,                           /* Use the window class menu.         */
    hInstance,                      /* This instance owns this window.    */
    NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!hWnd)
    return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}
/****************************************************************************

    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_COMMAND    - application menu (About dialog box)
    WM_DESTROY    - destroy window

    COMMENTS:

    To process the IDM_ABOUT message, call MakeProcInstance() to get the
    current instance address of the About() function.  Then call Dialog
    box which will create the box according to the information in your
    epaint.rc file and turn control over to the About() function.  When
    it returns, free the intance address.

****************************************************************************/
int iBitmapWidth, iBitmapHeight;
int iXClient, iYClient;
int iXChar, iYChar;
int iHScrollPos, iVScrollPos;
int bitmaploaded;
HBITMAP           hBmp;
HPALETTE                hPal;
char szFileName[_MAX_PATH+1];
int gEffect;

LRESULT CALLBACK __export MainWndProc(HWND hWnd, UINT message,
                               WPARAM wParam, LPARAM lParam)
{
DWORD dw_r;
HDC hDC;
PAINTSTRUCT     ps;

    switch (message) {
    case WM_COMMAND:           /* message: command from application menu */
        switch (wParam)
        {
        case IDM_CLEAR:
            InvalidateRect (hWnd, NULL, TRUE);
            bitmaploaded = FALSE;
            break;
        case IDM_INWARDSPIRAL:
        case IDM_BLOCKS:
        case IDM_OUTWARDSPIRAL:
        case IDM_DIAGONAL:
        case IDM_HORZCRUSH:
        case IDM_VERTCRUSH:
        case IDM_FADE:
            hDC  = GetDC (hWnd);
            initOpenFile (szFileName, "BMP Files", "bmp", szBMPFilter);
                    if (loadBMPFile (szFileName, &p_binfo, &p_pal, &hp_bits) < 0) {
                        DeleteDC (hDC);
                        break;
                    }
                    dw_r= createBMDC (hDC, &h_memDC, p_binfo, p_pal);
                    h_bmp = (HBITMAP)LOWORD (dw_r);
                    h_pal = (HPALETTE)HIWORD (dw_r);
                    if (wParam == IDM_HORZCRUSH)
                        bmpCrush (hDC, IDM_HORZCRUSH, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_VERTCRUSH)
                        bmpCrush (hDC, IDM_VERTCRUSH, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_DIAGONAL)
                        bmpDiagonal (hDC, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_BLOCKS)
                        bmpBlocks (hDC, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_FADE)
                        bmpFade (hDC, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_INWARDSPIRAL)
                        bmpSpiral (hDC, IDM_INWARDSPIRAL, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
                    if (wParam == IDM_OUTWARDSPIRAL)
                        bmpSpiral (hDC, IDM_OUTWARDSPIRAL, p_binfo, p_pal, hp_bits,
                                    h_memDC, h_bmp, h_pal);
            bitmaploaded = TRUE;
            ReleaseDC (hWnd, hDC );
            DeleteDC (h_memDC);
            DeleteObject (h_bmp);
            DeleteObject (h_pal);
            break;
        default:
            return (DefWindowProc(hWnd, message, wParam, lParam));

        } //End switch (wParam)
        break;
     case WM_CREATE:
         break;
     case WM_PAINT:
        hDC=BeginPaint(hWnd,&ps);
        if (bitmaploaded)
        {
                dw_r= (DWORD)(HBITMAP)createBMDC (hDC, &h_memDC, p_binfo, p_pal);
                h_bmp = (HBITMAP)LOWORD (dw_r);
                h_pal = (HPALETTE)HIWORD (dw_r);
                dispBitmap (hDC, h_memDC, h_bmp, p_binfo, hp_bits);
                DeleteDC (h_memDC);
                DeleteObject (h_bmp);
                DeleteObject (h_pal);
        } /* endif (bitmap loaded) */
        EndPaint (hWnd, &ps);
        break;
    case WM_DESTROY:
            if (bitmaploaded) {
                HugeFree (hp_bits);
                free (p_binfo);
                free (p_pal);
            }
        PostQuitMessage(0);
        break;
    case WM_SIZE:
        break;
    default:
        return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (DefWindowProc(hWnd, message, wParam, lParam));
}
/****************************************************************************
    FUNCTION: initOpenFile
****************************************************************************/
int initOpenFile (char FAR *szFileName, char FAR *szTitle,
                    char FAR *szExt, char * FAR *szFilter)
{

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = NULL;
    ofn.hInstance = NULL;
    ofn.lpstrFilter = szFilter[0];
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter = 0;
    ofn.nFilterIndex = 0;
    ofn.lpstrFile = szFileName;
    ofn.nMaxFile = _MAX_PATH;
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;
    ofn.lpstrInitialDir = NULL;
    ofn.lpstrTitle = szTitle;
    ofn.Flags = OFN_CREATEPROMPT;
    ofn.nFileOffset = 0;
    ofn.nFileExtension = 0;
    ofn.lpstrDefExt = szExt;
    ofn.lCustData = 0L;
    ofn.lpfnHook = NULL;
    ofn.lpTemplateName = NULL;

    return GetOpenFileName (&ofn);
}
