/**************************************************************************
*  Function Name: bmpFade
**************************************************************************/
int bmpFade (HDC hDC, BITMAPINFO *p_binfo, LOGPALETTE *p_pal, BYTE _huge *hp_bits,
                HDC  h_memDC, HBITMAP h_bmp, HPALETTE h_pal)
{
LOGPALETTE  *p_fadepal;
HPALETTE    h_fadepal;
WORD        w_colors;
int         k;
DWORD       nextTime = GetTickCount() + 200;

    /* make sure the driver supports palette animation */
    if (!(RC_PALETTE & GetDeviceCaps (hDC, RASTERCAPS)))    {
        MessageBox (NULL, "Palette Animation not Supported","",MB_OK);
        return -1;
    } /* end if (palette animation not supported) */

    /* compute number colors in image */
    if (p_binfo->bmiHeader.biClrUsed != 0)
        w_colors = p_binfo->bmiHeader.biClrUsed;
    else
        w_colors=(1 << (p_binfo->bmiHeader.biBitCount*p_binfo->bmiHeader.biPlanes));

    /* allocate animation palette    */
    if ((p_fadepal = (LOGPALETTE *)malloc (sizeof(LOGPALETTE) +
                    (w_colors-1)*sizeof(PALETTEENTRY))) == NULL)
    {   return -1;
    } //End if (error allocating palette)

    /* copy the image palette to the animation palette */
    memcpy (p_fadepal, p_pal, (sizeof(LOGPALETTE) + (w_colors-1)*sizeof(PALETTEENTRY)));

    /* create the initial animation palette; all white except for the first and last entries, which
    are probably white and black */
    for (k=1; k<(int)w_colors-1;k++) {
        p_fadepal->palPalEntry[k].peGreen = 255;
        p_fadepal->palPalEntry[k].peRed= 255;   
        p_fadepal->palPalEntry[k].peBlue= 255;
        p_fadepal->palPalEntry[k].peFlags = PC_RESERVED;
    }

    /* grab the system palette entries */
    UsePalette (h_memDC, TRUE);

    /* realize the animation palette into the display context */    
    h_fadepal = CreatePalette (p_fadepal);
    SelectPalette (h_memDC, h_fadepal, FALSE);
    RealizePalette (h_memDC);

    /* blast up the bitmap - it will appear in only the limited colors of the animation palette */
    SetDIBits(h_memDC, h_bmp, 0, (WORD)p_binfo->bmiHeader.biHeight, hp_bits, 
                p_binfo, DIB_PAL_COLORS);
    BitBlt(hDC, 0, 0, (WORD)p_binfo->bmiHeader.biWidth, 
            (WORD)p_binfo->bmiHeader.biHeight,
             h_memDC, 0, 0, SRCCOPY);

    /* animate palette one color at a time */
    for (k=1; k<(int)w_colors-1;k++) {  
        AnimatePalette (h_fadepal, k, 1, &p_pal->palPalEntry[k]);
        while (GetTickCount() < nextTime);
        /* compute wait interval - this formula shrinks the wait interval from 
        200ms for 16 color images to 5ms for 256 color images */
        nextTime += 213L - ((LONG)w_colors*(195L))/240L;
    }

    /* release use of system palette */
    UsePalette (h_memDC, FALSE);

    /* restore things to the way they were */
    UnrealizeObject (h_pal);
    SelectPalette (hDC, h_pal, FALSE);
    SelectPalette (h_memDC, h_pal, FALSE);
    RealizePalette (hDC);
    RealizePalette (h_memDC);

    /* clean up resources */
    free (p_fadepal);
    DeleteObject (h_fadepal);

    /* prevent paint update of window which causes flicker */
    ValidateRect (hwndMain, NULL);

    return 0;

} /* end function (bmpFade) */

