/*****************************************************/
/* teelist.c                                         */
/* -- Application displays DOS box stderr & stdout.  */
/* -- To build:                                      */
/*    cc -2 -d -DSTRICT teelist.c teedll.lib         */
/*****************************************************/
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include "wddjtee.h"

#define cidEdit 1 /* Edit control ID. */

char const szMainClass[] = "TeeMain"; /* Main class. */
char const szOutClass[] = "TeeOut";   /* Output cls */
char const szTitle[] = "DOS Box Output";
LPSTR      lprgch;                    /* Read buf. */

void AppendSz(HWND hwnd, LPSTR lpsz, BOOL fShow);
HWND HwndFindHvm(HWND hwndOwner, DWORD hvm);
LRESULT CALLBACK __export LwOutWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK __export LwMainWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);

int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    HWND hwnd;
    MSG  msg;

    if (NULL == hinsPrev)
        {
        WNDCLASS wcs;

        wcs.style = 0;
        wcs.lpfnWndProc = LwMainWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szMainClass;
        if (!RegisterClass(&wcs))
            return FALSE;

        wcs.lpfnWndProc = LwOutWndProc;
        wcs.cbWndExtra = sizeof(DWORD);
        wcs.lpszClassName = szOutClass;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    if (NULL == (lprgch = GlobalAllocPtr(GMEM_MOVEABLE,
      (long)cbReadMax + 1)))
        return FALSE;

    msg.wParam = 0;
    if (NULL != (hwnd = CreateWindow(szMainClass,
      szTitle, WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)))
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    GlobalFreePtr(lprgch); /* No need, really. */
    return msg.wParam;
    }

LRESULT CALLBACK __export LwMainWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Main window procedure.                         */
/*****************************************************/
    {
    HWND hwndT;
    RECT rect;
    char szBuf[32];

    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        FRegisterWnd(hwnd);
        break;

    case WM_DESTROY:
        FUnregisterWnd(hwnd);
        PostQuitMessage(0);
        break;

    case wmVMCreate:
        GetClientRect(hwnd, &rect);
        ClientToScreen(hwnd, (LPPOINT)&rect);
        wsprintf(szBuf, "VM 0x%lx", lParam);
        CreateWindow(szOutClass, szBuf, WS_CAPTION |
          WS_POPUPWINDOW | WS_THICKFRAME | WS_VISIBLE,
          rect.left, rect.top, rect.right, rect.bottom,
          hwnd, NULL, GetWindowInstance(hwnd),
          (LPVOID)lParam);
        return 0;

    case wmVMDestroy:
        if (NULL !=
          (hwndT = HwndFindHvm(hwnd, lParam)))
            DestroyWindow(hwndT);
        return 0;

    case wmDataReady:
        if (NULL !=
          (hwndT = HwndFindHvm(hwnd, lParam)))
            SendMessage(hwndT, wm, 0, 0);
        return 0;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

HWND HwndFindHvm(HWND hwndOwner, DWORD hvm)
/*****************************************************/
/* -- Return the owned popup for the given VM.       */
/*****************************************************/
    {
    HWND hwndT;
    char szBuf[32];

    for (hwndT = GetWindow(hwndOwner, GW_HWNDFIRST);
      NULL != hwndT;
      hwndT = GetWindow(hwndT, GW_HWNDNEXT))
        {
        GetClassName(hwndT, szBuf, sizeof(szBuf) - 1);
        if (!lstrcmp(szBuf, szOutClass) &&
          (DWORD)GetWindowLong(hwndT, 0) == hvm)
            return hwndT;
        }
    return NULL;
    }

LRESULT CALLBACK __export LwOutWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Output window procedure.                       */
/*****************************************************/
    {
    LPVOID lpv;
    UINT   cchEdit, cchRead;
    long   cchT;
    HWND   hwndEdit;
    BOOL   fOver = FALSE;

    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        SetWindowLong(hwnd, 0, (DWORD)
          ((LPCREATESTRUCT)lParam)->lpCreateParams);
        if (NULL ==
          (lpv = GlobalAllocPtr(GHND, 0x00010000)))
            return -1;
        if (NULL == (hwndEdit = CreateWindow("edit",
          NULL, WS_CHILD | WS_VISIBLE | WS_VSCROLL |
            WS_HSCROLL | ES_MULTILINE | ES_READONLY,
          0, 0, 0, 0, hwnd, (HMENU)cidEdit,
          (HINSTANCE)SELECTOROF(lpv), NULL)))
            {
            GlobalFreePtr(lpv);
            return -1;
            }
        SendMessage(hwndEdit, EM_LIMITTEXT, 0, 0);
        SendMessage(hwndEdit, WM_SETFONT,
          (WPARAM)GetStockObject(OEM_FIXED_FONT), 0);
        break;

    case WM_SIZE:
        SetWindowPos(GetDlgItem(hwnd, cidEdit), NULL,
          0, 0, LOWORD(lParam), HIWORD(lParam),
          SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
        break;

    case wmDataReady:
        hwndEdit = GetDlgItem(hwnd, cidEdit);
        cchEdit = (UINT)SendMessage(hwndEdit,
          WM_GETTEXTLENGTH, 0, 0);
        cchRead = CchReadHvm(GetWindowLong(hwnd, 0),
          lprgch, &fOver);
        if ((long)cchEdit + cchRead > 0x8000)
            {
            SendMessage(hwndEdit, WM_SETREDRAW, FALSE,
              0);
            cchT = cchRead + cchEdit - 0x8000;
            if (cchT > 0xffff)
                cchT = 0xffff;
            SendMessage(hwndEdit, EM_SETSEL, 0,
              MAKELONG(0, cchT));
            SendMessage(hwndEdit, EM_REPLACESEL, 0,
              (LPARAM)(LPSTR)"");
            SendMessage(hwndEdit, WM_SETREDRAW, TRUE,
              0);
            }
        lprgch[cchRead] = 0;
        if (fOver)
            AppendSz(hwndEdit,
              "\r\n***Overflow***\r\n", FALSE);
        AppendSz(hwndEdit, lprgch, FALSE);
        AppendSz(hwndEdit, NULL, TRUE);
        return 0;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

void AppendSz(HWND hwnd, LPSTR lpsz, BOOL fShow)
/*****************************************************/
/* -- Append the given string to the edit control.   */
/*****************************************************/
    {
    UINT cch;

    cch =
      (UINT)SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0);
    SendMessage(hwnd, EM_SETSEL, fShow ? 0 : 1,
      MAKELONG(cch, -1));
    if (NULL != lpsz)
        SendMessage(hwnd, EM_REPLACESEL, 0,
          (LPARAM)lpsz);
    }
