////////////////////////////////////////////////////////////
// record.h                                               //
// -- Interface to dll that provides sndRecordSound()     //
//    function.                                           //
// -- Written by Paul R. Bonneau 03/04/95.                //
////////////////////////////////////////////////////////////
UINT WINAPI __export
  sndRecordSound(LPSTR lpszFile, LPPCMWAVEFORMAT lpwft);
BOOL WINAPI __export
  FGetErrSz(UINT err, LPSTR lpsz, UINT cb);

////////////////////////////////////////////////////////////
// Error values.                                          //
////////////////////////////////////////////////////////////
// Success.  No error.
#define errNil          0

// All non-mmsystem errors start from this number.
#define errBase         1000

// A sound is already being recorded.
#define errBusy         (errBase + 0)

// No sound recording device was found.
#define errNoDevice     (errBase + 1)

// Out of memory.
#define errOutOfMemory  (errBase + 2)

// Error creating output file.
#define errCreateFile   (errBase + 3)

// Error writing to output file.
#define errWriteFile    (errBase + 4)

// No sound is being recorded.
#define errNotRecording (errBase + 5)
