////////////////////////////////////////////////////////////
// recrdemo.c                                             //
// -- Program demonstrates recording audio to a file      //
//    using record.dll.                                   //
// -- Written by Paul R. Bonneau 03/04/95.                //
////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include "record.h"
#include "recrdemo.h"

////////////////////////////////////////////////////////////
// Prototypes.                                            //
////////////////////////////////////////////////////////////
// Exports.
BOOL CALLBACK __export FDlgProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam);

// Private
void ReportErr(UINT err, HWND hwnd);

////////////////////////////////////////////////////////////
// Globals.                                               //
////////////////////////////////////////////////////////////
char szAudioFile[] = "mysound.wav";
char szAppName[]   = "Audio Recording Demo";

////////////////////////////////////////////////////////////
// Routines.                                              //
////////////////////////////////////////////////////////////
#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpszCmd, int wShow)
////////////////////////////////////////////////////////////
// -- Entry point.                                        //
////////////////////////////////////////////////////////////
    {
    return DialogBox(hins, MAKEINTRESOURCE(dlgRecord),
      (HWND)NULL, FDlgProc);
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK __export FDlgProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam)
////////////////////////////////////////////////////////////
// -- Main dialog procedure.                              //
////////////////////////////////////////////////////////////
    {
    UINT err;

    switch (wm)
        {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        switch (wParam)
            {
        default:
            break;

        case idcStart:
            // First stop any recording in progress.
            sndRecordSound(NULL, NULL);
            if (errNil != (err =
              sndRecordSound(szAudioFile, NULL)))
                ReportErr(err, hwnd);
            return TRUE; // End case idcStart.

        case idcStop:
            sndPlaySound(NULL, SND_NODEFAULT);
            sndRecordSound(NULL, NULL);
            return TRUE; // End case idcStop.

        case idcPlay:
            // First stop any playback in progress.
            sndPlaySound(NULL, SND_NODEFAULT);
            sndPlaySound(szAudioFile, SND_ASYNC | SND_NODEFAULT);
            return TRUE;

        case IDOK:
        case IDCANCEL:
            EndDialog(hwnd, 0);
            return TRUE; // End case IDOK/IDCANCEL.
            }            // End switch wParam.
        break;           // End case WM_COMMAND.
        } // End switch wm.

    return FALSE;
    }

void ReportErr(UINT err, HWND hwnd)
////////////////////////////////////////////////////////////
// -- Report an error.                                    //
////////////////////////////////////////////////////////////
    {
    char szBuf[256];

    if (!FGetErrSz(err, szBuf, sizeof szBuf))
        lstrcat(szBuf, "Unknown error occured");
    MessageBox(hwnd, szBuf, szAppName, MB_OK | MB_ICONSTOP);
    }
