///////////////////////////////////////////////////////////////////////////////
// File		: espytest.cpp
// Purpose 	: Sample app that demonstrates the use of the Espy debugger.
// Author	: Karl Schorr
// Date		: 6 Feb. 1995
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <windows.h> 
#include "espy.h"


class CTheApp : public CWinApp
{
public:
	BOOL InitInstance();
};


class TestClass
{
public:  
	void DoSomething();
};

// Create the application object
CTheApp NEAR theApp;


BOOL CTheApp::InitInstance()
{
	// Initialize the Espy utility
	EspyInit();
	
	TestClass TestObject;
	            
	// Test simple exception handling
	TRY
	{     
		TestObject.DoSomething();
	}
	CATCH (CMemoryException, e)
	{           
		ESPY_CATCH(CTheApp::InitInstance(), e)
		return FALSE;	               
	}
	END_CATCH 
     

	// Test polymorphic exception handling
	TRY
	{
		TestObject.DoSomething();
	}
	CATCH (CException, e)
	{               
		ESPY_CATCH(CTheApp::InitInstance(), e)
		return FALSE;
	}
	END_CATCH  
	
	
	// Test nested TRY blocks
	TRY
	{
		TRY
		{
			TestObject.DoSomething();
		}
		CATCH (CMemoryException, e)
		{
			ESPY_CATCH(CTheApp::InitInstance(), e)
			THROW_LAST()
		}
		END_CATCH
	}
	CATCH (CMemoryException, e)
	{
		ESPY_CATCH(CTheApp::InitInstance(), e)
		return FALSE;
	}
	END_CATCH
	    
	return TRUE;
}


void TestClass::DoSomething()
{                              
UINT fuFlags(0);
	
	ESPY_THROW(TestClass::DoSomething(), EX_MEMORY)

	if (::GetFreeSpace(fuFlags) < 10000)	
		AfxThrowMemoryException();
		
	// Further processing here
}

///////////////////////////////////////////////////////////////////////////////
/* End of file */
