//
// BUG015A.CPP
//
// This is a very simple C program using public derivation.
// It works just as you would expect when compiled using
// the default options of Borland C++.  However, if you try
// to compile it with RTTI disabled using the -RT- command
// line switch, the compiler generates this confusing
// error message:
//
// Error bug015a.cpp 33: 'Base' is not a polymorphic class
// type in function main()
//
// For some reason, the compiler is not happy about our
// virtual destructor!
//

#include <iostream.h>

class Base {
  public :
    Base(){ cout << "Constructing Base\n"; }
    virtual ~Base(){ cout << "Destroying Base\n"; }
};

class Derived : public Base {
  public :
    Derived(){ cout << "Constructing Derived\n"; }
    virtual ~Derived(){ cout << "Destroying Derived\n"; }
};

main()
{
  Base *p = new Derived;
  delete p;
  return 0;
}
