Listing 2: What Borland's farcoreleft() really does

//
// FARCORE.CPP
//
// This program demonstrates a not so obvious
// characteristic of Borland's farcoreleft()
// function.  farcoreleft() doesn't actually
// tell you how much memory is ready for use in
// your heap.  Instead, it tells you how much
// memory is in between the top of available
// memory and the highest allocated block.  This
// makes this function a lot less useful!
//

#include <iostream.h>
#include <alloc.h>

main()
{
    long memory = farcoreleft();
    cout << "Memory at startup: "
         << farcoreleft()
         << endl;
    void _far *p1 = farmalloc( memory - 256 );
    void _far *p2 = farmalloc( 1 );
    cout << "After allocating most available memory: "
         << farcoreleft()
         << endl;
    farfree( p1 );
    cout << "After freeing all but 1 byte: "
         << farcoreleft()
         << endl;
    farfree( p2 );
    cout << "After freeing 1 byte: "
         << farcoreleft()
         << endl;
    return 0;
}


