// WSLAVE.CPP
//
#include <stdio.h>
#include <io.h>        
#include <fcntl.h>        
#include <share.h>
#include <stdlib.h>
#include <process.h>

// SC and VC want 'char const * const *' and won't implicitly
// convert them
#if defined(_MSC_VER) || defined(__SC__)
typedef char const * const *ARGV_TYPE;
#else
typedef char **ARGV_TYPE;
#endif

int main(int argc, ARGV_TYPE argv)
{              
    if (argc < 3)
    {
        puts("Usage: WSLAVE outfile command ...\n"
             "** Meant to be run by WMASTER **\n");
        exit(1);
    }              
    // open shared so both can use at once
    int outFile = sopen(argv[1], O_WRONLY, SH_DENYNO);
    if (outFile == -1)
    {               
        puts("Could not open output file!!");
        return 2;
    }              
    // send errors and data to log file
    dup2(outFile, 1); // STDOUT
    dup2(outFile, 2); // STDERR
    close(outFile);
    // echo the command for clarity
    for (int arg = 2; arg < argc-1; ++arg)
    {
        fputs(argv[arg], stdout);
	putchar(' ');
    }
    puts(argv[arg]);
    // do it (doesn't come back if it goes well)
    execvp(argv[2], argv+2);
    // we failed
    fputs("exec failed", stderr);
    return 1;
}
