/* listing 4 - hktest.c    Test application for hotkeyhk.dll
   copyright 1994 Robert Mashlan
*/
#define STRICT
#include <windows.h>
#include <string.h>

#include "hotkeyhk.h"

// define three test hot keys
#define HOTKEY1 ALT_BIT+CONTROL_BIT+SHIFT_BIT+VK_F2
#define HOTKEY2 ALT_BIT+CONTROL_BIT+'A'
#define HOTKEY3 ALT_BIT+SHIFT_BIT+VK_PRIOR

LRESULT CALLBACK _export MainWndProc( HWND hwnd, UINT msg,
   WPARAM wParam, LPARAM lParam )
{
   static UINT wm_hotkeypressed; // notification message
   switch(msg) {
      case WM_CREATE:
         wm_hotkeypressed =
            RegisterWindowMessage(HOTKEYPRESSED);
         // active the hot keys
         AddHotKey(hwnd,HOTKEY1,1);
         AddHotKey(hwnd,HOTKEY2,2);
         AddHotKey(hwnd,HOTKEY3,3);
         return 0;

      case WM_DESTROY:
         RemoveHotKey(hwnd,0);  // remove all hot keys
         PostQuitMessage(0);
         return 0;

      default:
         if( wm_hotkeypressed && msg == wm_hotkeypressed ){
            // beep and display message
            MessageBeep(0);
            MessageBox(hwnd,"Hot Key Pressed!",
               "Hot Key Test",MB_OK);
            return 0;
         }
   }
   return DefWindowProc(hwnd,msg,wParam,lParam);
}

int MessagePump(void)
{
   MSG msg;
   while( GetMessage(&msg,NULL,0,0) ) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

#pragma argsused
int PASCAL WinMain( HINSTANCE hInst, HINSTANCE hPrevInst,
                    LPSTR lpstrCmdLine, int nCmdShow )
{
   char szClassName[] = "Hot Key Test";
   HWND hwnd;

   if(!hPrevInst) {
      WNDCLASS wc;
      memset(&wc,0,sizeof(wc));
      wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
      wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wc.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wc.lpfnWndProc   = MainWndProc;
      wc.lpszClassName = szClassName;
      wc.hInstance     = hInst;
      RegisterClass(&wc);
   }
   hwnd = CreateWindow(szClassName,szClassName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT,CW_USEDEFAULT,250,250,
                       NULL,NULL,hInst,NULL);
   if(hwnd) {
      ShowWindow(hwnd,nCmdShow);
      UpdateWindow(hwnd);
      return MessagePump();
   }
   return -1;
}

