/* listing 1 - hotkey.c  Demonstrates the use of WM_SETHOTKEY
   copyright 1994 Robert Mashlan
*/
#define STRICT
#include <windows.h>
#include <string.h>

// these aren't defined in 16-bit windows.h
#define WM_SETHOTKEY 0x0032
#define WM_GETHOTKEY 0x0033

// defines for upper byte of hot key descriptor
#define SHIFT 0x0100
#define CTRL  0x0200
#define ALT   0x0400

// hotkey we assign to our app
#define HOTKEY (CTRL+ALT+'H')

LRESULT CALLBACK _export MainWndProc( HWND hwnd, UINT msg,
   WPARAM wParam, LPARAM lParam )
{
   switch(msg) {
      case WM_CREATE: {
         char *msg = NULL;
         switch( SendMessage(hwnd,WM_SETHOTKEY,HOTKEY,0) ){
             case 2:
                msg = "hot key is used by another app";
                break;
             case 0:
                msg = "WM_SETHOTKEY failed, invalid HWND";
                break;
             case -1:
                msg = "WM_SETHOTKEY failed,"
                      " invalid hot key";
                break;
         }
         if(msg)
            MessageBox(hwnd,msg,"WM_SETHOTKEY",MB_OK);
         return 0;
       }

      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(hwnd,msg,wParam,lParam);
}

int MessagePump(void)
{
   MSG msg;
   while( GetMessage(&msg,NULL,0,0) ) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

#pragma argsused
int PASCAL WinMain( HINSTANCE hInst, HINSTANCE hPrevInst,
                    LPSTR lpstrCmdLine, int nCmdShow )
{
   char szClassName[] = "WM_SETHOTKEY Test";
   HWND hwnd;

   if(!hPrevInst) {
      WNDCLASS wc;
      memset(&wc,0,sizeof(wc));
      wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
      wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wc.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wc.lpfnWndProc   = MainWndProc;
      wc.lpszClassName = szClassName;
      wc.hInstance     = hInst;
      RegisterClass(&wc);
   }
   hwnd = CreateWindow(szClassName,szClassName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT,CW_USEDEFAULT,250,250,
                       NULL,NULL,hInst,NULL);
   if(hwnd) {
      ShowWindow(hwnd,nCmdShow);
      UpdateWindow(hwnd);
      return MessagePump();
   }
   return -1;
}

