/***************
 *** ALARM.C - copa demo to make a reminder window appear
 *** at a given time.  Usage: alarm &
 ***
 */
#include <stdio.h>
main()
{
int h, m, s;
char buf[80];
char userin[80], msg[80];
int sec, ah, am, nowsec, thensec;

/* create window.. */
copa_window( 300, 100, 5.0, 3.0, "Alarm (copa)", 0.9 );

AGAIN:
/* get time.. */
systime( &h, &m, &s );

sprintf( buf, "Time now is %02d:%02d.\nEnter alarm time:", h, m );

/* change popup data entry area to large text, length 8 characters.. */
copa_setmec( "_POPD1", "text/size", "30" );

/* do the data entry popup.. */
copa_popentry( buf, "", 8, buf );

/* get hours and minutes... */
sscanf( buf, "%d:%d", &ah, &am );
if( ah > 23 || am > 59 || ah < 0 || am < 0 ) {
	copa_pop( "Invalid time..", "Try again,Exit", userin );
	if( userin[0] == 'E' ) exit(0);
	goto AGAIN;
	}

/* change popup data entry area to normal size, length 40.. */
copa_setmec( "_POPD1", "text/size", "10" );

/* get optional message */
copa_popentry( "Message:", "", 40, msg );
if( strcmp( msg, ".!none" )==0 ) msg[0] = '\0';

/* figure difference in seconds between now and alarm time.. */
nowsec = (m * 60) + (h * 3600);
thensec = (am * 60) + (ah * 3600);
/* handle the crossing of midnight.. */
if( nowsec > thensec ) nowsec -= 86400;
sec = thensec - nowsec;


/* make window disappear.. */
copa_display( "disappear" );

/* suspend until time is up.. */
sleep( sec );

/* re-display window with message.. */
copa_display( "appear" );

sprintf( buf, "The time is %02d:%02d\n\n%s", ah, am, msg );
copa_pop( buf, "OK", userin );
exit(0);
}

/*
 *** this routine is included in the plot stuff.. ***
 *
 * systime( int *hour, int *min, int *sec )
 * {
 *	int	tvec[2], *dtime ;
 *
 *	time( tvec );
 *	dtime = (int *)localtime( tvec );
 *	*hour = *(dtime+2) ;
 *	*min = *(dtime+1)  ;
 *	*sec = *(dtime)  ;
 * }
*/
