#!/bin/sh
## **************************************************************
# BROWSER.SH
# A simple gui man page browser application using copa
## ************************************************************* 

### have more(1) pause when finished..
PAGER="more -s -w"    ## solaris only?
export PAGER

which copa

### start copa.. 
copa_window 300 100 9.0 8.0 "Copa manpage browser (sh)" 0.9 &
sleep 1

### hold off on displaying the panel..
copa display holdrefresh

### load the control panel file..
copa panload examples/basic.pan b1

### loop on search words..
while :
do

    ### get the search word..
    WORD=`copa popentry "Enter a word to search on" "" 20`

    ### put up an in-progress message..
    copa popmsg "In progress.." ""

    ### run man -k and capture results into the textbox
    copa text TEXT "!man -k $WORD"

    copa popclear

    ### now display it
    copa display refresh

    PAGE=none

    ### loop on panel selections..
    while :
    do

	### get user action
	PICK=`copa get`

	if [ "$PICK" = "Exit" ]; then
	    copa quit
	    exit

	elif [ "$PICK" = "New search" ]; then
	    break

	elif [ "$PICK" = "View man page" ]; then
	    if [ "$PAGE" = "none" ]; then
		ANS=`copa pop "Nothing selected yet." OK`
		continue
	    fi

	    ### otherwise, display the man page in an xterm..
	    xterm -e man $PAGE 

	elif [ "$PICK" = "Print man page" ]; then
	    if [ "$PAGE" = "none" ]; then
		ANS=`copa pop "Nothing selected yet." OK`
		continue
	    fi

	    ### otherwise, print the man page..
	    man -t $PAGE

	else
	    ### user made a selection from the list..
	    PAGE=$PICK
        fi
     done

done
