/**************************************************************
 * DEMO.C
 * This is a demo program which uses most of the COPA C functions.
 * See demo.sh for an equivalent program written in Bourne shell.
 ************************************************************** 
*/

#include <stdio.h>
main( )
{

/* ------|---------|---------|---------|---------|---------|---------|---------| */
char userin[80];
char buf[80], key[12], xpos[12], ypos[12];
int len;


/* start copa.. */
copa_window( 300, 100, 9.0, 8.0, "Copa demo (C lang)", 0.9 );

TOP:

copa_version();

copa_pop( 
"Welcome to copa.\n\
Copa is a kit for developing gui control panels.\n\
This is a demo program which will introduce you to\n\
some of the capabilities of copa.  This demo\n\
was written in C and compiled using the included\n\
object library copa.a.  Copa can also be used in\n\
shell scripts, perl programs, and other environments.\n\n\
This demo should be run in the examples directory.  It\n\
doesn't do anything other than echo your\n\
responses to standard output.\n\n\
(To respond, click on the button of your choice.)\n\
Do you want to continue?"  ,   "Yes,No"  , userin  );

printf( "%s\n", userin );

if( userin[0] != 'Y' ){ copa_quit(); exit(0); }


/* adjust size of text in popup box to 10 point.. */
copa_setmec( "_POP", "text/size", "10" );

/* set size so scrolling occurs if over 35 lines.. */
copa_setmec( "_POP", "nlines", "35" );


/* produce a popup box.. */
copa_pop( "!cat ../Copyright", "Continue,Exit",  userin );

printf( "%s\n", userin );
if( strcmp( userin, "Exit" )==0 ) { copa_quit(); exit(0); }

/* adjust size of text in popup box to 12 point.. */
copa_setmec( "_POP", "text/size", "12" );
/* go back to auto-size.. */
copa_setmec( "_POP", "nlines", "0" );

copa_pop( 
"This and the preceding are examples\n\
of 'popup' boxes with buttons.  They can\n\
be produced by using the copa pop command.\n\
The user responds by clicking on the desired\n\
button with the mouse.", "OK,Exit", userin );

printf( "%s\n", userin );
if( strcmp( userin, "Exit" )==0 ) { copa_quit(); exit(0); }

/* do a dataentry popup box */
copa_popentry( 
"Here's an example of a popup box with a data entry\n\
area instead of buttons.  These can be produced by using\n\
the copa popentry command.  You can type in a response,\n\
or use the default if you wish.\n\n\
When finished, press ENTER, TAB, ESC, or click with the mouse.\n\n\
What town are you in?",  "Baltimore",  20, userin );

printf( "%s\n", userin );

copa_poplist( 
"Now this is an example of a popup box with a listbox\n\
which contains some selections, produced using the\n\
copa poplist command.  The listbox can be filled\n\
filled with literal text, or the results of a system\n\
command such as 'ls', or both.\n\n\
If there are lots of entries in the listbox, it will become\n\
scrollable and a scrolling control will appear automatically\n\
on the right side.\n\n\
Select an entry from the list by clicking on it with the mouse.\n\
(Again, this demo will just echo the file name)",
	"!ls", "Cancel,Exit",  userin );

printf( "%s\n", userin );
if( strcmp( userin, "Exit" )==0 ){ copa_quit(); exit(0); }



/* load slider panel */
copa_panload( "slider.pan", "sl1" );
/* slider.pan has mechanisms with the following tags:
   HEIGHT WEIGHT IQ
 */

while( 1 ) {
	copa_get( userin );
	if( strcmp( userin, "OK" )==0 ) {
		break;
		}
	}

printf( "Here are the results of copa getvalue (individual):\n" );
copa_getvalue( "HEIGHT", userin );
printf( "Height = %s inches\n", userin );
copa_getvalue( "WEIGHT", userin );
printf( "Weight = %s lbs\n", userin );
copa_getvalue( "IQ", userin );
printf( "IQ = %s\n", userin );

/* remove panel (note: the above values must be gotten before panel goes away) */
copa_panquit();


copa_pop( 
"To make a panel go away,\nthe copa panquit command\n\
is used.  Panels can be nested.\n\n\
The following is another\n\
example of a control panel...", "OK,Exit", userin );

printf( "%s\n", userin );
if( strcmp( userin, "Exit" )==0 ) { copa_quit(); exit(0); }

copa_panload( "examp1.pan", "ex1" );
/* has these mechanisms: MENU LIST MSG INPUT1 INPUT2 */


/* copa_text( "MSG", "Select from the menu list\n\
on the right side.." ); 
*/
copa_echo( ".!begin MSG" );
copa_echo( "Select from the menu list" );
copa_echo( "on the right side" );
copa_echo( "by clicking with the mouse." );
copa_echo( ".!end" );

copa_text( "LIST", "!cat /etc/passwd | sed \"s/:.*//\"" );


/*
Exit 	Info about this 	Basic control pan.  Plots gallery 	
Progress msg 	Sliders again 	Rlimit test
*/
 


while( 1 ) {
	copa_get( userin );

	printf( "%s\n", userin );

	if( strcmp( userin, "Exit" )==0 ) break;

	else if( strcmp( userin, "Info about this" )==0 ) {
		copa_pop( 
"This control panel is defined in\n\
the file examp1.pan.  It doesn't do\n\
anything other than echo your selections.\n\
The listbox on the right has been filled \n\
with names from /etc/passwd, using the\n\
copa text command.\n\n\
When you're ready to leave this panel,\n\
choose 'Exit' from the menu..",  "OK",  userin );

		printf( "%s\n", userin );
		}

	else if( strcmp( userin, "Progress msg" )==0 ) {

		copa_popmsg(
"Here is an example of a popup message\n\
box, useful for 'in progress' messages.\n\
These are produced using copa popmsg,\n\
and removed using copa popclear.", "" );
printf( "(sleeping for 5 seconds..)\n" );
		sleep( 5 );
		copa_popclear();


		copa_popmsg(
"You can also have buttons on an\n\
'in progress' message, perhaps to cancel the\n\
process you are waiting for, for example.\n\
However, the buttons in this case respond \n\
only if the program is set up to check\n\
the status of the buttons every so often..\n\n\
A loop containing 1 second sleeps is now running.\n\
Press 'Cancel' when ready to continue..", "Cancel,Exit" );

		while( 1 ) {
			sleep( 1 );
			copa_mget( "nonblocking", userin );
			if( strcmp( userin, "Cancel" )==0 ) break;
			if( strcmp( userin, "Exit" )==0 ){ copa_quit(); exit(0); }
			}
		copa_popclear();
		}


	else if( strcmp( userin, "Sliders again" ) ==0 ) {
		copa_pop( 
"You've used the slider panel before..\n\
Do you want to use it in its current\n\
state (copa panuse), or load a \n\
fresh copy (copa panload)?",  "Current state,Fresh copy", userin );

		printf( "%s\n", userin );

		if( userin[0] == 'C' ) copa_panuse( "sl1" );
		else copa_panload( "slider.pan", "sl1" ); 
		/* note: the above could be given some tag
		other than sl1 if we wanted two distinct instances 
		available..*/

		while( 1 ) {
			copa_get( userin );
			if( strcmp( userin, "OK" )==0 ) break;
			}
		copa_panquit();
		}

	else if( strcmp( userin, "Plots gallery" )==0 ) {
		copa_pop( 
"Copa includes optional functionality to create\n\
plots and graphs of various kinds\n\
based on data.", "OK,Exit", userin );
		if( strcmp( userin, "Exit" )==0 ){ copa_quit(); exit(0); }
		copa_display( "holdrefresh" );
		copa_panload( "plots.pan", "p1" );

		/* add an exit button.. */
		copa_panadd( "exitb.pan" );
		copa_display( "refresh" );

		while( 1 ) {
			copa_get( userin );
			if( strcmp( userin, "PostScript" )==0 ) {
				copa_popentry( "File name for PostScript output:", "out.ps", 15, userin );
				copa_ps( "Example", userin, "L" );
				}
			else 	{
				copa_panquit();
				break;
				}
			}
		}
	else if( strcmp( userin, "Data entry" )==0 ) {
		copa_panload( "form.pan", "fm" );	
		while( 1 ) {
			copa_get( userin );
			printf( "%s\n", userin );
			if( strcmp( userin, "Cancel" )==0 ) break;
			}
		copa_panquit();
		}

	else if( strcmp( userin, "Basic control pan." )==0 ) {
		copa_panload( "basic.pan", "bas" );
		while( 1 ) {
			copa_get( userin );
			printf( "%s\n", userin );
			if( strcmp( userin, "Exit" )==0 ) break;
			}
		copa_panquit();
		}

	else if( strcmp( userin, "Other tests" )==0 ) {
		copa_poplist( "Select a test..", "refresh\nregen\nresize\ndisappear\nrlimit\nrinfo\ngetentry", 
			"Cancel", userin );
		if( strcmp( userin, "rlimit" )== 0 ) {
			copa_pop( 
"This will test the copa rlimit command.\n\
Which mechanisms should be responsive?", "MENU,.!all", userin );
			copa_rlimit( userin );
			}
		else if( strcmp( userin, "redraw" )==0 ) copa_display( "refresh" );
		else if( strcmp( userin, "regen" )==0 ) copa_display( "regen" );
		else if( strcmp( userin, "resize")==0 ) {
			copa_resize( 300, 10, 10.0, 10.0, 0.0 );
			copa_pop( "Resized to 10x10", "OK", userin );
			copa_resize( 300, 10, 9.0, 8.0, 0.9 );
			}
		else if( strcmp( userin, "getentry" )==0 ) {
			copa_getentry( "INPUT1", userin );
			printf( "%s\n", userin );
			}
		else if( strcmp( userin, "disappear" )==0 ) {
			copa_display( "disappear" );
			sleep( 1 );
			copa_display( "appear" );
			}
		else if( strcmp( userin, "rinfo" )==0 ) {
			while( 1 ) {
				copa_popmsg( "Press any key or mouse button..", "" );
				/* get mouse click */
				copa_mget( "mousepos", userin );
				copa_popclear();
				
				/* find out which key was pressed */
				copa_rinfo( "key", key );
				/* find out x location in inches from lower left */
				copa_rinfo( "x", xpos );
				/* find out y location in inches from lower left */
				copa_rinfo( "y", ypos );
				
				sprintf( buf, "You pressed %s at x=%s and y=%s.", key, xpos, ypos );
				copa_pop( buf, "OK,Exit", userin );
				
				if( strcmp( userin, "Exit" )==0 ) break;
				}
			}
		}

	}

copa_quit();
}
