#!/bin/sh
###*************************************************************
#  DEMO.SH
#* This is a demo program which uses most of the COPA commands.
#* See demo.c for an equivalent program written in C.
#************************************************************** 


which copa

### start copa.. */
copa_window 300 100 9.0 8.0 "Copa demo (Bourne shell)" 0.9 &
sleep 1

copa version

echo "Display is pid# `copa display ping`"

UIN=`copa pop "Welcome to copa.
Copa is a kit for developing gui control panels.
This is a demo program which will introduce you to
some of the capabilities of copa.  This demo
was written in C and compiled using the included
object library copa.a.  Copa can also be used in
shell scripts, perl programs, and other environments.

This demo should be run in the examples directory.  It 
doesn't do anything other than echo your
responses to standard output.

(To respond, click on the button of your choice.)
Do you want to continue?"    "Yes,No" `

if [ "$UIN" != "Yes" ]; then copa quit; exit; fi



### adjust size of text in popup box to 10 point.. */
copa setmec _POP text/size 10

### set size of popup box (so scrolling occurs)..
copa setmec _POP nlines 35

### produce a popup box.. */
UIN=`copa pop "!cat ../Copyright" "Continue,Exit"`

echo $UIN

if [ "$UIN" = "Exit" ]; then copa quit; exit; fi

### adjust size of text in popup box to 12 point.. */
copa setmec _POP text/size 12 

### put back to auto-size..
copa setmec _POP nlines 0

UIN=`copa pop "This and the preceding are examples
of 'popup' boxes with buttons.  They can
be produced by using the copa pop command.
The user responds by clicking on the desired
button with the mouse."  "OK,Exit"`

echo $UIN

if [ "$UIN" = "Exit" ]; then copa quit; exit; fi

### do a dataentry popup box */
UIN=`copa popentry "Here's an example of a popup box with a data entry
area instead of buttons.  These can be produced by using
the copa popentry command.  You can type in a response,
or use the default if you wish.

When finished, press ENTER, TAB, ESC, or click with the mouse.

What town are you in?"  "Baltimore"  20`

echo $UIN

UIN=`copa poplist  "Now this is an example of a popup box with a listbox
which contains some selections, produced using the
copa poplist command.  The listbox can be filled
filled with literal text, or the results of a system
command such as 'ls', or both.

If there are lots of entries in the listbox, it will become
scrollable and a scrolling control will appear automatically
on the right side.

Select an entry from the list by clicking on it with the mouse.
(Again, this demo will just echo the file name"  "!ls"  "Cancel,Exit" `

echo $UIN

if [ "$UIN" = "Exit" ]; then copa quit; exit; fi



### load slider panel */
copa panload  "slider.pan"  "sl1"

### slider.pan has mechanisms with the following tags:
### HEIGHT WEIGHT IQ

while :
do
	UIN=`copa get`
	if [ "$UIN" = "OK" ]; then 
		break 
	fi
done

echo "Here is the result of copa getvalue .!all:"
copa getvalue .!all

echo "Here are the results of copa getvalue (individual):"
HEIGHT=`copa getvalue  HEIGHT`
echo "Height = $HEIGHT inches"

WEIGHT=`copa getvalue  WEIGHT`
echo "Weight = $WEIGHT inches"

IQ=`copa getvalue  IQ`
echo "IQ = $IQ"

### remove panel (note: the above values must be gotten before panel goes away) */
copa panquit

UIN=`copa pop "To make a panel go away,
the copa panquit command
is used.  Panels can be nested.

The following is another
example of a control panel..." "OK,Exit"`

echo $UIN
if [ "$UIN" = "Exit" ]; then copa quit; exit; fi

copa panload  "examp1.pan" "ex1" 
### has these mechanisms: MENU LIST MSG INPUT1 INPUT2 */


copa echo  ".!begin MSG" 
copa echo  "Select from the menu list" 
copa echo  "on the right side" 
copa echo  "by clicking with the mouse." 
copa echo  ".!end" 

copa text  "LIST" "!cat /etc/passwd | sed \"s/:.*//\"" 



while :  #{
do
	UIN=`copa get`

	echo $UIN
	if [ "$UIN" = "Exit" ]; then copa quit; exit

	elif [ "$UIN" = "Info about this" ]; then
		UIN=`copa pop "This control panel is defined in
the file examp1.pan.  It doesn't do
anything other than echo your selections.
The listbox on the right has been filled 
with names from /etc/passwd, using the
copa text command.

When you're ready to leave this panel,
choose 'Exit' from the menu.."  "OK" ` 

		echo $UIN

	elif [ "$UIN" = "Progress msg" ]; then

		copa popmsg "Here is an example of a popup message
box, useful for 'in progress' messages.
These are produced using copa popmsg,
and removed using copa popclear."  ""

		echo "(sleeping for 5 seconds..)"
		sleep 5 
		copa popclear

		copa popmsg "You can also have buttons on an
'in progress' message, perhaps to cancel the
process you are waiting for, for example.
However, the buttons in this case respond 
only if the program is set up to check
the status of the buttons every so often..

A loop containing 1 second sleeps is now running.
Press 'Cancel' when ready to continue.." "Cancel,Exit" 

		while :
		do
			sleep 1 
			UIN=`copa mget nonblocking` 

			if [ "$UIN" = "Cancel" ]; then break; 
			elif [ "$UIN" = "Exit" ]; then  copa quit; exit; 
			fi
		done

		copa popclear
		

	elif [ "$UIN" = "Sliders again" ]; then
		UIN=`copa pop "You've used the slider panel before..
Do you want to use it in its current
state (copa panuse), or load a 
fresh copy (copa panload)?"  "Current state,Fresh copy"`

		echo $UIN

		if [ "$UIN" = "Current state" ]; then 
			copa panuse sl1
		else
			copa panload slider.pan sl1
		fi
		### note: the above could be given some tag
		### other than sl1 if we wanted two distinct instances 
		### available..

		while :
		do
			UIN=`copa get`
			if [ "$UIN" = "OK" ]; then break; fi
		done
		copa panquit
		

	elif [ "$UIN" = "Plots gallery" ]; then
		UIN=`copa pop  "Copa includes optional functionality to create
plots and graphs of various kinds
based on data." "OK,Exit"`

		if [ "$UIN" = "Exit" ]; then copa quit; exit; fi
		copa display  holdrefresh 
		copa panload  plots.pan p1 

		### add an exit button.. 
		copa panadd exitb.pan 

		copa display   refresh

		while :
		do
			UIN=`copa get`

			if [ "$UIN" = "PostScript" ]; then
				UIN=`copa popentry  "File name for PostScript output:" "out.ps" 15`
				copa ps  "Example" $UIN  L
				
			else
				copa panquit
				break
			fi
		done

	elif [ "$UIN" = "Basic control pan." ]; then
		copa panload basic.pan bas
		while :
		do
			UIN=`copa get`
			echo $UIN
			if [ "$UIN" = "Exit" ]; then break; fi
		done
			
		copa panquit

	elif [ "$UIN" = "Data entry" ]; then
		copa panload form.pan bas
		while :
		do
			UIN=`copa get`
			echo $UIN
			if [ "$UIN" = "Cancel" ]; then break; fi
		done

		copa panquit
			
		

	elif [ "$UIN" = "Other tests" ]; then
		UIN=`copa poplist  "Select a test.." "refresh
regen
resize
disappear
rlimit
rinfo
getentry" "Cancel" `

		if [ "$UIN" = "rlimit" ]; then
			UIN=`copa pop  "This will test the copa rlimit command.
Which mechanisms should be responsive?" "MENU,.!all"`
			copa rlimit $UIN
			 
		elif [ "$UIN" = "resize" ]; then
			copa resize 300 10 10 10 0.0
			copa pop "Resized to 10x10" "OK"
			copa resize 300 10 9.0 8.0 0.9
			
		elif [ "$UIN" = "redraw" ]; then
		        copa display  refresh
		elif [ "$UIN" = "regen" ]; then
			copa display regen
		elif [ "$UIN" = "disappear" ]; then
			copa display disappear
			sleep 1 
			copa display appear
		elif [ "$UIN" = "getentry" ]; then
			UIN=`copa getentry INPUT1`
			echo $UIN
		elif [ "$UIN" = "rinfo" ]; then
			while :
			do
			  copa popmsg "Press any key or mouse button.." "" 
			  ### get mouse click */
			  UIN=`copa mget  mousepos`
			  copa popclear
				
			  ### find out which key was pressed */
			  KEY=`copa rinfo  key`

			  ### find out x location in inches from lower left */
			  XPOS=`copa rinfo x`

			  ### find out y location in inches from lower left */
			  YPOS=`copa rinfo y`
				
			  UIN=`copa pop "You pressed $KEY at x=$XPOS and y=$YPOS" "Ok,Exit"`
			  if [ "$UIN" = "Exit" ]; then break; fi
			done
		 fi

	fi

done #}
 
copa quit
