####################################################################
### EXAMP1.PAN - Example of a control panel
###
### The mechanism types and all attributes are defined in gui.def.
### Each mechanism definition begins with a "Proc" line.
### Attributes may be specified in any order.


###########################################
### Window background
### -- optional, but if done, must be done before anything else
###########################################

Proc backing		

### it will be called BACK..
*/tag: BACK		

### center it in the window..
*/align_h: C root C	
*/align_v: C root C

### background color = white..
color: 1.0		

### backing box will be 6.3 inches wide and 8 inches high....
box.width: 6.3		
box.height: 8



#####################
### Vertical menu ###
#####################

Proc textb

### it will be called MENU..
*/tag: MENU		

### align left side of MENU 0.2 inches in from the left side of the backing...
*/align_h: L BACK L+0.2 

### align top side of MENU 0.4 inches down from the top of the backing..
*/align_v: T BACK T-0.4 

### 12 point text..
text/size: 12		

### text entries will be centered..
align: C		

### text entries will be spaced at 0.35 inches per line..
spacing: 0.35		

### there will be line rulings between lines..
ruled: L		

### it will be possible to select lines with the mouse..
pick: x			

### up to 11 lines of text will be displayed..
nlines: 11		

### 17 characters wide..
box.width: 17		

### no margin (0 inches) will appear around the box..
box.margin: 0		

### do rectangle decoration (shadow)..
dress: x		

### hilighting will be reset after mouse selection..
flashpick: x		

### the text to be displayed..
text: 	Exit
	Info about this
	Basic control pan.
	Plots gallery
	Data entry
	Progress msg
	Sliders again
	Other tests




###############################
### label for vertical menu ###
###############################

Proc textb

*/tag: MENULABEL

# align left of label to left of MENU..
*/align_h: L MENU L

# align bottom of label to top of MENU..
*/align_v: B MENU T

box.width: 10
box.color: 0
text: Menu
text/size: 12
text/pen: white
dress:






#################
### List area ###
#################
Proc textb

### it will be called LIST..
*/tag: LIST 

### align right side of LIST to 0.2 inches in from the right side of the backing..
*/align_h: R BACK R-0.2

### align top side of LIST to 0.4 inches down from the top of the backing..
*/align_v: T BACK T-0.4

### 10 point text..
text/size: 10

### up to 12 lines will be displayed..
nlines: 12

### 28 characters wide..
box.width: 28

### 0.3 inch spacing between lines..
spacing:  0.3

### rulings will appear between lines..
ruled: L

### it will be possible to select lines with the mouse..
pick: x

### put a 0.5 inch margin around the box..
box.marg_l: 0.5

### no text to be displayed at present..
text: 

############################
### label for list area..###
############################
Proc textb
*/tag: LISTLABEL
*/align_h: L LIST L
*/align_v: B LIST T
*/inherit: MENULABEL
text: List


#########################
### Data entry area 1 ###
#########################

Proc dataentry

# it will be called INPUT1..
*/tag: INPUT1

# align left side of INPUT1 0.2 inches in from the left side of the backing..
*/align_h: L BACK L+0.2

# align bottom of INPUT1 1 inch up from the bottom of the window..
*/align_v: B BACK B+1

# 30 point text (well, big anyway)..
text/size: 30

# maximum input length is 20..
maxlength: 20

# do rectangle decoration (shadow)..
dress: x

# the text of the prompt...
prompt: input1> 


#########################
### Data entry area 2 ###
#########################
Proc dataentry
*/tag: INPUT2
*/align_h: L BACK L+0.2
*/align_v: B BACK B+0.2
text/size: 30
maxlength: 20
dress: x
prompt: input2> 


####################
### Message area ###
####################
Proc textb

# it will be called MSG..
*/tag: MSG

# align left side of MSG 0.2 inches in from left side of the backing..
*/align_h: L BACK L+0.2

# align bottom side of MSG 0.2 inches bove the top side of INPUT1..
*/align_v: B INPUT1 T+0.2

# 12 point text..
text/size: 12

# center the lines of text within the box..
align: C

# display up to 4 lines..
nlines: 4

# 46 characters wide..
box.width: 46

# decorate the rectangle (shadow)..
dress: x

# the text to appear in the box..
text: Control Panel
Demo


##############################
### label for message area ###
##############################
Proc textb
*/tag: MSGLABEL

# align left of label to left of MSG
*/align_h: L MSG L

# align bottom of label to top of MSG
*/align_v: B MSG T

*/inherit: MENULABEL
text: Messages
