####################################################################
### FORM.PAN - Example of a control panel "form" for data entry
###
### The mechanism types and all attributes are defined in gui.def.
### Each mechanism definition begins with a "Proc" line.
### Attributes may be specified in any order.


###########################################
### Window background
### -- optional, but if done, must be done before anything else
###########################################

Proc backing		

### it will be called BACK..
*/tag: BACK		

### center it in the window..
*/align_h: C root C	
*/align_v: C root C

### background color 
color: 0.8

### backing box will be 7 inches wide and 8 inches high....
box.width: 7
box.height: 8


###########################################
### Control buttons
###########################################
Proc button
*/tag: CONTROLBUTTONS
*/align_h: C BACK C
*/align_v: B BACK B+0.5
text: Edit,Save,Cancel
flashpick: x

###########################
### Make an invisible textbox
### which contains the name of the first data entry field.
### This will be checked by the program, so it knows where to start..
###########################
Proc textb
*/tag: FIRSTMEC
*/display: 
text: LASTNAME

#########################
### Data entry areas  
### note: prompts are done as separate textb
### to get inverse color and alignment the way we want it..
#########################

Proc dataentry
*/tag: LASTNAME
*/align_h: L BACK L+2
*/align_v: T BACK T-0.2
text/size: 12
maxlength: 20
dress: x
info: required
next: FIRSTNAME

### Prompt
Proc textb
*/tag: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-0.2
box.width: 12
box.color: 0
text: "Last name"
text/size: 10
text/pen: white
dress:





Proc dataentry
*/tag: FIRSTNAME
*/align_h: L BACK L+2
*/align_v: T BACK T-0.7
text/size: 12
maxlength: 15
dress: x
info: required
next: ADDRLINE1

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-0.7
text: "First name"





Proc dataentry
*/tag: ADDRLINE1
*/align_h: L BACK L+2
*/align_v: T BACK T-1.2
text/size: 10
maxlength: 35
dress: x
info: required
next: ADDRLINE2

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-1.2
text: "Addr line 1"





Proc dataentry
*/tag: ADDRLINE2
*/align_h: L BACK L+2
*/align_v: T BACK T-1.7
text/size: 10
maxlength: 35
dress: x
next: ADDRLINE3

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-1.7
text: "Addr line 2"





Proc dataentry
*/tag: ADDRLINE3
*/align_h: L BACK L+2
*/align_v: T BACK T-2.2
text/size: 10
maxlength: 35
dress: x
next: PHONEINFO

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-2.2
text: Addr line 3




Proc dataentry
*/tag: PHONEINFO
*/align_h: L BACK L+2
*/align_v: T BACK T-2.7
text/size: 12
maxlength: 28
dress: x
next: EMAILINFO

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-2.7
text: "Phone info"




Proc dataentry
*/tag: EMAILINFO
*/align_h: L BACK L+2
*/align_v: T BACK T-3.2
text/size: 12
maxlength: 36
dress: x

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-3.2
text: "Email info"



#################
### button choice
#################
Proc button
*/tag: TYPE
*/align_h: L BACK L+2
*/align_v: T BACK T-4
text/size: 10
text: Family,Neighbor,Friend,Business,Other

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-4
text: "Contact type"



##############
### list box
##############
Proc textb
*/tag: CATEGORY
*/align_h: L BACK L+2
*/align_v: T BACK T-5
nlines: 6
box.width: 40
pick: x
ruled: L
text:   Category A
 	Category B
 	Category C
	Category D
 	Category E
 	Category F
 	Category G
 	Category H
 	Category I
 	Category J
 	Category K
 	Category L
 	Category M

### Prompt
Proc textb
*/inherit: PR1
*/align_h: R BACK L+2
*/align_v: T BACK T-5
text: Category
