#!/bin/sh
## **************************************************************
## PAGE.SH
## This is a copa program for previewing .pan files
## as they will appear when printed on a 
## sheet of paper in portrait mode,
## and getting PostScript dumps of .pan files.
## ************************************************************* 

PAPER_HI=11
PAPER_WIDE=8.5

# Use COPA_DPI to reduce overall size of display..
COPA_DPI=65
export COPA_DPI

which copa

### start copa.. 
copa_window 300 10 $PAPER_WIDE $PAPER_HI "Copa PAN file print previewer (sh)" 0.9 &
sleep 1

while :
do

 PAN=`copa poplist "Select a .pan file from the list or exit.." "!ls *.pan" "Exit" `

 if [ "$PAN" = "Exit" ]; then
	copa quit
	exit
 fi
	
 ### avoid double redraw..
 copa display holdrefresh

 ### load the selected control panel..
 copa panload $PAN sl1

 ### add the exit button..
 copa panadd "examples/exitb.pan"

 ### now display all
 copa display refresh

 while :
 do
	UIN=`copa get`

	if [ "$UIN" = "Exit" ]; then break; fi
	if [ "$UIN" = "PostScript" ]; then
	     ### reload without the control buttons..
             ### don't do any popups here or they'll appear on output..
             copa display holdrefresh
             copa panload $PAN p2
 
             UIN=`copa popentry  "File name for PostScript output:" "out.ps" 15`
 
             copa ps  "Example" $UIN  Portrait
 
             copa panquit
             copa display refresh
	fi

 done

 copa panquit

done
copa quit
