####################################################################
### PLOTS.PAN - Examples of some copa data plotting mechanisms
###
### The mechanism types and all attributes are defined in gui.def and plot.def.
### Each mechanism definition begins with a "Proc" line.
### Attributes may be specified in any order.


### Centered title
Proc textb
*/tag: TITLE
*/align_h: C root C
*/align_v: T root T-0.2
text/size: 15
text:	Copa data plot samples

### Data to be plotted (not made visible)
Proc textb
*/tag: DATALIST
### do not display it..
*/display:
### the data follows..
text:
30  20 U
10  22 V
 7  25 W
13  28 X
20  32 Y
20  36 Z

##############
### Plot 1 ### 
##############

### set the scaling and position..
Proc scalezone
*/tag: PLOTZONE1
*/align_h: L root L+0.5
*/align_v: T root T-1
height: 3
width: 2.5

### set up axes (really nothing except subtitle)..
Proc Axes
Plot/Zone: PLOTZONE1
Xaxis: none
Yaxis: none
Subtitle: Pie graph

### do pie graph..
Proc Pie
*/tag: PIE
Plot/Zone: PLOTZONE1
Plot/Datasource: DATALIST


##############
### Plot 2 ### 
##############

### set the scaling and position...
Proc scalezone
*/tag: PLOTZONE2
*/align_h: L PLOTZONE1 R+0.5
*/align_v: T PLOTZONE1 T
height: 3
width: 2.5
xrange: 0 7
yrange: 0 100
yscaletype: log


### set up axes...
Proc Axes
*/tag: AXES2
Plot/Zone: PLOTZONE2
Yinc: 10
Subtitle: Bars & Lines examp.
Xstart.0or1: 1
Xstub: 
A
B
C
D
E
F
Ystub.grid: line

### do bar graph..
Proc Bargraph
*/tag: BARS
Plot/Zone: PLOTZONE2
Plot/Datasource: DATALIST
Format: cluster
Field: 1 2 

### also do a line plot..
Proc Lineplot
*/tag: LINEP
Plot/Zone: PLOTZONE2
Plot/Datasource: DATALIST
Yfield: 1 2


##############
### Plot 3 ### 
##############

### set the scaling and position..
Proc scalezone
*/tag: PLOTZONE3
*/align_h: L PLOTZONE2 R+0.5
*/align_v: T PLOTZONE1 T
height: 3
width: 2.5
xrange: 0 200
yrange: 0 7

### set up axes...
Proc Axes
*/tag: AXES3
Plot/Zone: PLOTZONE3
Xinc: 20
Yinc: 1
Subtitle: Horizbar examp.
Ystart.0or1: 1
Ystub: 
A
B
C
D
E
F

# for the xstubs, using '!' places the label at the given scaled position
Xstub:
!0
!10
!20
!50
!100
Ystub.nolonetics: n
Xstub.grid: line

### do horizontal bar graph..
Proc Horizbar
*/tag: HORIZBAR
Plot/Zone: PLOTZONE3
Plot/Datasource: DATALIST
Format: stack
Field: 1 2


##############
### Plot 4 ### 
##############

### set up scaling and position..
Proc scalezone
*/tag: PLOTZONE4
*/align_h: L PLOTZONE1 L
*/align_v: T PLOTZONE1 B-0.5
height: 3
width: 2.5
xrange: 0 40 
yrange: 0 40

### set up axes..
Proc Axes
*/tag: AXES4
Plot/Zone: PLOTZONE4
Xinc: 5
Yinc: 5
Subtitle: 2-way Distrib

### do a point distribution using little circles (the default)..
Proc Distribution
Plot/Zone: PLOTZONE4
Xfield: 1
Yfield: 2

### do another one using the letter 'P'..
Proc Distribution
Plot/Zone: PLOTZONE4
Xfield: 2
Yfield: 1
Mark: P


##############
### Plot 5 ### 
##############

### set up scaling and position (maps always use 0..40)
Proc scalezone
*/tag: PLOTZONE5
*/align_h: L PLOTZONE4 R+0.5
*/align_v: T PLOTZONE4 T
height: 3
width: 2.5
xrange: 0 40
yrange: 0 40

### do subtitle only..
Proc Axes
Plot/Zone: PLOTZONE5
Xaxis: none
Yaxis: none
Subtitle: N.A. map

### put map data into a textb (don't display it..)
Proc textb
*/tag: MAPDATA
*/display: 
text:
 ca         52  
 fl         41  
 ga         16  
 ia         23  
 il         65  
 md         28  
 mi         69  
 mn         19  
 mo         12  
 nc         21  
 ny         44  
 oh         45  
 on         53  
 or         19  
 pa         16  
 sc         14  
 tx         58  
 va         15  
 wi         46  

### do the north america map..
Proc Map
Plot/Zone: PLOTZONE5
Plot/Datasource: MAPDATA
Mode:   statedist
List:   n
Statefield:     1
Valfield: 2
Threshold: 1 5 10 20 30 50 200
Shade: 1 .98 .85 .7 .55 .40 .25


##############
### Plot 6 ### 
##############

### set up scaling and position..
Proc scalezone
*/tag: PLOTZONE6
*/align_h: L PLOTZONE5 R+0.5
*/align_v: T PLOTZONE5 T
height: 1
width: 2.5
xrange: 0 100

### Do axis in the x direction only..
Proc Axes
*/tag: AXES6
Plot/Zone: PLOTZONE6
Xinc: 20
Yaxis: none
Subtitle: 1-way Distrib 
Frame: single

### Do a bar distribution..
Proc Distribution
Plot/Zone: PLOTZONE6
Plot/Datasource: DATALIST
Xfield: 1
