/**************************************************************
 * PREVIEW.C
 * This is a copa program for previewing .pan files.
 * See also preview.sh and preview.perl
 ************************************************************** 
*/
#include <stdio.h>

main( argc, argv )
int argc;
char **argv;
{


char userin[80];
char tag[30];
char buf[80];
char panfile[80];
int status;


/* start copa.. */
copa_window( 300, 100, 9.0, 8.0, "Copa PAN file previewer (C)", 0.9 );

if( argc == 2 ) { 
	strcpy( userin, argv[1] );
	goto DISPLAY;
	}

while( 1 ) {
	copa_poplist( "Select a .pan file from the list or exit..",
		"!ls *.pan", "Exit", userin );

	if( strcmp( userin, "Exit" )==0 ) break;
	
	/* load and display the selected panel */
	DISPLAY:
	copa_display( "holdrefresh" ); /* avoid double redraw.. */
	strcpy( panfile, userin );
	status = copa_panload( panfile, "p1" );
	if( status != 0 ) {
		fprintf( stderr, "Cannot load %s.\n", userin );
		continue;
		}
	status = copa_panadd( "examples/exitb.pan" );
	copa_display( "refresh" );


	while( 1 ) {
		copa_get( userin );
		copa_rinfo( "tag", tag );
		printf( "%s = %s\n", tag, userin );
		if( strcmp( userin, "Exit" )==0 ) break;

		else if( strcmp( userin, "PostScript" )==0 ) {
 
             		copa_display( "holdrefresh" );
             		copa_panload( panfile, "p2" );
 
			copa_popentry( "File name for PostScript output:", 
				"out.ps", 15, buf );

             		copa_pop( "Select paper direction", "Portrait,Landscape", userin );
 
             		copa_ps( "Example", buf, userin );
 
             		copa_panquit();
             		copa_display( "refresh" );
			}
		}

	copa_panquit();

	}
copa_quit();
exit(0);
}
