## **************************************************************
## PREVIEW.PERL
## This is a copa program for previewing .pan files.
## Translated into perl.
## ************************************************************* 


### start copa.. 
system( "copa_window 300 100 9.0 8.0 \"Copa PAN file previewer (perl)\" 0.9 &" );
sleep 1;

while ( 1 ) {

 $pan = `copa poplist "Select a .pan file from the list or exit.." "!ls *.pan" "Exit" ` ;

 # perl adds a trailing newline above.. remove it
 chop( $pan );

 if ( $pan eq "Exit") {
	system( "copa quit" );
	exit;
	}

	
 ### avoid double redraw..
 system( "copa display holdrefresh" );

 ### load the selected control panel..
 system( "copa panload $pan p1" );

 ### add the exit button..
 system( "copa panadd examples/exitb.pan" );

 ### now display all
 system( "copa display refresh" );

 while ( 1 ) {

	$uin=`copa get`;
	chop( $uin );

	$tag=`copa rinfo tag `;
	chop( $tag );

	print "$tag = $uin\n";

	if ( $uin eq "Exit" ) { last; }  # perl uses last rather than break
	
	if ( $uin eq "PostScript" ) {

	     ### reload without the control buttons..
	     ### don't do any popups here or they'll appear on output..
	     system( "copa display holdrefresh" );
	     system( "copa panload $pan p2" );

             $uin=`copa popentry  "File name for PostScript output:" "out.ps" 15`;
	     chop( $uin );
	
	     $mode=`copa pop "Select paper direction" "Portrait,Landscape"`;
	     chop( $mode );

             system( "copa ps  \"Example\" $uin  $mode" );

	     system( "copa panquit" );
	     system( "copa display refresh" );
	     }

       }

 system( "copa panquit" );

}
system( "copa quit" );
