#!/bin/sh
## **************************************************************
## PREVIEW.SH
## This is a copa program for previewing .pan files.
## ************************************************************* 

which copa

### start copa.. 
copa_window 300 100 9.0 8.0 "Copa PAN file previewer (Bourne sh)" 0.9 &
sleep 1

while :
do

 PAN=`copa poplist "Select a .pan file from the list or exit.." "!ls *.pan" "Exit" `

 if [ "$PAN" = "Exit" ]; then
	copa quit
	exit
 fi
	
 ### avoid double redraw..
 copa display holdrefresh

 ### load the selected control panel..
 copa panload $PAN p1

 ### add the exit button..
 copa panadd "examples/exitb.pan"

 ### now display all
 copa display refresh

 while :
 do
	UIN=`copa get`

	TAG=`copa rinfo tag `

	echo "$TAG = $UIN"

	if [ "$UIN" = "Exit" ]; then break; fi
	
	if [ "$UIN" = "PostScript" ]; then

	     ### reload without the control buttons..
	     ### don't do any popups here or they'll appear on output..
	     copa display holdrefresh
	     copa panload $PAN p2

             UIN=`copa popentry  "File name for PostScript output:" "out.ps" 15`
	     MODE=`copa pop "Select paper direction" "Portrait,Landscape"`

             copa ps  "Example" $UIN  $MODE

	     copa panquit
	     copa display refresh
	fi

 done

 copa panquit

done
copa quit
