####################################################################
### THPLOT.PAN - Another more involved plot example
###
### The mechanism types and all attributes are defined in gui.def and plot.def.
### Each mechanism definition begins with a "Proc" line.
### Attributes may be specified in any order.
###########################################################

### Backing color - white
Proc backing
color: 1

### Centered title
Proc textb
*/tag: TITLE
*/align_h: C root C
*/align_v: T root T-0.8
align: C
text/size: 12
# turn off box..
box:
text:	Mean FES Scores 
	For Families in Emergency Shelters vs.
	Families in Transitional Housing 

### set up scaling and position..
Proc scalezone
*/tag: PLOTZONE1
*/align_h: C root C
*/align_v: C root C
height: 4
width: 6
xrange: 0 6
yrange: 0 100


### do axes..
Proc Axes
Plot/Zone: PLOTZONE1
Xstub:  Cohesion
	Expressiveness
	Conflict
	Independence
	Achievement~Orientation
Xstart.0or1: 1
Yinc: 10
Ylabel: Standard Score


Proc textb
*/tag: DATA_1
*/display:
#
# E (1-5)
#x pos  n obs   mean  stdev   min    5th    25th   50th   75th   95th   max    n/a 
#=====  =====  =====  =====  =====  =====  =====  =====  =====  =====  =====  =====
text: 
  0.9    23   37.83  18.66   1.00  53.00  31.00  53.00  16.00  31.00  68.00      0  p<.05 1 78
  1.9    23   42.17   9.00  21.00  47.00  41.00  47.00  34.00  34.00  60.00      0  p<.05 2 78
  2.9    23   54.48  13.67  32.00  70.00  59.00  38.00  59.00  54.00  75.00      0  p>.05 3 78
  3.9    23   42.52  14.71  11.00  45.00  45.00  45.00  11.00  36.00  70.00      0  p>.05 4 78
  4.9    23   54.48   8.44  35.00  60.00  60.00  53.00  41.00  35.00  66.00      0  p>.05 5 78

Proc Draw:
*/tag: DOLINE
Plot/Zone: PLOTZONE1
Linethick: 0.4
Linetype.magnify: 5
System: data
Points: 0 50 6 50

Proc Draw:
*/inherit: DOLINE
Plot/Zone: PLOTZONE1
Linetype: 1
Points: 0 40 6 40
	0 60 6 60

Proc Bargraph:
*/tag: BAR1
Plot/Zone: PLOTZONE1
Plot/Datasource: DATA_1
Xfield: 1 
Field: 3
Shade: 1.0

Proc Errorbars:
*/tag: ERR1
Plot/Zone: PLOTZONE1
Double: n
Xfield: 1
Yfield: 3
Errfield: 4

# slap on p values
Proc Distribution:
Plot/Zone: PLOTZONE1
Xfield: 14
Yfield: 15
Mark: 
Mark.field: 13
Mark.size: 10

Proc textb
*/tag: DATA_2
*/display:
# T (1-5)
#x pos  n obs   mean  stdev   min    5th    25th   50th   75th   95th   max    n/a 
#=====  =====  =====  =====  =====  =====  =====  =====  =====  =====  =====  =====
text:
   1.1     39   52.38  15.44   9.00  46.00  16.00  68.00  46.00  68.00  68.00      0
   2.1     39   48.90   8.94  21.00  41.00  54.00  66.00  47.00  54.00  66.00      0
   3.1     39   50.90  10.99  28.00  70.00  65.00  38.00  59.00  48.00  75.00      0
   4.1     39   44.62   9.59  28.00  45.00  36.00  45.00  28.00  45.00  62.00      0
   5.1     39   54.92   8.59  35.00  72.00  60.00  53.00  53.00  60.00  72.00      0

Proc Bargraph:
*/inherit: BAR1
Plot/Datasource: DATA_2
Shade: 0.9

Proc Errorbars:
*/inherit: ERR1
Plot/Datasource: DATA_2

### do a legend.. first set up a scalezone (alignment info only)
Proc scalezone:
*/tag: LEGEND
*/align_h: C root C-0.7
*/align_v: B root B+0.5
height: 0.7
width: 1.5
#don't fill box
color: -1

Proc Legend:
Plot/Zone: LEGEND
Entry: Emergency Shelters (N = 23)
       Transitional Housing (N = 39)
Shade: 1.0 0.9
 
