/* returns 1 if data was converted, 0 if not. */

#include "elib.x"
#include "ipl.h"

static int fillflag = 0;
static int curobjid = -1;

EPfilld( p )
int p; /* ref. to a plotting object */
{
char *obj, *txt, *tok;
int i, ix, j, ixx, id, len;
int oldix; /* scg 1-22-96 */

obj = EIgetc( p, "", "Plot/Datasource", &len );    /* get the textb which holds the data.. */
if( len < 1 ) return( 0 );

id = Egetid( obj );

if( id == curobjid && ! fillflag ) return( 0 ); /* do a scan if we are given a different textb,
							or if notified that the body of text changed. */
curobjid = id;
fillflag = 0;

txt = EIgetc( id, "", "text", &len );

ixx = 0;
N_d_rows = 0;
N_d_fields = 0;
oldix = -1;
for( i = 0, ix = 0; ix < len; i++ ) {
	if( i >= MAX_D_ROWS ) {
		fprintf( stderr, "Reaching max. of %d rows.\n", MAX_D_ROWS );
		break;
		}
	Egetchunk( Buf, txt, &ix, "\n" );
	if( ix == oldix ) break; /* no more lines.. (scg 1-22-96) */
	else oldix = ix;

	if( strlen( Buf ) < 1 ) continue;
	for( j = 0, ixx = 0; j < MAX_D_COLS; j++ ) {
		tok = Egetok( Buf, &ixx );
		if( strlen( tok ) < 1 ) break;
		else if( strlen( tok ) >= DATAITEM_LEN-1 ) {
			fprintf( stderr, "Item too long (row %d field %d).\n", i+1, j+1 );
			strncpy( D[i][j], tok, DATAITEM_LEN -2 );
			D[i][j][DATAITEM_LEN - 1 ] = '\0';
			} 
		else strcpy( D[i][j], tok );
		}
	if( N_d_fields < 1 ) N_d_fields = j;
	N_d_rows ++;
	}
return( 1 );
}

/* ====================================== */
/* This is called by gr when text is modified, so that the D array can be updated */

EPrefreshplotdata( p )
{
if( p == curobjid ) fillflag = 1;
}
