/* gen routine for plot */
#include "ipl.x"

EPgenipl( name, p )
char name[];
int p;
{

EPcurp = p;

if( EPsetupzone( p ) == 0 ) return(0); /* set the ipl scaling */
EPfilld( p ); 			/* transfer the data from a textb to the ipl D structure */


if( strcmp( name, "Axes" )==0 ) EPaxes();
else if( strcmp( name, "Lineplot" )==0 ) EPlineplot();
else if( strcmp( name, "Bargraph" )==0 ) EPbargraph();
else if( strcmp( name, "Horizbar" )==0 ) EPhorizbar();
else if( strcmp( name, "Pie" )==0 ) EPpie();
else if( strcmp( name, "Map" )==0 ) EPmap();
else if( strcmp( name, "Legend" )==0 ) EPlegend();
else if( strcmp( name, "Distribution" )==0 ) EPdistribution();
else if( strcmp( name, "Errorbars" )==0 ) EPerrorbars();
else if( strcmp( name, "Draw" )==0 ) EPdraw();
}

/* ======================================== */
/* set up a scaled zone for plots */

EPsetupzone( p )
int p;
{
char *tag, *zone, *xscaletype, *yscaletype;
double *xlo, *ylo, *xhi, *yhi;
double *x1, *y1, *x2, *y2;
int len, zp;
double zero, one;

zero = 0.0;
one = 1.0;

tag = EIgetc( p, "", "*/tag", &len );
zone = EIgetc( p, "", "Plot/Zone", &len );
if( len < 1 ) { 
	fprintf( stderr, "Plot object %s must have a Plot/Zone specified.\n", tag ); 
	return( 0 ); 
	}

zp = Egetid( zone );

if( strcmp( EIgetobjname( zp ), "scalezone" )!= 0 ) {
	fprintf( stderr, "Plot/Zone must refer to an object of type 'scalezone'.\n" );
	return( 0 );
	}

x1 = EIgetd( zp, "*", "bb", &len );
y1 = x1 + 1;
x2 = x1 + 2;
y2 = x1 + 3;

xlo = EIgetd( zp, "", "xrange", &len );
if( len != 2 ) { xlo = &zero; xhi = &one; }
else xhi = xlo + 1;
ylo = EIgetd( zp, "", "yrange", &len );
if( len != 2 ) { ylo = &zero; yhi = &one; }
else yhi = ylo + 1;

xscaletype = EIgetc( zp, "", "xscaletype", &len );
yscaletype = EIgetc( zp, "", "yscaletype", &len );

if( strcmp( xscaletype, "linear" )==0 ) Scale_discipline_x = LINEAR;
else if( strcmp( xscaletype, "log" )==0 ) Scale_discipline_x = LOG;
else if( strcmp( xscaletype, "yymm" )==0 ) Scale_discipline_x = YYMM;

if( strcmp( yscaletype, "linear" )==0 ) Scale_discipline_y = LINEAR;
else if( strcmp( yscaletype, "log" )==0 ) Scale_discipline_y = LOG;
else if( strcmp( yscaletype, "yymm" )==0 ) Scale_discipline_y = YYMM;

setscale_x( *x1, *x2 , *xlo, *xhi );
setscale_y( *y1, *y2, *ylo, *yhi );

return( 1 );
}
