#include "ipl.x"
/* =============
   ============= */
/* The following are utilities for dealing with multi-line responses */
/* ========= */
/* getln() returns successive portions of s as separated by \n */

char *getln( s )
char s[];
{
static char rtn[120];
static int c = 0;
int l, start;

/* a null argument resets */
if( strlen( s ) < 1 ) {
	c = 0;
	return( "" );
	}
start = c;
for( ; c < strlen( s ); c++ ) if( s[c] == '\n' ) break;
strncpy( rtn, &s[start], c-start );
rtn[ c-start ] = '\0';
c++;
return( rtn );
}


/* ======= */
/* countln() returns number of \n separated lines in s */

countln( s )
char s[];
{
int i, nnl;
if( strlen( s ) < 1 ) return( 0 );
nnl = 0;
for( i = 0; i < strlen( s ) -1; i++ ) if( s[i] == '\n' ) nnl++;
nnl++;
return( nnl );
}

/* ======== */
/* text_tofile() places text s into file f */

text_tofile( s, f )
char s[], f[];
{
FILE *fp;

fp = fopen( f, "w" );
if( fp == NULL ) { fprintf( stderr, "text_tofile: can't open Tempfile.\n" ); exit(); }
fprintf( fp, "%s\n", s );
fclose( fp );
}


/* ============ */
/* main program for testing these routines. */
/* main() 
{
char s[30];
char *getln();
strcpy( s, "Hello\nworld\nhello\n" );
printf( "%d\n", countln( s ) );
printf( "%s\n", getln( s ) );
printf( "%s\n", getln( s ) );
printf( "%s\n", getln( s ) );
strcpy( s, "Hello\nworld\nhello" );
printf( "%d\n", countln( s ) );
printf( "%s\n", getln( s ) );
printf( "%s\n", getln( s ) );
printf( "%s\n", getln( s ) );
text_tofile( s, "/usr/tmp/testutil001" );
}
*/
