/* Object alignment system */

#include "elib.x"

/* ======================================================== */
/* Run alignment on everything.. */
Ealignall()
{
int ip;
char *package, *procname;

Esquelch_display( 1 );

EIgetnextobj( E_AT_BEGINNING, 1 );
while( 1 ) {
	ip = EIgetnextobj( E_NEXT, 1 );
	if( ip < 0 ) break;

	package = EIgetpackagename( ip );
	if( strcmp( package, "plot" )==0 ) continue; /* don't run alignment on the plot objects.. */

	Ealign( ip );
	Egen( ip ); /* update bb */
	}
EIgetnextobj( E_DONE, 1 );

/* experimental.. */
Esquelch_display( 0 );
return( 1 ); 

}

/* ======================================================== */
/* run alignment on proc p */
/* p should not have been displayed yet */
/* this will modify the translation vector for the object.. */
Ealign( p )
int p;
{
int len, len2, guidep;
double *x1, *y1, *x2, *y2;
double *guidex1;
double *oldtrl_x, *oldtrl_y;
char *hexpr, *vexpr, side[12], obj[20], alex[12], foo[12];
double pos, trl_x, trl_y;
char buf[40];
double root[4];

if( !EIexists( p, "", "*/display" )) return( 0 );
EIgetc( p, "", "*/display", &len ); /* invisible.. */
if( len < 1 ) return( 0 );

if( !EIexists( p, "", "*/align_h" )) return( 0 );

/* first see if there is any alignment info.. */
hexpr = EIgetc( p, "", "*/align_h", &len );
vexpr = EIgetc( p, "", "*/align_v", &len2 );
if( len == 0 && len2 == 0 ) return( 0 );

/* set up root entry.. */
root[0] = 0.0; root[1] = 0.0; root[2] = EWinx; root[3] = EWiny; 

/* if bb doesn't exist yet, generate the object silently to get bounding box.. */
/* get a clean bounding box.. */
Esquelch_display( 1 );
Enulloutbb( p );
Egen( p );
Esquelch_display( 0 );
x1 = EIgetd( p, "", "*/bb", &len );
y1 = x1 + 1; x2 = x1 + 2; y2 = x1 + 3;

oldtrl_x = EIgetd( p, "", "*/trl", &len );
oldtrl_y = oldtrl_x + 1;

trl_x = 0.0; trl_y = 0.0;

/* horizontal.. */

if( sscanf( hexpr, "%s %s %s %s", side, obj, alex, foo ) != 3 )
	{ fprintf( stderr, "(%s) Illegal alignment expression.\n", hexpr ); return( 0 ); }

if( strcmp( obj, "root" )==0 ) guidex1 = root;
else	{
	guidep = EItaglookup( obj, E_NIL );   /* get the proc_id for the h guide tag.. */
	if( guidep == E_NIL ) { fprintf( stderr, "Referenced tag (%s) not found.\n", obj ); return( 0 ); }
	
	/* get the bounding box of guidep.. */
	guidex1 = EIgetd( guidep, "", "*/bb", &len );
	if( len != 4 ) { fprintf( stderr, "Referenced object (%s) has bad bb, len=%d.\n", obj, len ); return( 0 ); }
	}

Eparse_alex( alex, guidex1, &pos, 'h' );
if( side[0] == 'L' ) trl_x = pos - *x1;
else if( side[0] == 'R' ) trl_x = pos - *x2;
else if( side[0] == 'C' ) trl_x = pos - (*x1 + ((*x2 - *x1)/2.0));


/* vertical.. */
if( sscanf( vexpr, "%s %s %s %s", side, obj, alex, foo ) != 3 )
	{ fprintf( stderr, "(%s) Illegal alignment expression.\n", vexpr ); return( 0 ); }

if( strcmp( obj, "root" )==0 ) guidex1 = root;
else	{
	guidep = EItaglookup( obj, E_NIL ); /* get the proc_id for the v guide tag.. */
	if( guidep == E_NIL ) { fprintf( stderr, "Referenced tag (%s) not found.\n", obj ); return( 0 ); }
	
	/* get the bounding box of guidep.. */
	guidex1 = EIgetd( guidep, "", "*/bb", &len );
	if( len != 4 ) { fprintf( stderr, "Referenced object (%s) has bad bb, len=%d.\n", obj, len ); return( 0 ); }
	}
Eparse_alex( alex, guidex1, &pos, 'v' );
if( side[0] == 'B' ) trl_y = pos - *y1;
else if( side[0] == 'T' ) trl_y = pos - *y2;
else if( side[0] == 'C' ) trl_y = pos - (*y1 + ((*y2 - *y1)/2.0));

/* translate.. */
Emoveobj( p, trl_x, trl_y );

return( 1 );
}

/* ============================================ */
/* parse an alignment expression */
Eparse_alex( expr, x1, pos, dir )
char expr[];
double *x1;
double *pos;
char dir;
{
double *y1, *x2, *y2, ofs;
char side;

*pos = 0; ofs = 0;
y1 = x1 + 1; x2 = x1 + 2; y2 = x1 + 3;
side = expr[0];

if( strlen( expr ) > 1 ) ofs = atof( &expr[1] );

if( side == 'L' ) *pos = *x1 + ofs;
else if( side == 'R' ) *pos = *x2 + ofs;
else if( side == 'B' ) *pos = *y1 + ofs;
else if( side == 'T' ) *pos = *y2 + ofs;
else if( side == 'C' && dir == 'h' ) *pos = (*x1 + ((*x2 - *x1)/2.0)) + ofs;
else if( side == 'C' && dir == 'v' ) *pos = (*y1 + ((*y2 - *y1)/2.0)) + ofs;
}
