/* do a rectangle, with shading and/or outline */
#include "elib.x"

double Ebox_x1 = 0, Ebox_y1 = 0, Ebox_x2 = 0, Ebox_y2 = 0;

/* Eblock() - all coords in abs space */
Eblock( xlo, ylo, xhi, yhi, shade, outline )
double xlo, ylo, xhi, yhi, shade;
int outline;
{
if( shade >= 0 ) {
	Emov( xlo, ylo );
	Epath( xlo, yhi );
	Epath( xhi, yhi );
	Epath( xhi, ylo );
	Eshade( shade );
	}
if( outline ) {
	Emov( xlo, ylo );
	Elin( xlo, yhi );
	Elin( xhi, yhi );
	Elin( xhi, ylo );
	Elin( xlo, ylo );
	}
}

/* ========================================== */
/* Eblocku() - all coords in user space */
Eblocku( xlo, ylo, xhi, yhi, shade, outline )
double xlo, ylo, xhi, yhi, shade;
int outline;
{
double x1, y1, x2, y2;

x1 = Eax( xlo );
y1 = Eay( ylo );
x2 = Eax( xhi );
y2 = Eay( yhi );
Eblock( x1, y1, x2, y2, shade, outline );
}

/* ============================================== */
/* set last box */
Esetlastbox( x1, y1, x2, y2 )
double x1, y1, x2, y2;
{
Ebox_x1 = x1; Ebox_y1 = y1; Ebox_x2 = x2; Ebox_y2 = y2;
}
/* ============================================== */
/* get dimensions of most recently generated box.. */
Egetlastbox( x1, y1, x2, y2 )
double *x1, *y1, *x2, *y2;
{
*x1 = Ebox_x1; *y1 = Ebox_y1; *x2 = Ebox_x2; *y2 = Ebox_y2;
}

/* ============================================== */
/* Eblockdress - neat shadowing for rectangles */
Eblockdress( x1, y1, x2, y2, lowfrontshadow, hifrontshadow, fssiz, backshadow, bssiz )
double x1, y1, x2, y2;
double lowfrontshadow, hifrontshadow, fssiz, backshadow, bssiz;
{

if( lowfrontshadow >= 0.0 ) {
	Emov( x1, y1 ); Epath( x1+fssiz, y1+fssiz ); 
	Epath( x2-fssiz, y1+fssiz ); Epath( x2-fssiz, y2-fssiz ); 
	Epath( x2, y2 ); Epath( x2, y1 ); Eshade( lowfrontshadow );
	}
if( hifrontshadow >= 0.0 ) {
	Emov( x1, y1 ); Epath( x1+fssiz, y1+fssiz ); Epath( x1+fssiz, y2-fssiz );
	Epath( x2-fssiz, y2-fssiz ); Epath( x2, y2 ); Epath( x1, y2 ); Eshade( hifrontshadow );
	}

if( backshadow >= 0.0 ) {
	Ebbexempt( 1 ); /* make shadows not update bounding box so that centering is true.. */
        Eblock( x1+bssiz, y1-bssiz, x2+bssiz, y1, backshadow, 0 );
        Eblock( x2, y1-bssiz, x2+bssiz, y2-bssiz, backshadow, 0 );
	Ebbexempt( 0 );
	}
}
