/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/


/* for generating a single button. */

#include "elib.x"

Ebutton( txt, posx, posy, margin, color, width )
char txt[];
double posx, posy;
double margin;
double color;
double width; /* explicit width, or -1.0 for auto (based on text).  margin additional. */
{
double x, y, w;
double x1, x2, y1, y2;

x = posx; y = posy;

if( width < 0 ) w = strlen( txt ) * Ecurtextwidth;
else w = width;
x1 = x - margin;
x2 = x + w + margin;
y1 = y  - margin;
y2 = y + Ecurtextheight + margin;
Eblock( x1, y1, x2, y2, color, 0 );
Esetlastbox( x1, y1, x2, y2 );

Emov( x + (w/2.0), y );
Ecentext( txt );
}



/* === The GEN routine ============ */
EAbutton( p, path )
int p;
char path[];
{
int i, j;
char newpath[80];
char *txt;
double *d1, *d2, *color, *margin, hilitecolor;
double posx, posy;
int len;
char buttonlabel[200]; /* LIMIT */
double x1, y1, x2, y2;
int ix;
double hzones[20];
char buf[ E_GPBUF ];
int *h, hselect;
double *width;

txt = EIgetc( p, path, "text", &len );
if( len < 1 ) return( 0 );

sprintf( newpath, "%s/text", path );
EAtext_props( p, newpath );

d1 = EIgetd( p, path, "position", &len ); d2 = d1; d2++;
if( len < 2 ) return( 0 );
else { posx = *d1; posy = *d2; }

margin = EIgetd( p, path, "box.margin", &len );
color = EIgetd( p, path, "box.color", &len );

width = EIgetd( p, path, "width", &len ); /* explicit width */
if( len < 1 ) *width = -1.0;

/* typ = EIgetc( p, path, "type", &len ); */
h = EIgeti( p, path, "pick/hselect", &len );   /* 0..n */
if( len > 0 ) hselect = *h;
else hselect = -1;


if( *color > 0.6 ) hilitecolor = 0.0; 
else hilitecolor = 1.0;

for( ix = 0, j = 0; ; j++ ) {
	hzones[j] = posx-(*margin);
	Egetchunk( buttonlabel, txt, &ix, "," );
	if( strlen( buttonlabel ) < 1 ) break;

	/* draw the currently selected button in reverse vid.*/
	if( j == hselect ) {  
		if( hilitecolor == 0.0 ) Esetdrawcolor( E_WHITE );
		else Esetdrawcolor( E_BLACK );
		Ebutton( buttonlabel, posx, posy, *margin, hilitecolor, *width );
		if( Ecurcolor == E_WHITE ) Esetdrawcolor( E_BLACK );
		else Esetdrawcolor( E_WHITE );
		EImodattr( p, "", "pick/value", buttonlabel );
		}
	else Ebutton( buttonlabel, posx, posy, *margin, *color, *width );

	EIgetc( p, path, "dress", &len );
	if( len > 0 ) {
       		sprintf( newpath, "%s/dress", path );
        	EArect_dress( p, newpath );
		}
	Egetlastbox( &x1, &y1, &x2, &y2 );
	posx = x2+(*margin);
	}

/* save the horizontal cuts.. */
buf[0] = '\0';
for( i = 0; i <= j; i++ ) sprintf( buf, "%s%g ", buf, hzones[i] ); /* portability? */
EImodattr( p, "", "pick/hzones", buf );
return( 1 );
}

/* ==== The EXEC routine ============= */
EEbutton( p, x, y, e, message )
int p;
double x, y;
int e;
char message[];
{
int i, j, len;
double *c, color;
double *d;
char buf[12];
char *sendmsg, *recip;
int recip_id;
double left, right;
char *txt;
int ix;
char buttonlabel[30];
int hselect;
char msg[80];
char *flashpick;
int unsel;
int *cursel;

/* allow mouse clicks and messages.. */
if( e < 1000 ) return( 0 );

if( e == E_MESSAGE && strcmp( message, "RESET" )==0 ) {
	EImodattr( p, "", "pick/hselect", "" );
        EImodattr( p, "", "pick/value", "" );
	return( 1 );
	}

txt = EIgetc( p, "", "text", &len );

c = EIgetd( p, "", "box.color", &len );
color = *c;
/* typ = EIgetc( p, "", "type", &len ); removed scg Nov 95 */


EIgetc( p, "", "unpick", &unsel ); /* scg */

/* see which button was pressed.. */
d = EIgetd( p, "", "pick/hzones", &len );
if( len < 1 ) return( 0 );

for( i = 0; i < len; i++ ) if( *(d+i) > x ) break;

hselect = i-1;
left = *(d+i);
right = *(d+i+1);

for( j = 0, ix = 0; j <= hselect; j++ )Egetchunk( buttonlabel, txt, &ix, "," );

cursel = EIgeti( p, "", "pick/hselect", &len ); /* scg */
if( len < 1 || *cursel != hselect ) {		/* scg */
	sprintf( buf, "%d", hselect );
	EImodattr( p, "", "pick/hselect", buf );
	EImodattr( p, "", "pick/value", buttonlabel ); 
	strcpy( Eselection, buttonlabel );
	}
else if( unsel ) { /* scg */
	Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" ); /* scg */
	Eselection[0] = '\0';
	}

/* send a message to other object(s) if requested */
sendmsg = EIgetc( p, "", "message", &len );
if( len > 0 ) {
	/* find the message corresponding to the button pressed.. */
	for( j = 0, ix = 0; j <= hselect; j++ )Egetchunk( msg, sendmsg, &ix, "," );
	/* process the message(s) */
	Eprocess_message( p, msg );
	}

Egen( p );

/* flash pick */
flashpick = EIgetc( p, "", "flashpick", &len );
if( len > 0 ) {
	Eflush();
	Eusleep( Eflashdelay );
	Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" );
	Egen( p );
	}

return( 1 );
} 
