/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/


/* CLI - capture command line arguments, marshall them into a
	record, and send record over command pipe.
	When results come back via results pipe, print them to stdout.

*/
#include <stdio.h>
#include <fcntl.h>

#include "bigbuf.h"

#define TMP_DIR "/usr/tmp"


main( argc, argv )
int argc;
char **argv;
{
char buf[SELECTIONMAX+1], *copa_pipe, compipe[80], resultpipe[80], *getenv();
int i, j, k;
int cfd, rfd, nbytes;
int stat;
char dc1[3], dc2[3];
int pos;
char *c, *expand_txt();
int noterm, predelim, nodelim, nopre, autonewline, forcedelim; /* for echo exception */
int len;
int timeout;
long elapsed;

sprintf( dc1, "%c", 17 );
sprintf( dc2, "%c", 18 );

if( argc < 2 ) {
	Eerrmsg( 50, "Usage: copa  command  [args]", "" );
	exit(1);
	}

/* open pipes */
copa_pipe = getenv( "COPA_PIPE" );
if( copa_pipe == NULL ) sprintf( buf, "%d", geteuid() );
else if( strlen( copa_pipe ) < 1 ) sprintf( buf, "%d", geteuid() );
else sprintf( buf, "%d%s", geteuid(), copa_pipe );
if( strlen( buf ) > 20 ) buf[20] = '\0'; /* truncate at length of 20 */
 
sprintf( compipe, "%s/copaC%s", TMP_DIR, buf );
sprintf( resultpipe, "%s/copaR%s", TMP_DIR, buf );


/* rfd = open( resultpipe, O_RDONLY | O_NONBLOCK ); */
rfd = open( resultpipe, O_RDONLY | O_NDELAY );
if( rfd == NULL ) {
	Eerrmsg( 51, "Client cannot open fifo", resultpipe );
	exit(1);
	}


/* open command pipe */
cfd = open( compipe, O_WRONLY );
if( cfd == NULL ) {
	Eerrmsg( 52, "Client cannot open fifo", compipe );
	exit(1);
	}

/* handle echo (special case)..  srv will see one command: 
	copa  echo  .!begin tag   text   .!end   */
noterm = 0; predelim = 0; nodelim = 0; nopre = 0; autonewline = 0; forcedelim = 0;
if( strcmp( argv[1], "echo" )==0 ) {
	if( strncmp( argv[2], ".!begin", 5 )==0 ) { noterm = 1; forcedelim = 1; }
	else if( strcmp( argv[2], ".!end" )==0 ) { predelim = 1; nopre = 1; }
	else	{ noterm = 1; nodelim = 1; nopre = 1; autonewline = 1; }
	}


/* write args (!commands within text args are expanded here then piped).. */
for( i = 0; i < argc; i++ ) {

	if( nopre && i < 2 ) continue; /* echo exception */

	/* there must be an argv[1] if we got this far.. */
	c = expand_txt( argv[1], i, argv[i] ); 

	/* convert 17 and 18 to 19.. */
	len = strlen( c );
	for( j = 0; j < len; j++ ) if( c[j] == 17 || c[j] == 18 ) c[j] = 19;
	
	/* fprintf( stderr, "Sending[%s]", c ); fflush( stderr ); */

	if( predelim )write( cfd, dc1, 1 ); /* echo exception */

	write( cfd, c, strlen( c ) );

	if( autonewline ) write( cfd, "\n", 1 ); /* echo exception */

	if( forcedelim ) write( cfd, dc1, 1 ); /* echo exception */
	else if( i < (argc-1) && !nodelim )write( cfd, dc1, 1 ); /* write arg delimiter */
	}

if( !noterm ) write( cfd, dc2, 1 ); /* write terminator */
close( cfd ); /* close command pipe */
if( noterm ) exit( 0 );

/* gather results */
if( argc >= 3 && strcmp( argv[2], "display" )==0 && strcmp( argv[3], "ping" )==0 ) {
	timeout = 1;
	elapsed = 0;
	}
else timeout = 0;

pos = 0;
while( 1 ) {
	nbytes = read( rfd, &buf[pos], SELECTIONMAX-(pos+1) );
	if( nbytes <= 0 ) {   /* sleep then try again.. */
		stat = Eusleep( 20000 ); /* 1/50th of a second */

		/* keep track of time for ping command */
		if( timeout ) {
			elapsed++;
			if( elapsed > 200 ) {
				printf( "noresponse\n" );
				exit(0);
				}
			}
		if( stat != 0 ) {
			sprintf( buf, "%d", stat );
			Eerrmsg( 54, "Client sleep error", buf );
			exit( 1 );
			}
		continue;
		}

	if( buf[ pos+(nbytes-1) ] != 18 ) { /* there's more to read for this record.. */
		pos += nbytes;
		nbytes = 0;
		if( pos > SELECTIONMAX-2 ) {
			Eerrmsg( 53, "warning: results too long.. truncated", "" );
			break;
			}
		continue;
		}
	break; /* we've gotten it all */
	}
buf[ pos+(nbytes-1) ] = '\0';


/* write results to stdout */
if( strcmp( buf, ".!error" )==0 ) {
	fprintf( stderr, "while executing command: " );
	for( i = 0; i < argc; i++ ) fprintf( stderr, "%s ", argv[i] );
	fprintf( stderr, "\n" );
	printf( ".!error\n" );
	exit(0);
	}
else if( strncmp( buf, ".!ok", 4 )==0 ) /* printf( "(%s)\n", buf ) */ ;

else printf( "%s\n", buf );

/* if this is a 'quit', remove the pipes.. */
if( strcmp( argv[1], "quit" )==0 ) {
	unlink( compipe );
	unlink( resultpipe );
	}

/* exit */
exit(0);
}
/* ========================== */
/* For situations where command expansion is allowed, do it.. */
static char *
/* expand_txt( char *com, int argi, char *arg ) */
expand_txt( com, argi, arg )
char *com;
int argi;
char *arg;
{
int i;
char *c;
char *copa_txt();
int full;
int stat;
int expand;
char *copa_fillbuf();

static char *s;

/* see if this is a situation where expansion is possible.. */
expand = 0;
if( strcmp( com, "text" )==0 && argi == 3 ) expand = 1;
else if( strncmp( com, "pop", 3 )==0 && argi == 2 ) expand = 1;
else if( strcmp( com, "poplist" )==0 && argi == 3 ) expand = 1;
else if( strcmp( com, "echo" )==0 && argi == 2 ) expand = 1;

if( !expand ) { /* just return pointer to original arg.. */
	return( arg );
	}

else s = copa_fillbuf( arg, 0 ); /* expand it */

return( s );
}


/* =============================== */
/* append str to buffer */
static int
addb( bb, str )
char bb[], str[];
{
int len;

len = strlen( bb );
sprintf( &bb[ len ], "%s", str );
}
