/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/



#include "elib.x"

static int inuse = 0; /* This will be set to the object id for redraw purposes.. */

/* =================================== */
/* The GEN routine.. */
/* Make a one-line data entry area. */

EAentryfield( p, path )
int p, path;
{
double *posx, *posy;
double x, y, x1, y1, x2, y2;
char newpath[80], *entry;
int *w, len;
double cursorpos, *cursorcolor, *margin, *color;
int textcolor;
int active;
int curchar;
char *pr;
char buf[E_GPBUF];
int showicur;

EIgetc( p, "", "active", &len );
if( len > 0 ) active = 1; else active = 0;

/* if( active ) Ekeyboard_focus( p ); */ /* removed scg Nov 95 */

posx = EIgetd( p, path, "position", &len );
if( len != 2 ) { fprintf( stderr, "Position must be specified for getstring.\n" ); return( 0 ); }
posy = posx + 1;

x = *posx; y = *posy;

sprintf( newpath, "%s/text", path );
EAtext_props( p, newpath );

textcolor = Ecurcolor;

w = EIgeti( p, path, "maxlength", &len );
pr = EIgetc( p, path, "prompt", &len );

/* backing box.. */
margin = EIgetd( p, path, "box.margin", &len );
color = EIgetd( p, path, "box.color", &len );
x1 = x - (*margin);
y1 = y - (*margin);
x2 = x + (((*w)+2) * Ecurtextwidth ) + (strlen( pr ) * Ecurtextwidth) + (*margin);
y2 = y + Ecurtextheight+ (*margin);
Eblock( x1, y1, x2, y2, *color, 0 );
Esetlastbox( x1, y1, x2, y2 );

/* rectangle dressing */
EIgetc( p, path, "dress", &len );
if( len > 0 ) {
	sprintf( newpath, "%s/dress", path );
	EArect_dress( p, newpath );
	}
	

Esetdrawcolor( textcolor );

/* prompt and any existing text.. */
Emov( x, y ); Etext( pr );
entry = EIgetc( p, path, "pick/value", &len );
Emov( x + ((strlen( pr )+1)*Ecurtextwidth), y ); Etext( entry );

/* cursor.. */
curchar = strlen( entry ) + strlen( pr ) + 1;
cursorpos = x + ( curchar * Ecurtextwidth );
cursorcolor = EIgetd( p, path, "cursor.color", &len );
EIgetc( p, path, "showicur", &showicur );
if( active )Eblock( cursorpos, y-.03, cursorpos+Ecurtextwidth, y+Ecurtextheight, *cursorcolor, 0 );
else if( showicur ) {
	Elinetype( 0, 1.0, 1.0 ); 
	Eblock( cursorpos, y-.03, cursorpos+Ecurtextwidth, y+Ecurtextheight, *color, 1 );
	}
}

/* ============================================== */
/* The EXEC routine.. */
/* Get characters until a return is pressed, or a mouse button is pressed. */
/* The decimal ascii value of the terminating key will be returned, or 0 or 1 */
/* append the character e to the end of the entry.. */
EEentryfield( p, x, y, e, message )
int p;
double x, y;
int e;
char message[];
{
double *posx, *posy;
char s[2];
double cursorpos, *cursorcolor, *color;
int len;
int *w;
double lx, ly;
int curchar;
int c;
char *pr;
char *next;
int nextp, status;
double startpos;
int first;
char *mousemode, *tweakmode;
int clickp;
int nc;
double *tx;
int do_tx;
double pos;

/* TOP: removed scg Nov 95 */

c = e;

if( e == E_MESSAGE && strcmp( message, "RESET" )==0 ) { 
	EImodattr( p, "", "pick/value", "" );
	return( 1 );
	}

/* if( c < 1000 ) return( 0 ); */
first = 0;
if( c < 1000 ) first = 1;

do_tx = 0;
tx = EIgetd( p, "", "*/trl", &do_tx );

EImodattr( p, "", "active", "x" ); /* make it active.. */
/* Ekeyboard_focus( p ); */ /* removed scg Nov 95 */
Egen( p );
if( e == E_MESSAGE && strcmp( message, "ACTIVATE" )==0 ) return( 0 ); /* scg 1-31-96 */

Egraphenv( E_PUSH ); 
if( EAstd( p, "*" ) == 0 ) { Egraphenv( E_POP ); return( 0 ); } /* object not visible, return.. */

posx = EIgetd( p, "", "position", &len );
posy = posx + 1;

EAtext_props( p, "text" );

w = EIgeti( p, "", "maxlength", &len );
pr = EIgetc( p, "", "prompt", &len );
color = EIgetd( p, "", "box.color", &len );
strcpy( Eselection, EIgetc( p, "", "pick/value", &len ) );
curchar = strlen( Eselection ) + strlen( pr ) + 1;

cursorcolor = EIgetd( p, "", "cursor.color", &len );

mousemode = EIgetc( p, "", "mousemode", &len );

tweakmode = EIgetc( p, "", "tweakmode", &len );

cursorpos = (*posx) + ( curchar * Ecurtextwidth ); /* update position.. */
startpos = *posx + ( ( strlen( pr ) + 1 ) * Ecurtextwidth );
lx = x; ly = y;
inuse = p; /* in case of redraw in midst of data entry */

/* for every character.. */
while( 1 ) {  
	if( ! first ) {
		Egetkey( &lx, &ly, &c );
		Esavekey( lx, ly, c ); /* remember event in case its needed later.. */
		}
	if( c >= 1000 ) {  /* a mouse button was pressed.. added 12-7-95 scg */

		/* tweak -- allow middle mouse button to decrement selected digit; right mouse
		   		button increment selected digit. */
		if( tweakmode[0] == 'x' ) {
			if( do_tx > 0 ) lx -= (*tx); /* we may have to translate if object was aligned.. */
			nc = (int) ( (lx - *posx) / Ecurtextwidth ) - (strlen( pr ) + 1) ;
			if( nc < 0 || nc >= strlen( Eselection ) ) {
				if( c == E_MOUSE_MIDDLE || c == E_MOUSE_RIGHT ) continue;
				/* else fall thru.. */
				}
			else if( c == E_MOUSE_LEFT );
			else if( Eselection[ nc ] >= '0' && Eselection[ nc ] <= '9' ) {
				if( c == E_MOUSE_MIDDLE ) Eselection[ nc ]--;
				if( c == E_MOUSE_RIGHT ) Eselection[ nc ]++;
				/* wrap.. */
				if( Eselection[ nc ] > '9' ) Eselection[ nc ] = '0';
				if( Eselection[ nc ] < '0' ) Eselection[ nc ] = '9';

				/* erase old digit and display new one.. */
				pos = startpos + ( nc * Ecurtextwidth );
				Eblock( pos-0.01, (*posy)-.03, pos+Ecurtextwidth+0.01, 
					(*posy)+Ecurtextheight, *color, 0 );
				Emov( startpos, (*posy) ); Etext( Eselection );
				continue;
				}
			}

		/* handle mouse clicks other than tweaks.. */
		if( mousemode[0] == 'T' ) break;  /* terminate */
		else if( mousemode[0] == 'I' ) continue; /* ignore */
		else if( mousemode[0] == 'R' ) {  /* terminate if mouse click within range */
			clickp = Ewhichobj( x, y );
			if( clickp == p ) break;
			else continue;
			}
		continue;  
		}
	if( ! inuse ) break; /* for resize during data entry - terminate */
	first = 0;

	/* tab, carriage return or escape */
	if( c == '\011' || c == '\012' || c == '\015' || c == '\033' ) break; 

	else if( ( c == '\010' || c == '\177' ) ) {   /* backspace.. */
	
		if( curchar <= (strlen( pr ) + 1) ) continue;
		else curchar--;

		/* erase old cursor (a little extra to clean up any grunge) */
		Eblock( (cursorpos-0.01), (*posy)-.03, cursorpos+Ecurtextwidth+0.01, 
			(*posy)+Ecurtextheight, *color, 0 );

		cursorpos = (*posx) + ( curchar * Ecurtextwidth ); /* update position.. */
	
		/* draw the cursor over the existing character.. */
		Eblock( cursorpos, (*posy)-.03, cursorpos+Ecurtextwidth, (*posy)+Ecurtextheight, 
			*cursorcolor, 0 );
	
		Eselection[ strlen( Eselection ) - 1 ] = '\0';  /* take the last char off end of buf.. */
		continue;
		}
	else if( strlen( Eselection ) >= (*w) ) {  /* check length */ 
		fprintf( stderr, "%c", 7 ); /* bell */ /* scg */
		/* break */ /* scg */
		continue; /* scg */
		}
	else if( c < 32 || c > 126 ) continue; /* throw out garbage chars.. */
	
	curchar++;
	cursorpos = (*posx) + ( curchar * Ecurtextwidth );

	/* erase old cursor (with slight extra to get rid of any grunge) and draw new cursor.. */
	Eblock( (cursorpos-Ecurtextwidth)-0.01, (*posy)-.05, cursorpos+0.01, (*posy)+Ecurtextheight, *color, 0 );
	Eblock( cursorpos, (*posy)-.03, cursorpos+Ecurtextwidth, (*posy)+Ecurtextheight, *cursorcolor, 0 );

	/* display new character.. */
	/* sprintf( s, "%c", c ); Emov( cursorpos-Ecurtextwidth, (*posy) ); Etext( s );    */

	/* sprintf( Eselection, "%s%c", Eselection, c ); */     /* build up the buffer.. */
	len = strlen( Eselection );
	Eselection[ len ] = c;
	Eselection[ len+1 ] = '\0';

	Emov( startpos, (*posy) ); Etext( Eselection );


	}

/* finish up.. */
EImodattr( p, "", "pick/value", Eselection );	/* save the new value.. */
EImodattr( p, "", "active", "" ); 	/* make it inactive.. */

Egraphenv( E_POP );
Egen( p );
inuse = 0;

return( c );
}

/* ====================================================== */
/* special case-- handle redraw in midst of data entry.. */

Eredraw_entryfield()
{
if( inuse ) {
	EImodattr( inuse, "", "pick/value", Eselection );	/* save the new value.. */
	EImodattr( inuse, "", "active", "" );	/* make it inactive */
	inuse = 0;
	/* Egen( inuse ); */
	}
}
