/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/


#include "elib.x"

/* ==================================================== */
/* return 1 "if it did anything", 0 otherwise */
Eexec( p, x, y, e, message )
int p;
double x, y;
int e;
char message[];
{
char *packagename, *procname;
double *tx, *ty;
int len, status;

procname = EIgetobjname( p );
packagename = EIgetpackagename( p );

status = 0;
if( strcmp( packagename, "std" )==0 ) {

/*
 *	if( strcmp( procname, "scalezone" )==0 ) {
 *		/ don't adjust coords../
 *		status = EEscalezone( p, x, y, e, message );
 *		return( status );
 *		}
 */

	/* get translation vector and adjust coords */
	tx = EIgetd( p, "", "*/trl", &len );
	if( len > 0 ) {
		ty = tx; ty++; 
		x -= (*tx);  y-= (*ty);
		}

	if( strcmp( procname, "textb" )==0 ) status = EEtextb( p, x, y, e, message );
	else if( strcmp( procname, "dataentry" )==0 ) status = EEentryfield( p, x, y, e, message );
	else if( strcmp( procname, "button" )==0 ) status = EEbutton( p, x, y, e, message );
	else if( strcmp( procname, "slider" )==0 ) status = EEslider( p, x, y, e, message );
	else if( strcmp( procname, "rectangle" )==0 || strcmp( procname, "ellipse" )==0 ) { 
		/* nothing other than object pick.. */
		EIgetc( p, "", "pick", &len );
		if( len > 0 ) { Eselection[0] = '\0'; status = 1; }
		else status = 0;
		}
	}
return( status );
}

/* ========================================================== */
EEscalezone( p, x, y, e, message )
int p, e;
double x, y;
char message[];
{
double *x1, *y1, *x2, *y2, *xlo, *ylo, *xhi, *yhi, Edx(), Edy(), zero, one;
int len;
char *xscaletype, *yscaletype;

zero = 0.0;
one = 1.0;

EIgetc( p, "", "pick", &len );
if( len < 1 ) return( 0 );

x1 = EIgetd( p, "*", "bb", &len );
y1 = x1 + 1;
x2 = x1 + 2;
y2 = x1 + 3;

xlo = EIgetd( p, "", "xrange", &len );
if( len != 2 ) { xlo = &zero; xhi = &one; }
else xhi = xlo + 1;
ylo = EIgetd( p, "", "yrange", &len );
if( len != 2 ) { ylo = &zero; yhi = &one; }
else yhi = ylo + 1;

xscaletype = EIgetc( p, "", "xscaletype", &len );
yscaletype = EIgetc( p, "", "yscaletype", &len );

Escaletype( xscaletype, 'x' );
Escale_x( *x1, *x2, *xlo, *xhi );

Escaletype( yscaletype, 'y' );
Escale_y( *y1, *y2, *ylo, *yhi );

sprintf( Eselection, "%g %g", Edx( x ), Edy( y ) );
}
 


/* ========================================================== */
/* process message(s) */
/* msg is a semicolon-separated list of messages. */
/* Each message is of the format MESSAGE TEXT > RECIPIENT_TAG */
Eprocess_message( p, msg )
int p; /* procid of the sender */
char msg[];
{
int i, j, k, ix, idx, recip_id;
char m[40], txt[30], recip[30];

if( sscanf( msg, "%s", txt ) < 1 ) return( 0 );

for( i = 0, ix = 0; ; i++ ) {
	Egetchunk( m, msg, &ix, ";" );
	if( strlen( m ) < 1 ) break;
	
	idx = 0;
	Egetchunk( txt, m, &idx, ">" );
	Estrip_ws( txt );
	sscanf( &m[idx+1], "%s", recip );
	/* this lookup should really first check the group if any, then the whole list.. */
	recip_id = EItaglookup( recip, p );
	if( recip_id == E_NIL ) { 
		fprintf( stderr, "Message recipient (%s) not recognized.\n", recip );
		continue;
		}
	else Eexec( recip_id, 0.0, 0.0, E_MESSAGE, txt );
	}
}
