/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/



#include "elib.x"

static double *Ed1;
static int Eival;

/* Egen() - generate (redraw) an object.  Returns 1 on success, 0 otherwise.. */
Egen( p )
int p;
{
char *procname;
char *attr;
char *package;
int id;
char str[20];


if( p < 0 ) { fprintf( stderr, "Egen: object does not exist.\n" ); return( 0 ); }

/* get proc name */
procname = EIgetobjname( p );

/* get package */
package = EIgetpackagename( p );





if( strcmp( package, "std" )==0 ) {

	/* group begin/end (handle specially) */
	if( strcmp( procname, "group_begin" )==0 ) {
		Eobjbegin( p );
		EAstd( p, "*" );
		return( 1 );
		}
	else if( strcmp( procname, "group_end" )==0 ) {
		id = Eobjend( "B" );
		sprintf( str, "%d", p );
		EImodattr( id, "", "endid", str );
		return( 1 );
		}


	/* other objects.. */
	Ebatch_on();
	Egraphenv( E_PUSH );
	Eobjbegin( p );

	if( EAstd( p, "*" ) != 0 ) {  /* if it's visible.. */

		if( strcmp( procname, "textb" )==0 ) EAtextb( p, "" );
		else if( strcmp( procname, "line" )==0 ) EAline( p, "" );
		else if( strcmp( procname, "dataentry" )==0 ) EAentryfield( p, "" );
		else if( strcmp( procname, "button" )==0 ) EAbutton( p, "" );
		else if( strcmp( procname, "slider" )==0 ) EAslider( p, "" );
		else if( strcmp( procname, "scalezone" )==0 ) EAscalezone( p, "" );
		else if( strcmp( procname, "rectangle" )==0 ) EArectangle( p, "" );
		else if( strcmp( procname, "ellipse" )==0 ) EAellipse( p, "" );
		else if( strcmp( procname, "backing" )==0 ) EAbacking( p, "" );
		else if( strcmp( procname, "elib_journal" )==0 ) EAelib_journal( p, "" );
		}
	
	if( strcmp( procname, "line" )==0 ) Eobjend( "L" );
	else Eobjend( "B" ); 


	Egraphenv( E_POP );

	/* see if we need to do textb scroller.. */
	if( strcmp( procname, "textb" )==0 ) EAvscroller( p );
		
	Ebatch_off();
	}
#ifdef PLOT
else if( strcmp( package, "plot" )==0 ) EPgenipl( procname, p );
#endif

return( 1 );
}

/* ================================================== */
EAstd( p, path )
int p;
char path[];
{
char *c1;
double *d1, *d2;
int len;

c1 = EIgetc( p, path, "display", &len );
if( len < 1 ) return(0);

d1 = EIgetd( p, path, "trl", &len ); d2 = d1; d2++;
if( len > 0 )Etrladd( *d1, *d2 );
return( 1 );
}


/* ==================================================== */
EArect_dress( p, path )
int p;
char path[];
{
double x1, y1, x2, y2;
double *d1, *d2, *d3, *d4, f1, f2, f3, f4;
int len;
char newpath[E_ANAMELEN], *c1;
double *color;

Egetlastbox( &x1, &y1, &x2, &y2 );

EIgetc( p, path, "outline", &len );
if( len > 0 ) {
	sprintf( newpath, "%s/outline", path );
	EAline_props( p, newpath );
	Emov( x1, y1 ); Elin( x1, y2 ); Elin( x2, y2 ); Elin( x2, y1 ); Elin( x1, y1 );
	}

d1 = EIgetd( p, path, "shadow", &len );
if( len < 1 ) f1 = -1.0; else f1 = *d1;

d1 = EIgetd( p, path, "shadow.size", &len );
d2 = EIgetd( p, path, "3d.upper", &len );
if( len < 1 ) f2 = -1.0; else f2 = *d2;
d3 = EIgetd( p, path, "3d.lower", &len );
if( len < 1 ) f3 = -1.0; else f3 = *d3;
d4 = EIgetd( p, path, "3d.size", &len );
Eblockdress( x1, y1, x2, y2, f3, f2, *d4, f1, *d1 );
}

/* =========================================== */
EAtext_props( p, path )
int p;
char path[];
{
int *i1, len;
char *c1, *c2;

i1 = EIgeti( p, path, "size", &len ); Etextsize( *i1 );
c2 = EIgetc( p, path, "font", &len ); Efont( c2 );
c1 = EIgetc( p, path, "pen", &len ); 
if( *c1 == 'w' ) Esetdrawcolor( E_WHITE );
else Esetdrawcolor( E_BLACK );
}

/* =========================================== */
EAline( p, path )
int p;
char path[];
{
double *d1, *d2;
int *i1, len;
char newpath[E_ANAMELEN];

sprintf( newpath, "%s/props", path );
EAline_props( p, newpath );
d1 = EIgetd( p, path, "end1", &len ); d2 = d1; d2++; Emov( *d1, *d2 );
d1 = EIgetd( p, path, "end2", &len ); d2 = d1; d2++; Elin( *d1, *d2 );
}

/* =========================================== */
EAline_props( p, path )
int p;
char path[];
{
int len;
double *d1, *d2;
int *i1;
char *c1;

d1 = EIgetd( p, path, "thick", &len );
i1 = EIgeti( p, path, "dash", &len );
d2 = EIgetd( p, path, "dashdens", &len );
Elinetype( *i1, *d1, *d2 );
c1 = EIgetc( p, path, "pen", &len );
if( *c1 == 'w' ) Esetdrawcolor( E_WHITE );
else Esetdrawcolor( E_BLACK );
}

/* =========================================== */
EAelib_journal( p, path )
int p;
char path[];
{
int ix, ixx, len;
double x, y;
char op;
char *journ;
char buf[E_GPBUF], tok[20];

journ = EIgetc( p, path, "text", &len );

ix = 0;
while( 1 ) {
	
	Egetchunk( buf, journ, &ix, "\n" ); /* op */
	if( strlen( buf ) < 1 ) break;

	op = buf[0];
	ixx = 2;
	Egetchunk( tok, buf, &ixx, " " );
	x = atof( tok );
	Egetchunk( tok, buf, &ixx, " " );
	y = atof( tok );
	strcpy( buf, &buf[ixx] );

	Epcode( op, x, y, buf );
	}
}
/* ============================================= */
/* plain rectangle.. */
EArectangle( p, path )
int p;
char path[];
{
double *cx, *cy, *h, *v, *shade;
int len;
char newpath[E_ANAMELEN];
int outline;
char *txt;
int i, ix, nnl;
double ystart, xstart, x1, x2, y1, y2;
char buf[80];

cx = EIgetd( p, path, "position", &len );
if( len != 2 ) return( 0 );
cy = cx + 1;

h = EIgetd( p, path, "horiz", &len );
v = EIgetd( p, path, "vert", &len );

shade = EIgetd( p, path, "color", &len );
EIgetc( p, path, "outline", &len );
if( len > 0 ) outline = 1;
else outline = 0;

if( outline ) {
	sprintf( newpath, "%s/outline", path );
	EAline_props( p, newpath );
	}

Eblock( *cx-(*h), *cy-(*v), *cx+(*h), *cy+(*v), *shade, outline );

txt = EIgetc( p, path, "text", &len );

if( len > 0 ) {
	x1 = *cx-*h;
	y1 = *cy-*v;
	x2 = *cx+*h;
	y2 = *cy+*v;
	xstart = (x1 + x2) / 2.0;
	ystart = (y1 + y2) / 2.0;
	sprintf( newpath, "%s/text", path );
	EAtext_props( p, newpath );

	/* draw text, centered.. */
	for( i = 0, nnl = 1; i < strlen( txt ); i++ ) if( txt[i] == '\n' ) nnl++; /* count newlines */
	ystart += ( (((double)(nnl)-1) / 2.0 ) * Ecurtextheight );
	for( i = 0, ix = 0; i < nnl; i++ ) {
		Egetchunk( buf, txt, &ix, "\n" );
		Emov( xstart, ystart );
		Ecentext( buf );
		ystart-= Ecurtextheight;
		}
	}
}

/* ============================================= */
/* circle/ellipse.. */
EAellipse( p, path )
int p;
char path[];
{
double *cx, *cy, *shade, *r1, *r2;
int len;
char newpath[E_ANAMELEN];
int outline;
char *txt;
int i, ix, nnl;
double ystart;
char buf[80];

cx = EIgetd( p, path, "position", &len );
cy = cx + 1;

r1 = EIgetd( p, path, "hradius", &len );
r2 = EIgetd( p, path, "vradius", &len );

shade = EIgetd( p, path, "color", &len );

EIgetc( p, path, "outline", &len );
if( len > 0 ) outline = 1;
else outline = 0;

if( outline ) {
	sprintf( newpath, "%s/outline", path );
	EAline_props( p, newpath );
	}

Eellipse( *cx, *cy, *r1, *r2, *shade, outline );

txt = EIgetc( p, path, "text", &len );
if( len > 0 ) {
	sprintf( newpath, "%s/text", path );
	EAtext_props( p, newpath );

	/* draw text, centered.. */
	for( i = 0, nnl = 1; i < strlen( txt ); i++ ) if( txt[i] == '\n' ) nnl++; /* count newlines */
	ystart = *cy + ( (((double)(nnl)-1) / 2.0 ) * Ecurtextheight );
	for( i = 0, ix = 0; i < nnl; i++ ) {
		Egetchunk( buf, txt, &ix, "\n" );
		Emov( *cx, ystart );
		Ecentext( buf );
		ystart-= Ecurtextheight;
		}
	}
}

/* =========================================== */
/* scalezone sets up a bounding box but doesn't draw anything..*/

EAscalezone( p, path )
int p;
char path[];
{
double *posx, *posy, *w, *h, *color;
int len;

posx = EIgetd( p, path, "position", &len );
posy = posx + 1;
w = EIgetd( p, path, "width", &len );
h = EIgetd( p, path, "height", &len );

Esquelch_display( 1 );
Emov( *posx, *posy );
Elin( (*posx) + (*w), (*posy) + (*h) );
Esquelch_display( 0 );

color = EIgetd( p, path, "color", &len );
if( len < 1 || *color < 0.0 ) return( 1 );
Eblock( *posx, *posy, (*posx+*w), (*posy+*h), *color, 0 );

}
/* =========================================== */
/* background */
EAbacking( p, path )
int p;
char *path;
{
int len, len2;
double *s;
double *h, *w, color;
char newpath[E_ANAMELEN];

EIgetc( p, path, "nobacking", &len );
if( len > 0 ) return( 0 ); /* do nothing, not even a clear.. */

s = EIgetd( p, path, "color", &len );
if( *s >= 0 ) Eseteraseshade( *s );

if( *s < 0 ) color = 1.0;
else color = *s;

/* if we reach here we will do a rectangle backing box.. */
w = EIgetd( p, path, "box.width", &len );
h = EIgetd( p, path, "box.height", &len2 );
if( len < 1 || len2 < 1 ) { /* no backing box defined, clear entire window.. */
	Eclr();
	return( 0 );
	}

/* do the box.. */
Eblock( 0.0, 0.0, *w, *h, color, 1 );
Esetlastbox( 0.0, 0.0, *w, *h );

/* do the deco */
EIgetc( p, path, "dress", &len );
if( len > 0 ) {
      	sprintf( newpath, "%s/dress", path );
       	EArect_dress( p, newpath );
	}
return( 0 );
}



/* =========================================== */
/* =========================================== */
/* =========================================== */
/* returns 1 on success, 0 otherwise (indicates group begin/end mismatch) */
Egenall()
{
int ip;
double x, y;
int i;
char *objtyp;
int found;


/* first we need to check if backing is defined by user somewhere in the file.. 
   if not specified by user we need to do clear the window here.. */
found = 0;
EIgetnextobj( E_AT_BEGINNING, 0 );
while( 1 ){
	ip = EIgetnextobj( E_NEXT, 0 );
	if( ip < 0 ) break;
	if( strcmp( EIgetobjname( ip ) , "backing" )== 0 ) { found = 1; break; }
	}
EIgetnextobj( E_DONE, 0 );
if( !found ) {
	Eseteraseshade( Ebkcolor0 );
	Eclr();
	}


/* display all objects.. */
EIgetnextobj( E_AT_BEGINNING, 0 );
while( 1 ) {
	ip = EIgetnextobj( E_NEXT, 0 );
	if( ip < 0 ) break;
	Egen( ip );
	}
EIgetnextobj( E_DONE, 0 );

Etrlget( &x, &y );

if( Echecknest() != 0 ) { fprintf( stderr, "Unbalanced group_begin/group_end.\n" ); return( 0 ); }
else return( 1 );
}
/* ============================================== */
Eprintall( name, fnm, mode )
char *name; /* arbitrary name */
char fnm[]; /* file for postscript output, or dash (-) for standard output. */
char mode; /* 'P' for portrait, 'L' for landscape */
{
char dev;

dev = Edev;
Edev = 'p'; /* switch to postscript */
EPSsetup( name, fnm );
if( mode == 'L' ) Epaper( 1 );
else Epaper( 0 );
Egenall();
Eendoffile();
if( strcmp( fnm, "-" )!=0 ) EPSclose();
Edev = dev;
}

