/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/



/* Initialize ZOOD and ELIB. */
#include "elib.x"

static char *home;

Einitall( name, dev, ux, uy, upleftx, uplefty )
char name[];
char dev;     /* 'x' for x11; 'p' for postscript */
double ux, uy;  /* size of window in inches.. */
int upleftx, uplefty; /* point (in native window system coords ) of upper-left corner of window */
{
char *getenv(), *cd, *cf;
char str[100];
FILE *fp;

  home = getenv( "COPA_HOME" );
  if( home == NULL ) {
       fprintf( stderr, "Error: cannot find COPA_HOME environment variable.\n" );
       fprintf( stderr, "Set COPA_HOME to contain the path name of the directory\n" );
       fprintf( stderr, "where copa files such as gui.def and presets.pan are located.\n" );
       exit(1);
       }

  Einit( name, dev, ux, uy, upleftx, uplefty ); /* initialize elib */

  /* read in defaults list.. */
  fp = NULL;
  EIinit();

  /* see if there's a private defaults file defined.. */
  cd = getenv( "COPA_DEF" );
  if( cd != NULL && strlen( cd ) > 0 ) {
	/* locate file.. */
	/* first check cd alone.. */
	strcpy( str, cd );
	fp = fopen( str, "r" );
	if( fp == NULL ) {
		/* now check COPA_FILES directory.. */
		cf = getenv( "COPA_FILES" );
		if( cf != NULL && strlen( cf ) > 0 ) { 
			sprintf( str, "%s/%s", cf, cd ); 
			fp = fopen( str, "r" ); 
			}
		if( fp == NULL ) {
			/* now check COPA_HOME directory.. */
			sprintf( str, "%s/%s", home, cd );
			fp = fopen( str, "r" );
			if( fp == NULL ) 
		   	  fprintf( stderr, 
			    "Can't find private defaults file. Using gui.def.\n", cd );
			}
		}
	}

  if( fp != NULL ) fclose( fp );
  else sprintf( str, "%s/gui.def", home );

  if( EIreaddeflist( str ) != 1 ) {
          fprintf( stderr, "Display server fatal error: error in %s.\n", str );
          exit(1);
          }
#ifdef PLOT
  sprintf( str, "%s/plot.def", home );
  if( EIreaddeflist( str ) != 1 ) {
          fprintf( stderr, "Display server fatal error: error in %s.\n", str );
          exit(1);
          }
  EPinit();
#endif

  EIsaveinitstate();
  
  cd = getenv( "COPA_FLASH" );
  if( cd != NULL ) {
	if( strlen( cd ) > 1 ) {
		sscanf( cd, "%ld", &Eflashdelay );
		Eflashdelay *= 10000; /* convert from n/100 sec to microsecs */
		}
	}

  /* read presets .. */
  Eload_presets();

return( 0 );
}


/* ================ */
Eload_presets()
{
char str[100];
char *fnm, *getenv();

fnm = getenv( "COPA_PRESETS" );
if( fnm == NULL ) sprintf( str, "%s/presets.pan", home );
else if( strlen( fnm ) < 1 )sprintf( str, "%s/presets.pan", home );
else strcpy( str, fnm );

if( EIreaduserlist( str ) != 1 ) {
      fprintf( stderr, "Error or missing presets file (%s).\n", str );
      exit(1);
      }
}
