/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/



/* ======================= */
/* present a pop-up with buttons and wait for user to press a button. */
/* modified Sept 95 scg: if menu is long enough, go to a second row 
		of buttons - p.s. this made the routine uglier!! */
#include "elib.x"
#define NONE ".!none"

/* copa_btnpop( char *s, char *menu, char *val ) */
copa_btnpop( s, menu, val )
char *s, *menu, *val;
{
int p, bp, bp2, j;
int secondrow;
char menu1[80], *menu2;
double x, y;
int selp, key;

p = EItaglookup( "_POP", E_NIL );
bp = EItaglookup( "_POPB1", E_NIL );
bp2 = EItaglookup( "_POPB2", E_NIL );
if( p < 0  || bp < 0  || bp2 < 0 ) return( 2100 );

/* Eexec( p, 0.0, 0.0, E_MESSAGE, "REINIT" ); */
EIraise( p );
EImodattr( p, "", "*/display", "x" );

copa_text( "_POP", s ); /* expand commands, put into zood */
/* replaces... EImodattr( p, "", "text", s ); */

Eexec( p, 0.0, 0.0, E_MESSAGE, "REINIT" );
Ealign( p );
Egen( p );

secondrow = 0;
if( strlen( menu ) > 0 ) {
	if( strlen( menu ) > 22 ) { /* break into two sets of buttons.. */
		for( j = 22; j < strlen( menu ); j++ ) if( menu[j] == ',' ) break;
		if( j < strlen( menu ) ) {
			strncpy( menu1, menu, j ); menu1[j] = '\0';
			menu2 = &menu[j+1];
			secondrow = 1;
			}
		}
	EIraise( bp );
	EImodattr( bp, "", "*/display", "x" );
	if( secondrow ) EImodattr( bp, "", "text", menu1 );
	else EImodattr( bp, "", "text", menu );
	Ealign( bp );
	Egen( bp );
	if( secondrow ) {
		EIraise( bp2 );
		EImodattr( bp2, "", "*/display", "x" );
		EImodattr( bp2, "", "text", menu2 );
		Ealign( bp2 );
		Egen( bp2 );
		}
	}

/* now get input.. */
strcpy( Eselection, NONE );
LOOP:
while( 1 ) {
	Egetkey( &x, &y, &key );

	if( key > 1000 ) {  
		selp = Ewhichobj( x, y );
		if( selp == bp ) break;
		if( secondrow && selp == bp2 ) break;
		if( selp == p ) Eexec( p, x, y, key, "" ); /* scroll text box.. */
		}
	}
Eexec( selp, x, y, key, "" );
if( strcmp( Eselection, ".!none" ) == 0 ) goto LOOP; /* shouldn't happen */

strcpy( val, Eselection );
 
/* now vanish.. */
EImodattr( p, "", "*/display", "" ); 
EImodattr( bp, "", "*/display", "" );
Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" );
Eexec( bp, 0.0, 0.0, E_MESSAGE, "RESET" );
if( secondrow ) {
	EImodattr( bp2, "", "*/display", "" );
	Eexec( bp2, 0.0, 0.0, E_MESSAGE, "RESET" );
	}
return( 0 );
}


/* ============================ */
/* Data entry popup */
/* copa_depop( char *s, char *def, char *len, char *val ) */
copa_depop( s, def, len, val )
char *s, *def, *len, *val;
{
int p, dp;

p = EItaglookup( "_POP", E_NIL );
dp = EItaglookup( "_POPD1", E_NIL );
if( p < 0  || dp < 0 ) return( 2100 );
EIraise( p );
EImodattr( p, "", "*/display", "x" );
copa_text( "_POP", s ); /* expand commands, put into zood */
Eexec( p, 0.0, 0.0, E_MESSAGE, "REINIT" );
Ealign( p );
Egen( p );


EIraise( dp );
EImodattr( dp, "", "*/display", "x" );
EImodattr( dp, "", "pick/value", def );
EImodattr( dp, "", "maxlength", len );
Ealign( dp );
Egen( dp );
strcpy( Eselection, NONE );

Eexec( dp, 0.0, 0.0, E_MOUSE_LEFT, "" );

strcpy( val, Eselection );
if( strlen( val ) < 1 ) strcpy( val, NONE );

EImodattr( p, "", "*/display", "" ); 
EImodattr( dp, "", "*/display", "" );
Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" );
Eexec( dp, 0.0, 0.0, E_MESSAGE, "RESET" );
return( 0 );
}
/* ============================ */
/* Listbox popup */
/* copa_lbpop( char *s, char *menu, char *buttons, char *val ) */
copa_lbpop( s, menu, buttons, val )
char *s, *menu, *buttons, *val;
{
int p, dp, bp;
double x, y;
int key, selp;

p = EItaglookup( "_POP", E_NIL );
dp = EItaglookup( "_POPL1", E_NIL );
bp = EItaglookup( "_POPB1", E_NIL );
if( p < 0  || dp < 0 || bp < 0 ) return( 2100 );

/* message box */
EIraise( p );
EImodattr( p, "", "*/display", "x" );
EImodattr( p, "", "box.marg_b", "3.2" );
copa_text( "_POP", s ); /* expand commands, put into zood */
Eexec( p, 0.0, 0.0, E_MESSAGE, "REINIT" );
Ealign( p );
Egen( p );

/* listbox */
EIraise( dp );
EImodattr( dp, "", "*/display", "x" );
copa_text( "_POPL1", menu ); /* expand commands, put into zood */
Ealign( dp );
Egen( dp );

/* buttons */
EIraise( bp );
EImodattr( bp, "", "*/display", "x" );
EImodattr( bp, "", "text", buttons );
Ealign( bp );
Egen( bp );



strcpy( Eselection, NONE );
LOOP:
while( 1 ) {
	Egetkey( &x, &y, &key );

	if( key > 1000 ) {  
		selp = Ewhichobj( x, y );
		if( selp == dp || selp == bp ) break;
		if( selp == p ) Eexec( p, x, y, key, "" ); /* scroll text box.. */
		}
	}
Eexec( selp, x, y, key, "" );
if( strcmp( Eselection, ".!none" ) == 0 ) goto LOOP; /* shouldn't happen */

strcpy( val, Eselection );

EImodattr( p, "", "*/display", "" ); 
EImodattr( p, "", "box.marg_b", "0.7" );
EImodattr( dp, "", "*/display", "" );
EImodattr( bp, "", "*/display", "" );
Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" );
Eexec( dp, 0.0, 0.0, E_MESSAGE, "RESET" );
Eexec( bp, 0.0, 0.0, E_MESSAGE, "RESET" );
return( 0 );
}
/* ============================ */
/* Message-only popup */
/* copa_mopop( char *msg, char *buttons ) */
copa_mopop( msg, buttons )
char *msg, *buttons;
{
int p, bp;
p = EItaglookup( "_POP", E_NIL );
if( p < 0 ) return( 2100 );
EIraise( p );
EImodattr( p, "", "*/display", "x" );
copa_text( "_POP", msg ); /* expand commands, put into zood */
Eexec( p, 0.0, 0.0, E_MESSAGE, "REINIT" );
Ealign( p );
Egen( p );

bp = EItaglookup( "_POPB1", E_NIL );
if( bp < 0 ) return( 2100 );
EIraise( bp );
EImodattr( bp, "", "*/display", "x" );
EImodattr( bp, "", "text", buttons );
Ealign( bp );
Egen( bp );

Eflush();
return( 0 );
}

/* ============================ */
/* Clear message-only popup */
copa_clpop( )
{
int p, bp;
p = EItaglookup( "_POP", E_NIL );
bp = EItaglookup( "_POPB1", E_NIL );
EImodattr( p, "", "*/display", "" ); 
EImodattr( bp, "", "*/display", "" ); 
Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" );
Eexec( bp, 0.0, 0.0, E_MESSAGE, "RESET" );
/* Eflush(); */
return( 0 );
}
