/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* called by Egen after a textb has been drawn.  It determines whether to slap on
   a scroll controller. */

#include "elib.x"
#define W1 0.12
#define WW1 0.1
#define H1 0.05
#define HALFHEIGHT 0.9
#define GREY 0.9
#define SPACING 0.25    /* the spacing between triangles */
#define SP3 0.75
#define SP7 1.75
#define HALFSPACE 0.125
#define MINSIZEFORFULL 1.6

static int enable_right;


EAvscroller( p )
int p;
{
double x, y, y1, y2;
int len;
double *bb;
int *nlines;
int *firstline;
int *totallines;
int *startcol;
char sym[20];
double shade;
char *scrollcon;

bb = EIgetd( p, "", "*/bb", &len );
if( len != 4 ) return( 0 ); /* no bb */
EIgetc( p, "", "*/display", &len );
if( len < 1 ) return( 0 ); /* not visible */

firstline = EIgeti( p, "", "firstline", &len );
nlines = EIgeti( p, "", "nlines", &len );
totallines = EIgeti( p, "", "totallines", &len );

startcol = EIgeti( p, "", "startcol", &len );
scrollcon = EIgetc( p, "", "scrollcon", &len );

if( *nlines < 1 ) return( 1 ); /* not scrollable */
if( *nlines >= *totallines ) return( 1 ); /* not enough lines to require scrolling.. */

x = *(bb+2) - 0.2;
y1 = *(bb+1);
y2 = *(bb+3);
y = y1 + ((y2-y1)/2.0);   /* set y to midpoint */


/* if box is small, make a mini-control and return.. */
if( y2 - y1 < MINSIZEFORFULL || scrollcon[0] == 'M' ) {
	EAvminiscroller( x, y, *firstline, *nlines, *totallines );
	return( 0 );
	}

y -= SP3;

/* backing */
Eblock( x-W1, y, x+W1, y+(SP7), GREY, 0 );
Eblockdress( (x-W1)-0.1, y, x+W1+0.1, y+(SP7), 0.7, 0.95, 0.1, -1.0, -1.0 );
/* Eellipse( x, y+SP3, W1+0.15, SP3, GREY, 1 ); */

/* see if down controls should be active */
if( *firstline + *nlines > *totallines ) shade = GREY;
else shade = 1.0;
sprintf( sym, "sym2a%2.1f", shade );

/* to-bottom */
y += HALFSPACE;
Eblock( x-WW1, y-H1, x+WW1, y+H1, shade, 0 );
Elinetype( 0, 1.2, 1.0 );  
Emov( x-WW1, y+H1 ); Elin( x-WW1, y-H1 ); Elin( x+WW1, y-H1 ); Elin( x+WW1, y+H1 ); 
Enormline();

/* page down */
y += SPACING;
Emark( x, y, sym, 0.18 );

/* scroll down */
y += SPACING;
Emark( x, y, sym, 0.13 );

/* horizontal left/right */
y += SPACING;

/* left */
if( *startcol > 0 )strcpy( sym, "sym8a1.0" );
else strcpy( sym, "sym8a0.9 " );
Emark( x-WW1, y, sym, 0.13 ); 

/* right */
if( enable_right ) strcpy( sym, "sym7a1.0" );
else strcpy( sym, "sym7a0.9 " );
Emark( x+WW1, y, sym, 0.13 ); 

/* now see if up controls should be active.. */
if( *firstline <= 1 ) shade = GREY;
else shade = 1.0;
sprintf( sym, "sym1a%2.1f", shade );


/* scroll up */
y += SPACING;
Emark( x, y, sym, 0.13 );

/* page up */
y += SPACING;
Emark( x, y, sym, 0.18 );

/* to-top */
y += SPACING;
Eblock( x-WW1, y-H1, x+WW1, y+H1, shade, 0 );
Elinetype( 0, 1.2, 1.0 );
Emov( x-WW1, y-H1 ); Elin( x-WW1, y+H1 ); Elin( x+WW1, y+H1 ); Elin( x+WW1, y-H1 ); 
Enormline();

}
/* ==================================================== */
static int
/* EAvminiscroller( double x, double y, int firstline, int nlinesinbox, int totallines ) */
EAvminiscroller( x, y, firstline, nlinesinbox, totallines )
double x;
double y;
int firstline;
int nlinesinbox; 
int totallines;
{
double shade;
char sym[20];


y -= SPACING;

/* backing */
Eblock( x-W1, y, x+W1, y+SP3, GREY, 0 );
Eblockdress( (x-W1)-0.1, y, x+W1+0.1, y+SP3, 0.7, 0.95, 0.1, -1.0, -1.0 );
 
/* see if DOWN should be active */
if( firstline + nlinesinbox > totallines ) shade = GREY;
else shade = 1.0;
sprintf( sym, "sym2a%2.1f", shade );
 
/* page down */
y += SPACING;
Emark( x, y, sym, 0.2 );
 
/* see if UP should be active */
if( firstline <= 1 ) shade = GREY;
else shade = 1.0;
sprintf( sym, "sym1a%2.1f", shade );
 
/* page up */
y += SPACING;
Emark( x, y, sym, 0.2 );

return( 0 );
}



/* ==================================================== */
/* see if user pressed a scroll button.. */
EEcheckvscroller( message, p, x, y )
char message[]; 
int p;
double x, y; /* mouse position */
{
double *bb, x2, y1, y2, ylow, ycen, yhi, diff, *trl;
int len;
double b;
int mini;
char *scrollcon;


bb = EIgetd( p, "", "*/bb", &len ); 
x2 = *(bb+2); 
y1 = *(bb+1); 
y2 = *(bb+3); 
trl = EIgetd( p, "", "*/trl", &len );
x += (*(trl));  y += (*(trl+1)); /* remove translation */

scrollcon = EIgetc( p, "", "scrollcon", &len );

/* see if we're checking a mini control */
if( y2 - y1 < MINSIZEFORFULL || scrollcon[0] == 'M' ) {
	mini = 1;
	}
else mini = 0;

ycen = y1 + ((y2-y1)/2.0);
ylow = ycen - SP3;
yhi = ylow + SP7;

if( mini ) {
	ylow = ycen - SPACING;
	yhi = ycen + (SPACING*2);
	}

if( x > (x2-0.4) && x < x2 &&  y > ylow && y < yhi ) {
	diff = y - ylow;
	if( mini ) {
		b = .13; 
		if( diff < (b+SPACING) ) strcpy( message, "PAGE DOWN" );
		else strcpy( message, "PAGE UP" );
		return(0);
		}
		
	if( diff < SPACING ) strcpy( message, "BOTTOM" );
	else if( diff < (SPACING*2) ) strcpy( message, "PAGE DOWN" );
	else if( diff < (SPACING*3) ) strcpy( message, "BUMP DOWN" );
	else if( diff < (SPACING*4) && x < (x2-0.2) ) strcpy( message, "PAGE LEFT" );
	else if( diff < (SPACING*4) && x > (x2-0.2) ) strcpy( message, "PAGE RIGHT" );
	else if( diff < (SPACING*5) ) strcpy( message, "BUMP UP" );
	else if( diff < (SPACING*6) ) strcpy( message, "PAGE UP" );
	else strcpy( message, "TOP" );

	return( 1 );
	}
else return( 0 );
}

/* ================== */
EArightscrollable( mode )
int mode;
{
enable_right = mode;
return( 0 );
}
