/* handle setting of a mechanism's selection */
#include "elib.x"

copa_setsel( tag, value )
char *tag;
char *value;
{
int ip;
char *typ;
int i, ix, select;
char buf[E_SELECTION_LEN];
int *curselect, nlines, *size, totallines, firstline;
int status, len;
char *txt;

ip = Egetid( tag );
if( ip < 0 ) return( Eerrmsg( 2301, "Invalid tag.", tag ) );
typ = EIgetobjname( ip );

status = EImodattr( ip, "", "pick/value", value );
if( status < 1 ) return( Eerrmsg( 2302, "zood update failed", tag ));

/* these two types are easy.. */
if( strcmp( typ, "dataentry" )==0 || strcmp( typ, "slider" )==0 ) return( 0 );


else if( strcmp( typ, "button" )==0 ) {
	if( strlen( value ) < 1 ) {
		EImodattr( ip, "", "pick/hselect", "-1" );
		return( 0 );
		}
	/* we need to search the comma-delimited text list for the value */
	txt = EIgetc( ip, "", "text", &len );
	if( len < 1 ) return( Eerrmsg( 2303, "no button text found", tag ) );

	for ( i = 0, ix = 0, select = -1; ; i++ ) {
 		Egetchunk( buf, txt, &ix, "," );
        	if( strlen( buf ) < 1 ) break;
		if( strcmp( buf, value )==0 ) {
			select = i;
			break;
			}
		}
	if( select < 0 ) return( Eerrmsg( 2304, "no matching button found", value ) );
	else	{
		sprintf( buf, "%d", select );
		EImodattr( ip, "", "pick/hselect", buf );
		return( 0 );
		}
	}


else if( strcmp( typ, "textb" )==0 ) {
	if( strlen( value ) < 1 ) {
		EImodattr( ip, "", "pick/vselect", "0" );
		return( 0 );
		}
	/* we need to search the newline delimited text for the value.. */
	/* allow wild cards */
	/* begin at pick/vselect */
	/* vselect begins with 1 not 0.. */

	txt = EIgetc( ip, "", "text", &len );
	if( len < 1 ) return( Eerrmsg( 2305, "no textb text found", tag ) );

	/* get currently selected line, if any.. */
	curselect = EIgeti( ip, "", "pick/vselect", &len );
	if( len < 1 ) *curselect = 0;

	ix = 0; nlines = 0; select = -1;
	while( 1 ) {
                if( ix >= strlen( txt )) break;
                Egetln( buf, txt, &ix );
		if( nlines >= *curselect ) {
			status = Ewildcmp( buf, value, strlen( value ), 0 );
			if( status == 0 ) {
				select = nlines + 1;
				break;
				}
			}

                nlines++;
                }
	if( select < 1 && *curselect > 0 ) { /* still not found, retry from beginning..*/
		totallines = nlines;
		ix = 0; nlines = 0;
		while( 1 ) {
               		if( ix >= strlen( txt )) break;
                	Egetln( buf, txt, &ix );
			if( nlines > *curselect ) break; /* up to current line.. */
			status = Ewildcmp( buf, value, strlen( value ), 0 );
			if( status == 0 ) {
				select = nlines + 1;
				break;
				}
			nlines++;
			}
		}

	if( select > 0 ) {  /* a line was found, update vselect and firstline */
		size = EIgeti( ip, "", "nlines", &len );
		if( len < 1 ) *size = totallines;

		sprintf( buf, "%d", select );
		EImodattr( ip, "", "pick/vselect", buf );
		firstline = 1;
		if( select > *size ) firstline = select - ((*size) / 2);
		/* if( select > totallines - *size ) firstline = totallines - (*size); */

		/* update vselect.. */
		sprintf( buf, "%d", select );
		EImodattr( ip, "", "pick/vselect", buf );

		/* update firstline.. */
		sprintf( buf, "%d", firstline );
		EImodattr( ip, "", "firstline", buf );

		return( 0 );
		}

	else	{ /* nothing matching was found.. */
		return( 3000 );
		}
	}
}
