/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* produces a horizontal slider */
#include "elib.x"

static int fastflag = 0;

EAslider( p, path )
int p;
char path[];
{
double *posx, *posy, x, y, *w, *h, x2, y2, *min, *max, promptlen, val, mark, *scalefact, *l;
double right, left, scfx;
char *pr, *fmt;
char str[20], newpath[100];
int len;

posx = EIgetd( p, path, "position", &len );
if( len != 2 ) { fprintf( stderr, "Position must be specified for slider.\n" ); return( 0 ); }
posy = posx + 1;
	
x = *posx; y = *posy;
	
pr = EIgetc( p, path, "prompt", &len );

if( len > 0 ) {
	sprintf( newpath, "%s/prompt", path );
	EAtext_props( p, newpath );
	}

promptlen = (strlen( pr )+1) * Ecurtextwidth;

w = EIgetd( p, path, "width", &len );
h = EIgetd( p, path, "height", &len );

/* backing box.. */
x2 = x + *w + promptlen; 
y2 = y + *h;
if( !fastflag ) {
	Eblock( x, y, x2, y2, 1.0, 0 );
	Esetlastbox( x, y, x2, y2 );
	
	/* rectangle dressing */
	EIgetc( p, path, "dress", &len );
	if( len > 0 ) {
		sprintf( newpath, "%s/dress", path );
		EArect_dress( p, newpath );
		}
	
	sprintf( newpath, "%s/text", path );
	EAtext_props( p, newpath );
	
	/* write the prompt.. */
	Emov( x+0.1, y+0.1 ); Etext( pr );
	}

min = EIgetd( p, path, "min", &len );
max = EIgetd( p, path, "max", &len );
fmt = EIgetc( p, path, "format", &len );

l = EIgetd( p, path, "left", &len );
if( len < 1 ) {
	left = x + promptlen + 0.1;
	sprintf( str, "%g", left );
	EImodattr( p, path, "left", str );
	}
else left = *l;

right = x2 - 0.1;

Etextsize( 7 );
Esetdrawcolor( E_WHITE );
Eblock( left, y+0.05, right, y2-0.05, 0.0, 0 ); /* draw background.. */
Emov( left, y+0.1 ); sprintf( str, "%g", *min ); Etext( str );
Emov( right, y+0.1 ); sprintf( str, "%g", *max ); Erightjust( str );

/* make scale */
scalefact = EIgetd( p, path, "scalefact", &len );
if( len < 1 ) {
	scfx = ( *max - *min ) / ( (right-0.1) - (left+0.1) );
	sprintf( str, "%g", scfx );
	EImodattr( p, path, "scalefact", str );
	}
else scfx = *scalefact;

val = atof( EIgetc( p, path, "pick/value", &len ) );
if( len < 1 ) val = *min;

/* now let user pick.. */
mark = left + 0.1 + (( val - *min ) / scfx);
Emark( mark, y+0.2, "sym1a1.0", 0.07 );
sprintf( str, fmt, val ); 
Emov( left + ((right-left)/2.0), y+0.1 ); 
Etextsize( 10 ); Ecentext( str ); /* value */
}

/* ============================== */
EEslider( p, x, y, e, message )
int p;
double x, y;
int e;
char message[];
{
double *min, *max, *left, *scalefact, val, *inc, norm, h;
int len;
char str[40], *fmt;

min = EIgetd( p, "", "min", &len );
max = EIgetd( p, "", "max", &len );
fmt = EIgetc( p, "", "format", &len );
left = EIgetd( p, "", "left", &len );
scalefact = EIgetd( p, "", "scalefact", &len );
inc = EIgetd( p, "", "increment", &len );

if( strcmp( message, "RESET" ) ==0 ) val = *min;
else val = (*min) + ( x - ( (*left) + 0.1 ) ) * (*scalefact);

if( val < (*min) ) val = *min;
else if( val > (*max) ) val = *max;

if( *inc != 0.0 ) {   /* set to increment */
	norm = 1.0 / *inc;
	h = (val+(*inc/2.0)) * norm;
	val = (int)h * (*inc);
	}
sprintf( str, fmt, val );
strcpy( Eselection, str );
EImodattr( p, "", "pick/value", str );

fastflag = 1;
Egen( p );
fastflag = 0;
}
