/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* SRV - copa server, called copa_window.  Creates application window, then
   reads commands from FIFO file; calls appropriate api function which then makes 
   various elib calls.
 */
#include <stdio.h>
#include <fcntl.h>
#include "elib.x"
#include "bigbuf.h"

#define TMP_DIR "/usr/tmp"

extern int errno;
char Resultpipe[80];
char Eotchar[2];

char *Errflag = ".!error";
char *Okflag = ".!ok";
int Errcode = 0; /* the most recent error code.. */


main( argc, argv )
int argc;
char **argv;
{
char buf[ SELECTIONMAX + 1 ];
char smallbuf[80];
char *copa_pipe, *getenv();
char compipe[80];
int cfd, rfd, nbytes;
int stat;
int i, j, pos;
char *argp[10];
int nargs;
int len;
double atof();


sprintf( Eotchar, "%c", 18 );

/* build names for fifo files.. */
/* if COPA_PIPE defined, use username+copa_pipe; otherwise, just use username */
copa_pipe = getenv( "COPA_PIPE" );
if( copa_pipe == NULL ) sprintf( buf, "%d", geteuid() );
else if( strlen( copa_pipe ) < 1 )sprintf( buf, "%d", geteuid() );
else sprintf( buf, "%d%s", geteuid(), copa_pipe );
if( strlen( buf ) > 20 ) buf[20] = '\0'; /* truncate at length of 20 */
sprintf( compipe, "%s/copaC%s", TMP_DIR, buf );
sprintf( Resultpipe, "%s/copaR%s", TMP_DIR, buf );


/* unlink old fifos, in case they happen to be around.. */
unlink( compipe );
unlink( Resultpipe );

/* make new fifos..  permissions: read/write by user only */
stat = mkfifo( compipe, 00600 ); 
stat += mkfifo( Resultpipe, 00600 ); 

if( stat != 0 ) {
	Eerrmsg( 80, "Cannot make fifos", "" );
	exit(1);
	}
/* fprintf( stderr, "Fifos %s and %s created.\n", compipe, Resultpipe ); */

/* now open the pipes.. */
/* cfd = open( compipe, O_RDONLY | O_NONBLOCK ); */
cfd = open( compipe, O_RDONLY | O_NDELAY );
if( cfd == NULL ) {
	Eerrmsg( 81, "Cannot open pipe.", compipe );
	exit(1);
	}

Eservermode = 1;

/* now create the application window.. */
if( argc == 7 ) stat = copa_window( atoi( argv[1] ), atoi( argv[2] ), 
		  atof( argv[3] ), atof( argv[4] ), argv[5], atof( argv[6] ) );

else stat = copa_window( 10, 10, 7.0, 8.0, "untitled", 0.9 ); /* defaults */
	
if( stat != 0 ) exit(stat);
Eflush();


/* loop on a blocking read on the command pipe */
pos = 0;
while( 1 ) {
	nbytes = read( cfd, &Ebigbuf[ pos ], BIGBUFSIZE-(pos+1) );
	if( nbytes <=  0 ) {
		stat = Eusleep(  20000 ); /* sleep for 1/50 second.. */
		if( stat != 0 ) {
			sprintf( buf, "%d", stat );
			Eerrmsg( 82, "Srv sleep error", buf );
			exit(82);
			}
		continue;
		}
	if( Ebigbuf[ pos+(nbytes-1) ] != 18 ) { /* more to read.. */
		pos += nbytes;
		continue; 
		}
	Ebigbuf[ pos+(nbytes-1) ] = '\0';
	pos = 0;

	/* split up line into individual arguments.. */
	argp[0] = Ebigbuf;
	len = strlen( Ebigbuf );
	for( i =0, j = 1; i < len; i++ ) {
		if( Ebigbuf[i] == 17 ) {
			Ebigbuf[i] = '\0';
			argp[ j ] = &Ebigbuf[ i+1 ];
			j++;
			}
		else if( Ebigbuf[i] == 18 ) {
			Ebigbuf[i] = '\0';
			}
		}
	nargs = j;

	/* for( i = 0 ; i < nargs; i++ ) fprintf( stderr, "%s##", argp[i] ); */
	/* fprintf( stderr, "\n" ); fflush( stderr ); */

	if( nargs < 2 ) {
		fprintf( stderr, "Usage: copa command [args].\n" );
		sendback( Errflag );
		Errcode = 1;
		continue;
		}

	/* call requested function */
	if( strcmp( argp[1], "quit" )==0 ) {
		sendback( Okflag );
		copa_quit();
		close( cfd );
		exit( 0 );
		}


	else if( strcmp( argp[1], "pop" )==0 ) {
		if( nargs != 4 ) {
			Eerrmsg( 803, "arg count: copa pop message choicelist", "" );
			sendback( Errflag );
			Errcode = 803;
			continue;
			}
		stat = copa_pop( argp[2], argp[3], buf );
		sendback( buf );
		}

	else if( strcmp( argp[1], "poplist" )==0 ) {
		if( nargs < 4 || nargs > 5 ) {
			Eerrmsg( 804, "arg count: copa poplist message listtext buttons", "" );
			sendback( Errflag );
			Errcode = 804;
			continue;
			}
		/* allow buttons arg to be optional.. */
		if( nargs == 4 )
			stat = copa_poplist( argp[2], argp[3], "", buf );
		else
			stat = copa_poplist( argp[2], argp[3], argp[4], buf );
		sendback( buf );
		}

	else if( strcmp( argp[1], "popentry" )==0 ) {
		if( nargs < 4 || nargs > 5 ) {
			Eerrmsg( 805, "arg count: copa popentry message default length", "" );
			sendback( Errflag );
			Errcode = 805;
			continue;
			}

		/* allow length arg to be optional */
		if( nargs == 4 )
			stat = copa_popentry( argp[2], argp[3], 20, buf );
		else
			stat = copa_popentry( argp[2], argp[3], atoi( argp[4] ), buf );
		sendback( buf );
		}

	else if( strcmp( argp[1], "popmsg" )==0 ) {
		if( nargs < 3 || nargs > 4 ) {
			Eerrmsg( 806, "arg count: copa popmsg message buttons", "" );
			sendback( Errflag );
			Errcode = 806;
			continue;
			}
		/* allow buttons arg to be optional */
		if( nargs == 3 )
			stat = copa_popmsg( argp[2], "" );
		else 
			stat = copa_popmsg( argp[2], argp[3] );
		sendback( Okflag );
		}

	else if( strcmp( argp[1], "popclear" )==0 ) {
		if( nargs != 2 ) {
			Eerrmsg( 807, "arg count: copa popclear", "" );
			sendback( Errflag );
			Errcode = 807;
			continue;
			}
		stat = copa_popclear();
		sendback( Okflag );
		}

	else if( strcmp( argp[1], "panload" )==0 ) {
		if( nargs != 4 ) {
			Eerrmsg( 808, "arg count: copa panload panfile tag", "" );
			sendback( Errflag );
			Errcode = 808;
			continue;
			}
		Errcode = copa_panload( argp[2], argp[3] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "panuse" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 809, "arg count: copa panuse tag", "" );
			sendback( Errflag );
			Errcode = 809;
			continue;
			}
		Errcode = copa_panuse( argp[2] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "panadd" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 819, "arg count: copa panadd panfile", "" );
			sendback( Errflag );
			Errcode = 819;
			continue;
			}
		Errcode = copa_panadd( argp[2] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "panquit" )==0 ) {
		if( nargs != 2 ) {
			Eerrmsg( 810, "arg count: copa panquit", "" );
			sendback( Errflag );
			Errcode = 810;
			continue;
			}
		Errcode = copa_panquit( );
		if( Errcode != 0 ) {
			fprintf( stderr, "Error %d.", Errcode );
			sendback( Errflag );
			}
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "text" )==0 ) {
		if( nargs != 4 ) {
			Eerrmsg( 811, "arg count: copa text tag text", "" );
			sendback( Errflag );
			Errcode = 811;
			continue;
			}
		Errcode = copa_text( argp[2], argp[3] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}
	else if( strcmp( argp[1], "echo" )==0 ) {
		/* special case- command comes all in one:
		 * copa echo ".!begin TAG" "text" ".!end"
		 */
		if( nargs != 5 ) {
			Eerrmsg( 826, "echo: improper or missing begin/end construct", "" );
			sendback( Errflag );
			Errcode = 826;
			continue;
			}
		buf[0] = '\0';
		sscanf( argp[2], "%s %s", smallbuf, buf );
		if( strcmp( smallbuf, ".!begin" ) != 0 ) {
			Eerrmsg( 829, "Expecting echo .!begin", "" );
			sendback( Errflag );
			Errcode = 829;
			continue;
			}
		if( strlen( buf ) < 1 ) {
			Eerrmsg( 827, "Missing mechanism tag following .!begin", "" );
			sendback( Errflag );
			Errcode = 827;
			continue;
			}
		Errcode = copa_text( buf, argp[3] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], ".!end" )==0 ) {
		Eerrmsg( 828, "echo: improper or missing begin/end construct", "" );
		sendback( Errflag );
		Errcode = 828;
		continue;
		}

	else if( strcmp( argp[1], "get" )==0 ) {
		if( nargs != 2 ) {
			Eerrmsg( 812, "arg count: copa get", "" );
			sendback( Errflag );
			Errcode = 812;
			continue;
			}
		Errcode = copa_get( buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}

	else if( strcmp( argp[1], "mget" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 813, "arg count: copa get response_mode", "" );
			sendback( Errflag );
			Errcode = 813;
			continue;
			}
		Errcode = copa_mget( argp[2], buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}

	else if( strcmp( argp[1], "getentry" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 830, "arg count: copa getentry tag", "" );
			sendback( Errflag );
			Errcode = 830;
			continue;
			}
		Errcode = copa_getentry( argp[2], buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}

	else if( strcmp( argp[1], "rlimit" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 814, "arg count: copa rlimit taglist", "" );
			sendback( Errflag );
			Errcode = 814;
			continue;
			}
		Errcode = copa_rlimit( argp[2] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "rinfo" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 815, "arg count: copa rinfo infotype", "" );
			sendback( Errflag );
			Errcode = 815;
			continue;
			}
		if( strcmp( argp[2], "errorcode" )==0 ) {
			sprintf( buf, "%d", Errcode );
			sendback( buf );
			continue;
			}
		Errcode = copa_rinfo( argp[2], buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}

	else if( strcmp( argp[1], "getvalue" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 821, "arg count: copa getvalue tag|.!all", "" );
			sendback( Errflag );
			Errcode = 821;
			continue;
			}
		Errcode = copa_getvalue( argp[2], buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}
	
	else if( strcmp( argp[1], "setvalue" )==0 ) {
		if( nargs != 4 ) {
			Eerrmsg( 822, "arg count: copa setvalue tag|.!file value|file", "" );
			sendback( Errflag );
			Errcode = 822;
			continue;
			}
		Errcode = copa_setvalue( argp[2], argp[3] );
		if( Errcode != 0 ) sendback( Errflag ); /* this includes #3000 (search failed) */
		else sendback( Okflag );
		}
			
	else if( strcmp( argp[1], "setmec" )==0 ) {
		if( nargs != 5 ) {
			Eerrmsg( 816, "arg count: copa setmec tag attribute value", "" );
			sendback( Errflag );
			Errcode = 816;
			continue;
			}
		Errcode = copa_setmec( argp[2], argp[3], argp[4] );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( Okflag );
		}

	else if( strcmp( argp[1], "getmec" )==0 ) {
		if( nargs != 4 ) {
			Eerrmsg( 817, "arg count: copa getmec tag attribute", "" );
			sendback( Errflag );
			Errcode = 817;
			continue;
			}
		Errcode = copa_getmec( argp[2], argp[3], buf );
		if( Errcode != 0 ) sendback( Errflag );
		else sendback( buf );
		}
	else if( strcmp( argp[1], "version" )==0 ) {
		copa_version();
		sendback( Okflag );
		}
		

	else if( strcmp( argp[1], "display" )==0 ) {
		if( nargs != 3 ) {
			Eerrmsg( 802, "arg count: copa display action", "" );
			sendback( Errflag );
			Errcode = 802;
			continue;
			}
		if( strcmp( argp[2], "ping" )==0 ) {
			sprintf( buf, "%d", getpid() );
			sendback( buf );
			}
		else	{
			stat = copa_display( argp[2] );
			sendback( Okflag );
			}
		}

	else if( strcmp( argp[1], "resize" )==0 ) {
		if( nargs != 7 ) {
			Eerrmsg( 801, "arg count: copa resize winx winy width height color", "" );
			sendback( Errflag );
			Errcode = 801;
			continue;
			}
		stat = copa_resize( atoi( argp[2] ), atoi( argp[3] ), 
			atof( argp[4] ), atof( argp[5] ), atof( argv[6] ) );
		sendback( Okflag );
		}

	else if( strcmp( argp[1], "ps" ) ==0 ) {
		if( nargs != 5 ) {
			Eerrmsg( 818, "arg count: copa ps title outfile paper","" );
			sendback( Errflag );
			Errcode = 818;
			continue;
			}
		stat = copa_ps( argp[2], argp[3], argp[4] );
		sendback( Okflag );
		}


	else	{
		Eerrmsg( 820, "Unrecognized command", argp[1] );
		Errcode = 820;
		sendback( Errflag );
		}
	}
}
/* ============================ */
/* send a string back to the client */
sendback( buf )
char *buf;
{
int rfd;

/* open results pipe */
rfd = open( Resultpipe, O_WRONLY );
if( rfd == NULL ) {
	Eerrmsg( 83, "Cannot open pipe", Resultpipe );
	exit(1);
	}
/* send back any results over the results pipe */
write( rfd, buf, strlen( buf ) );
write( rfd, Eotchar, 1 );
close( rfd );

Eflush(); 
return( 0 );
}

