/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





#include "elib.x"

/* This file includes code for generating text and text boxes */
/* First, the actual subroutines which build the boxes, then the gen routine, 
   then the exec routine. */

static int Etxtparam = 0; /* tells Efiletext that the actual text is being sent instead of a file name */
static int Efastflag = 0; /* if 1, next regeneration does not need to do redraw trimming */

/* ===================================================== */
/* Print the text file fnm with upper left corner at x,y. */
/* Area that the text will occupy is erased first. */
/* fln is the first line (from the file) to print.  The first line is 1. */ 
/* nln is the number of lines to print. To print all lines use a very high number such as 9999.  */ 
/* If outline == 1 the text will be enclosed in a box. */
/* justify is "L" for left, "C" for center, "R" for right justification. */
/* If pickflag == 1 each line in the textbox will become an object. */
/* Width is the desired width in characters, excluding margin.  If 0, width of the longest line
   will be used. */
/* If x,y is negative, the text box will be centered in the middle of the screen */
/* Text attributes are set before this routine is called.. */
/* returns 1 on success, 0 on failure */
/* Note: picking lines won't work with align = 'C' or 'R' */
/* Efastflag: this flag may be set elsewhere in the application to indicate that the text box
     just needs a fast update.. */

Efiletext( fnm, x, y, width, marg, fln, nln, color, outline, justify, 
		spacing, rule, number, longest, totallines, flineselect,
		texttop, textbot, textleft, textright, charwidth, selectleft, selectright, 
		startcol, marg_l, marg_r, marg_b, marg_t )
		

char fnm[]; /* the file, or else the text itself */
double x, y;   /* position of the beginning of text */
int width;     /* width, in number of characters */
double marg;   /* size of margin do be created on all four sides of text (text will still be placed at x,y) */
int fln, nln;  /* first line to show; number of lines to show */
double color;  /* color of the backing box */
int outline;   /* outline the text box? 1=yes 0=no  */
char justify[]; /* alignment */
double *spacing; /* amount of space between lines.  (0.0 = normal, it will be returned) */
int rule;	/* 1 = draw ruling lines; 2 = draw 3d boxes; 0 = no rulings */
int number;	/* 1 = generate line numbers; 0 = don't */
int *longest;	/* length of the longest line (specify 0 if unknown, and it will be calculated) */
int *totallines; /* the total number of lines (specify 0 if unknown, and it will be calculated) */
int flineselect; /* the line number of a selected line (0 if none) */
double *texttop, *textbot;    /* returned- used for vertical pick info */
double *textleft, *textright, *charwidth; /* returned- used for horizontal pick info */
int selectleft, selectright;  /* character positions of highlight on/off (-1 = off) */
int startcol;   /* for horizontal scrolling (starts w/ 0).  If h. scrolling is off use 0 */
double marg_l, marg_r, marg_b, marg_t; /* explicit margin settings (these will override marg) */
{
int i;
FILE *fp;
char buf[E_GPBUF], buf2[E_GPBUF];
double px, py;
double h, w;
int iln;
int nlines;
int maxlength;
double awidth;
char oname[40];
int ix;
double linemarg, liney, oldliney;
char lineno[10];
double left, right;
double txtleft, txtright, txttop, txtbot;
double hilite_color;
int len;

/*
 * fprintf( stderr, "fln=%d nln=%d longest=%d totallns=%d flineselect=%d selectleft=%d selectright=%d\n",
 *  fln, nln, *longest, *totallines, flineselect, selectleft, selectright );
 */


if( *spacing <= 0.0 ) *spacing = Ecurtextheight;
*charwidth = Ecurtextwidth;

/* if unknown, scan file to get bounding box dimensions.. */
if( *totallines < 1 && *longest < 1 ) {
	if( Etxtparam == 0 ) {
		fp = fopen( fnm, "r" );
		if( fp == NULL ) { fprintf( stderr, "Efiletext: cannot open %s.\n", fnm ); return( 0 ); }
		}
	else ix = 0;
	
	/* count lines in file, since this may not be specified.. */
	/* also, find longest line */
	nlines = 0; maxlength = 0;
	while( 1 ) {
		if( Etxtparam == 0 ) {
			if( fgets( buf, E_GPBUF, fp ) == NULL ) break;
			}
		else if( Etxtparam == 1 ) {
			if( ix >= strlen( fnm )) break;
			Egetln( buf, fnm, &ix );
			}
		Eexpand_tabs( buf2, buf );
	
		if( strlen( buf2 ) > maxlength ) maxlength = strlen( buf2 );
		nlines++;
		}
	if( Etxtparam == 0 )fclose( fp );
	/* save return values */
	*totallines = nlines;
	*longest = maxlength;
	}

else 	{
	nlines = *totallines;
	maxlength = *longest;
	}

/* find omitted values.. */
if( nln == 0 ) nln = nlines;  /* we will auto-size.. */
if( fln > nlines ) fln = (nlines - nln); /* bottom of doc */
if( fln < 1 ) fln = 1;	/* top of doc */

if( width < 1 ) {
	width = maxlength;
	if( startcol > 0 ) {
		fprintf( stderr, "textb: width must be supplied if startcol is non-zero.\n" );
		startcol = 0;
		}
	}

/* find width of box.. */
if( Edev == 'p' ) awidth = width * Ecurtextheight * 0.4; /* fudge for postscript..*/
else awidth = width * (*charwidth);

/* auto center if x,y are negative */
if( x < 0.0 ) {
	x = (EWinx/2.0) - (awidth/2.0);
	y = (EWiny/2.0) + ((nln/2.0) * (*spacing));
	}

txttop = y + (*spacing);
txtleft = x;
txtright = x + awidth;
txtbot = y - ( (*spacing) * (nln - 1) );

/* add margins */
if( marg_l > 0.0 ) txtleft -= marg_l;
else txtleft-=marg;

if( marg_r > 0.0 ) txtright += marg_r;
txtright+=marg;

if( marg_b > 0.0 ) txtbot -= marg_b;
else txtbot-=marg;

if( marg_t > 0.0 ) txttop += marg_t;
else txttop+=marg;

/* draw the backing box.. */
if( !Efastflag )Eblock( txtleft, txtbot, txtright, txttop, color, outline );
Esetlastbox( txtleft, txtbot, txtright, txttop ); /* remember the coords of the box */

if( Etxtparam == 0 ) fp = fopen( fnm, "r" );

px = x; py = y;
*textleft = px; *textright = px + awidth; /* remember sides of text */

iln = 1;
ix = 0;
/* skip to first line.. */
if( Etxtparam == 0 && fln > 1 ) {
	while( fgets( buf, 255, fp ) != NULL ) {
		iln++;
		if( iln >= fln ) break;
		}
	}
else if( Etxtparam == 1 && fln > 1 ) {
	while( 1 ) {
		if( iln >= fln || ix >= strlen( fnm ) ) break;
		Egetln( buf, fnm, &ix );
		iln++;
		}
	}
linemarg = (*spacing) / 4.0;

/* draw top rule */
liney = py+((*spacing)-linemarg); 
if( rule == 1 ) { Emov( txtleft, liney ); Elin( txtright, liney ); }
oldliney = liney;

*texttop = py+((*spacing)-linemarg); /* remember top of text.. */

iln = 0;
EArightscrollable( 0 ); 

/* print the text.. */
while( 1 ) {
	if( Etxtparam == 0 ) {
		if( fgets( buf, 255, fp ) == NULL ) break;
		buf[ strlen( buf ) -1 ] = '\0';
		}
	if( Etxtparam == 1 ) {
		if( ix >= strlen( fnm )) break;
		Egetln( buf, fnm, &ix );
		}
	iln++;
	if( iln > nln ) { iln--; break; }
	Eexpand_tabs( buf2, buf );

	/* put horiz. scrolled portion into buf.. */
	if( startcol >= strlen( buf2 ) ) buf[0] = '\0';
	else strcpy( buf, &buf2[ startcol ] );

	if( strlen( buf ) > width ) {
		buf[width] = '\0'; /* truncate long lines */
		EArightscrollable( 1 ); /* tell scroll control to allow scroll to right */
		}

	liney = py-linemarg;
	/* if( Efastflag )Eblock( px, liney, px+awidth, oldliney, color, 0 ); */
	if( Efastflag )Eblock( txtleft, liney, txtright, oldliney, color, 0 ); /* scg 1-5-96*/

	/* ruling */
	if( rule == 0 ); /* do nothing.. */
	else if( rule == 1 ) { Emov( txtleft, oldliney ); Elin( txtright, oldliney ); }
	else if( rule == 2 ) 
		Eblockdress( txtleft, liney, txtright, oldliney, 0.9, 0.7, 0.06, -1.0, 0.0 );


	/* print the text.. */
	if( justify[0] == 'L' ) { Emov( px, py ); Etext( buf ); }
	else if( justify[0] == 'C' ) { Emov( px+(awidth/2), py ); Ecentext( buf ); }
	else if( justify[0] == 'R' ) { Emov( px+awidth, py ); Erightjust( buf ); }

	/* show "selected" line by printing it in reverse video.. */
	if( (iln+fln)-1 == flineselect ) {
		if( selectleft >= 0 && selectright >= 0 ) {
			selectleft -= startcol; /* adj for h. scrolling */
			selectright -= startcol;

			/* cases where highlighted block is straddling edge.. */
			if( selectleft < 0 ) {
				if( selectright > 0 ) selectleft = 0;
				else goto SKIP;
				}
			if( selectright > width ) {
				if( selectleft < width ) selectright = width;
				else goto SKIP;
				}
			left = (*textleft) + ((*charwidth) * selectleft);
			right = (*textleft) + ((*charwidth) * (selectright+1));
			}
		else 	{ 
			/* left = px; changed to below scg Nov 95 */
			left = txtleft;
			/* right = px + awidth; ** scg 1-5-96 */
			right = txtright;
			}

		if( color >= 0.9 ) hilite_color = 0.0;
		else hilite_color = 1.0;


		Eblock( left, liney, right, oldliney, hilite_color, 0 );
		Epenerase();
		if( selectleft >= 0 ) {
			strcpy( buf2, &buf[ selectleft ] );
			buf2[ (selectright-selectleft) +1 ] = '\0';
			Emov( left, py );
			Etext( buf2 );
			}
		else 	{
			if( justify[0] == 'L' ) { Emov( px, py ); Etext( buf ); }
			else if( justify[0] == 'C' ) { Emov( px+(awidth/2), py ); Ecentext( buf ); }
			else if( justify[0] == 'R' ) { Emov( px+awidth, py ); Erightjust( buf ); }
			}
		Epcode( 'R', (double)E_BLACK, (double)E_BLACK, "" );
		Ependraw(); /* turn off highlighting.. */
		SKIP:;

		}
		
	oldliney = liney;

	py -= (*spacing);
	if( py < 0.0 ) break; /* ran off bottom of page */
	}
if( Etxtparam == 0 )fclose( fp );

/* patch to do last line */
if( rule == 1 ) { Emov( txtleft, liney ); Elin( txtright, liney ); }

*textbot = (py-linemarg) + *spacing; /* save lowest pick info.. */

if( number ) {

	/* number the lines */
	Etextsize( 7 ); py = y;
	for( i = fln; i < (fln+iln); i++ ) {
		sprintf( lineno, "%4d.", i );
		Eblock( px-0.5, py, px-0.1, py+(*spacing), color, 0 );
		Emov( px-0.1, py ); Erightjust( lineno );
		py -= (*spacing);
		if( py < 0.0 ) break;
		}
	
	Eblock( px-0.5, py, px+0.2, py+0.1, color, 0 );Emov( px-0.1, py );
	/*
	 * if( (fln+iln) < *totallines ) Ecentext( "More.." );
	 * else Ecentext( "= End =" );
	 */
	}

return( 1 );
}

/* ================================================ */
/* same as Efiletext() except that multiline text is passed in as a string.. */
/* function returns number of lines in the text */
Eblocktext( s, x, y, width, marg, fln, nln, color, outline, justify, 
		spacing, rule, number, longest, totallines, flineselect,
		texttop, textbot, textleft, textright, charwidth, selectleft, selectright,
		startcol, marg_l, marg_r, marg_b, marg_t )
char s[];
double x, y;
int width;    /* width in number of characters */
double marg;
int fln;
int nln;
double color;
int outline;
char justify[];
double *spacing;
int rule;
int number;
int *longest;
int *totallines;
int flineselect;
double *texttop, *textbot, *textleft, *textright, *charwidth;
int selectleft, selectright;
int startcol;   /* for horizontal scrolling (starts w/ 0).  If h. scrolling is off use 0 */
double marg_l, marg_r, marg_b, marg_t; /* explicit margin settings (these will override marg) */
{
FILE *fp;
char str[100];
int stat;

Etxtparam = 1;

stat = Efiletext( s, x, y, width, marg, fln, nln, color, outline, justify, 
		spacing, rule, number, longest, totallines, flineselect,
		texttop, textbot, textleft, textright, charwidth, selectleft, selectright,
		startcol, marg_l, marg_r, marg_b, marg_t );

Etxtparam = 0;
return( stat );
}


/* ================================================ */
/* ================================================ */
/* The GEN routine. =============================== */
/* ================================================== */
EAtextb( p, path )
int p;
char path[];
{
int len;
char newpath[E_ANAMELEN];
char *txt, *align, *box, *dress;
double posx, posy, *d1, *d2, *boxmargin, *color;
int *boxwidth, *firstline, *nlines;
double *spacing;
int ruled;
char val[80];
int *sz, size;
int number;
char *rule;
int *lngst, longest;
int *flineselect;
int fromfile;
char *fnm;
char *title;
int pickable;
double texttop, textbot, textleft, textright;
double lineheight, charwidth;
int *selectleft, *selectright;
int *startcol;   /* for horizontal scrolling (starts w/ 0).  If h. scrolling is off use 0 */
double *marg_l, *marg_r, *marg_b, *marg_t; /* explicit margin settings (these will override marg) */
double *bb;

txt = EIgetc( p, path, "text", &len );

fnm = EIgetc( p, path, "file", &len );
if( len > 0 ) fromfile = 1; else fromfile = 0;

sprintf( newpath, "%s/text", path );
EAtext_props( p, newpath );
	
d1 = EIgetd( p, path, "position", &len ); d2 = d1; d2++;
if( len < 2 ) { posx = -1.0;  posy = -1.0; }
else { posx = *d1; posy = *d2; }

align = EIgetc( p, path, "align", &len );

spacing = EIgetd( p, path, "spacing", &len );
if( len > 0 ) lineheight = *spacing; else lineheight = 0;

rule=EIgetc( p, path, "ruled", &len );
if( len < 1 ) ruled = 0;
else if( *rule == 'L' ) ruled = 1; /* lines */
else if( *rule == 'B' ) ruled = 2; /* box */

EIgetc( p, path, "numbered", &len );
if( len > 0 ) number = 1; else number = 0;

EIgetc( p, path, "pick", &len );
if( len > 0 ) pickable = 1; else pickable = 0;

firstline = EIgeti( p, path, "firstline", &len );
nlines = EIgeti( p, path, "nlines", &len );

sz = EIgeti( p, path, "totallines", &len );
if( len > 0 ) size = *sz; else size = 0;

lngst = EIgeti( p, path, "longest", &len );
if( len > 0 ) longest = *lngst; else longest = 0;

startcol = EIgeti( p, path, "startcol", &len );

flineselect = EIgeti( p, path, "pick/vselect", &len );
selectleft = EIgeti( p, path, "pick/hselect", &len );
selectright = selectleft+1;


box = EIgetc( p, path, "box", &len );
/* text, no box */
if( strlen( box ) < 1 ) 
	if( fromfile ) Efiletext( fnm, posx, posy, 0, 0.0, *firstline, *nlines, -1.0, 0, align, 
		&lineheight, ruled, number, &longest, &size, *flineselect,
		&texttop, &textbot, &textleft, &textright, &charwidth, *selectleft, *selectright, 
		*startcol, -1.0, -1.0, -1.0, -1.0 );

	else Eblocktext( txt, posx, posy, 0, 0.0, *firstline, *nlines, -1.0, 0, align, 
		&lineheight, ruled, number, &longest, &size, *flineselect,
		&texttop, &textbot, &textleft, &textright, &charwidth, *selectleft, *selectright, 
		*startcol, -1.0, -1.0, -1.0, -1.0 );

/* text with box */
else	{
	boxwidth = EIgeti( p, path, "box.width", &len );
	boxmargin = EIgetd( p, path, "box.margin", &len );
	marg_l = EIgetd( p, path, "box.marg_l", &len );
	marg_r = EIgetd( p, path, "box.marg_r", &len );
	marg_b = EIgetd( p, path, "box.marg_b", &len );
	marg_t = EIgetd( p, path, "box.marg_t", &len );
	color = EIgetd( p, path, "box.color", &len );

	if( fromfile )Efiletext( fnm, posx, posy, *boxwidth, *boxmargin, *firstline, *nlines, 
		*color, 0, align, &lineheight, ruled, number, 
		&longest, &size, *flineselect,
		&texttop, &textbot, &textleft, &textright, &charwidth, *selectleft, *selectright,
		*startcol, *marg_l, *marg_r, *marg_b, *marg_t );

	else Eblocktext( txt, posx, posy, *boxwidth, *boxmargin, *firstline, *nlines, 
		*color, 0, align, &lineheight, ruled, number, 
		&longest, &size, *flineselect,
		&texttop, &textbot, &textleft, &textright, &charwidth, *selectleft, *selectright,
		*startcol, *marg_l, *marg_r, *marg_b, *marg_t );

	if( !Efastflag ) {
		dress = EIgetc( p, path, "dress", &len );
		if( strlen( dress ) > 0 ) {
			sprintf( newpath, "%s/dress", path );
			EArect_dress( p, newpath );
			}
		}
	}

/* update values that came back from Eblocktext.. */
if( !Efastflag ) {
	if( size != *sz ) {
		sprintf( val, "%d", size );
		EImodattr( p, path, "totallines", val ); 
		}
	if( longest != *lngst ) {
		sprintf( val, "%d", longest );
		EImodattr( p, path, "longest", val ); 
		}
	
	if( pickable ) {
		sprintf( val, "%g %g %g", textbot, texttop, lineheight );
		EImodattr( p, path, "pick/vzones", val ); /* not always necessary, but.. */
		sprintf( val, "%g %g %g", textleft, textright, charwidth );
		EImodattr( p, path, "pick/hzones", val );
		}
	}
}

/* ==================================================== */
/* ==================================================== */
/* =The EXEC routine. ================================= */
/* Get a text line, or scroll up/down */
/* ==================================================== */
EEtextb( p, x, y, e, msg )
int p;
double x, y;
int e;
char msg[];
{
int i, j, k, l, n, nlines, fromfile;
int len;
double *vlow, *vhi, *vinc, pz, oldpz;
double *hlow, *hhi, *hinc;
char *txt, *fnm;
char val[E_GPBUF], val2[E_GPBUF];
double *scr, u, v, r;
int *fln, *nln, *size, *oldpick;
int m;
int ix, oldix;
int pickable;
char *mode;
int selectleft, selectright;
int *oldline, *oldleft, *oldright;
int *startcol;
int *longest, *width;
int diff;
char *result_format, *delim_list;
char message[20];
char *unpick;
int *curln;
char *flashpick;

/* allow mouse clicks and messages */
if( e < 1000 ) return( 0 );

strcpy( message, msg );

mode = EIgetc( p, "", "pick.mode", &len );
unpick = EIgetc( p, "", "unpick", &len );

if( strcmp( message, "REINIT" )==0 ) {
	Enulloutbb( p );
	EImodattr( p, "", "firstline", "1" );
	EImodattr( p, "", "totallines", "0" );
	EImodattr( p, "", "longest", "0" );
	/* returns then, below. */
	}
if( Esmember( message, "RESET REINIT", " " )) {
	EImodattr( p, "", "pick/value", "" );
	EImodattr( p, "", "pick/vselect", "0" );
	if( *mode == 'W' || *mode == 'C' ) { EImodattr( p, "", "pick/hselect", "-1 -1" ); }
	return( 1 );
	}

fln = EIgeti( p, "", "firstline", &len );




nln = EIgeti( p, "", "nlines", &len );
size = EIgeti( p, "", "totallines", &len ); 
longest = EIgeti( p, "", "longest", &len );
startcol = EIgeti( p, "", "startcol", &len );
width = EIgeti( p, "", "box.width", &len );


/* see if user clicked on scroller.. */
/* if nln == 0 there will be no scrolling */
if( *nln > 0 )EEcheckvscroller( message, p, x, y ); 

if( strlen( message ) > 0 ) {

	if( strcmp( message, "NEXT" )==0 ) {
		curln = EIgeti( p, "", "pick/vselect", &len );
		if( *curln < 1 ) n = 0;
		else n = ( *curln - *fln ) + 1 ;
		n++; 
		if( n > *nln ) {
			Eexec( p, 0.0, 0.0, E_MESSAGE, "BUMP DOWN" ); /* recursion */
			n = *nln;
			}
		goto SECTION2;
		}

	else if( strcmp( message, "PREVIOUS" )==0 ) {
		curln = EIgeti( p, "", "pick/vselect", &len );
		if( *curln < 1 ) n = 2;
		else n = ( *curln - *fln ) + 1 ;
		n--;
		if( n < 1 ) {
			Eexec( p, 0.0, 0.0, E_MESSAGE, "BUMP UP" ); /* recursion */
			n = 1;
			}
		goto SECTION2;
		}
		
	else if( strcmp( message, "PAGE UP" )== 0 ) {
		m = *fln;
		if( m <= 1 ) return( 1 );
		m -= (*nln +1); /* leave an anchor line.. */
		if( m < 1 ) m = 1;
		sprintf( val, "%d", m ); EImodattr( p, "", "firstline", val );
		}
	else if( strcmp( message, "PAGE DOWN" )== 0 ) {
		m = *fln;
		/* if( m >= ((*size)-(*nln)) )return( 1 ); scg 11-7-95 */
		   if( m > ((*size)-(*nln)) )return( 1 ); 
		m += (*nln -1); /* leave an anchor line.. */
		if( m > (*size-*nln) ) m = (*size-*nln) +1;  /* bug fix */
		sprintf( val, "%d", m ); EImodattr( p, "", "firstline", val );
		}
	else if( strcmp( message, "TOP" )== 0 ) {
		if( *fln <= 1 ) return( 1 );
		EImodattr( p, "", "firstline", "1" );
		}
	else if( strcmp( message, "BOTTOM" )== 0 ) {
		/* if( *fln >= (*size)-(*nln)) return( 1 );scg 11-7-95 */
		   if( *fln > (*size)-(*nln)) return( 1 ); 
		sprintf( val, "%d", (*size - *nln)+1 ); /* bug fix */
	 	EImodattr( p, "", "firstline", val );
		}
	
	else if( strcmp( message, "BUMP UP" )==0 ) {
		if( *fln <= 1 ) return( 1 );
		sprintf( val, "%d", (*fln)-1 ); 
		EImodattr( p, "", "firstline", val );
		}
	else if( strcmp( message, "BUMP DOWN" )==0 ) {
		/* if( *fln + *nln >= *size )return( 1 ); scg 11-7-95 */
		   if( *fln + *nln > *size )return( 1 ); 
		sprintf( val, "%d", (*fln)+1 ); 
		EImodattr( p, "", "firstline", val );
		}
	else if( strcmp( message, "PAGE RIGHT" )==0 ) {
		diff = (*width) / 6;
		m = (*startcol);
		if( m >= ((*longest) - (*width) )) return( 1 );
		m += diff;
		if( m > ((*longest) - (*width)) ) m = (*longest) - (*width);
		sprintf( val, "%d", m );
		EImodattr( p, "", "startcol", val );
		}
	else if( strcmp( message, "PAGE LEFT" )==0 ) {
		diff = (*width) / 6;
		m = (*startcol);
		if( m <= 0 ) return( 1 );
		m -= diff;
		if( m < 0 ) m = 0;
		sprintf( val, "%d", m );
		EImodattr( p, "", "startcol", val );
		}
/*
 *	else if( strncmp( message, "SEARCH", 6 )==0 ) {
 *		curln = EIgeti( p, "", "pick/vselect", &len );
 *		txt = EIgetc( p, "", "text", &len );
 *		Esearch( curln, *size, txt, message );
 *		}
 */
	else fprintf( stderr, "textb does not recognize message (%s)\n", message );
	
	Efastflag = 1; Egen( p ); Efastflag = 0;
	return( 1 );
	}

	
EIgetc( p, "", "pick", &len );
if( len > 0 ) pickable = 1; else pickable = 0;

if( !pickable ) return( 0 );


vlow = EIgetd( p, "", "pick/vzones", &len );    /* vlow, vhi, vinc */
if( len != 3 ) return( 0 );
vhi = vlow + 1; vinc = vlow + 2;
if( *vhi < *vlow || (*vhi - *vlow) > 20.0 )
	{ fprintf( stderr, "EEtextb() internal v. pick error.\n" ); return( 0 ); }

/* find the vertical pick.. */
if( y >= *vlow && y <= *vhi ) {
	pz = *vhi;
	for( i = 0; ; i++ ) {
		if( y > pz ) break;
		pz -= (*vinc);
		}
	}
else 	{
	if( *mode == 'O' ) Eselection[0] = '\0';
	return( 0 );
	}

n = i;

SECTION2:
/* n now contains the on-screen number of the zone that was picked (first = 1) */

/* find the line of text that was pointed to (either from text or file).. */
txt = EIgetc( p, "", "text", &len );
fnm = EIgetc( p, "", "file", &len );
if( len > 0 ) fromfile =1; else fromfile = 0;

ix = 0;
nlines = 0;
while( 1 ) {
	nlines++;
	if( !fromfile )Egetln( val2, txt, &ix );
	if( ((nlines-*fln)+1) == n ) break;
	}
if( fromfile ) { 
	Efileline( fnm, nlines, val2 );
	val2[ strlen( val2 ) -1 ] = '\0';
	}
Eexpand_tabs( val, val2 );
/* we now have the line in val */



selectleft = -1; selectright = -1; i = 0;
if( *mode == 'W' || *mode == 'C' ) {   /* find the character or word being pointed to.. */
	hlow = EIgetd( p, "", "pick/hzones", &len );    /* hlow, hhi, hinc */
	if( len == 3 ) {
		hhi = hlow + 1;  hinc = hlow + 2;
		if( *hhi < *hlow || (*hhi - *hlow) > 20.0 ) 
			{ fprintf( stderr, "EEtextb() internal h. pick error.\n" ); return( 0 ); }
		
		/* find the horiz. pick.. */
		if( x >= *hlow && x <= *hhi ) {
			pz = *hlow;
			for( i = 0; ; i++ ) {
				if( x < pz ) break;
				pz += (*hinc);
				}
			}
		else return( 0 );
		if( i > strlen( val )) return( 0 );
		i--; /* adjust so that first character is position 0 */
		i += (*startcol); /* adjust for possible h. scrolling */
		/* i now contains the character pointed to.. */
		}
	else return( 0 );

	/* get the word or character.. */
	if( *mode == 'W' ) { /* word.. */
		if( val[i] == ' ' ) return( 0 );
		for( j = i; j > 0; j-- ) if( val[j] == ' ' ) { j++; break; }
		for( k = i; k < strlen( val ); k++ ) if( val[k] == ' ' ) { break; }
		k--;
		selectleft = j; selectright = k;
		for( l = j, m = 0; l <= k; l++ ) val2[ m++ ] = val[ l ];
		val2[ m ] = '\0';
		strcpy( val, val2 );
		}
	else if( *mode == 'C' ) { /* char.. */
		val[0] = val[i]; val[1] = '\0';
		selectleft = i; selectright = i;
		}
	}


/* see if an "already-picked" line was picked.. if so it becomes "un-picked".. */
oldline = EIgeti( p, "", "pick/vselect", &len );
oldleft = EIgeti( p, "", "pick/hselect", &len );
oldright = oldleft + 1;

result_format = EIgetc( p, "", "result.format", &len );
delim_list = EIgetc( p, "", "result.delim.list", &len );

/* if( nlines != *oldline || selectleft != *oldleft || selectright != *oldright ) { */

if( *unpick == 'x' && nlines == *oldline && selectleft == *oldleft &&
   selectright == *oldright ) { 
	EImodattr( p, "", "pick/vselect", "0" );
	Eselection[0] = '\0';
	EImodattr( p, "", "pick/value", Eselection );
	if( *mode == 'W' || *mode == 'C' ) { EImodattr( p, "", "pick/hselect", "-1 -1" ); }
	}

else	{

/* if( *unpick != 'x' ) {  */		/* scg 1-6-96 */

	if( *result_format != 'A' && *mode == 'L' ) {
		ix = 0;
		for( i = 0; i < atoi( result_format ); i++ ) {
			Egetchunk( Eselection, val, &ix, delim_list );
			}
		}
	else strcpy( Eselection, val ); /* save selection */
	EImodattr( p, "", "pick/value", Eselection );
	sprintf( val, "%d", nlines );
	EImodattr( p, "", "pick/vselect", val );
	if( *mode == 'W' || *mode == 'C' ) {
		sprintf( val, "%d %d", selectleft, selectright );
		EImodattr( p, "", "pick/hselect", val );
		}
	}


Efastflag = 1; Egen( p ); Efastflag = 0;

/* Do an immediate reset */
flashpick = EIgetc( p, "", "flashpick", &len );
if( len > 0 ) {
	Eflush();
	Eusleep( Eflashdelay ); 
	Eexec( p, 0.0, 0.0, E_MESSAGE, "RESET" ); 
	Egen( p );
	}


return( 1 );
}

