/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* =========== COPA_FILLBUF (internal) =========== */
/* This is used to collect text from copa_txt calls into a large buffer */
/* This routine is called from C apps via copa_text() and from shell apps via copa_cli() */

/* Mode: 0 = fill buffer beginning at position 0 with given text   
	 1 = truncate buffer at postition 0 and return
	 2 = append given text to buffer, and add a trailing newline
 */
#include <stdio.h>

#include "bigbuf.h"


char *
/* copa_fillbuf( char *txt, int mode ) */
copa_fillbuf( txt, mode )
char *txt;
int mode;
{
int full;
char *c, *copa_txt();
int i;

if( mode < 2 ) {
	Ebigbuf[0] = '\0';
	if( mode == 1 ) return( NULL );
	}
full = 0;
for( i = 0; ; i++ ) {
	c = copa_txt( txt, i, Ebuf, LINEMAX ); /* get command results, if any */
	if( c == NULL ) break;
	else if( full );
	else	{
		if( strlen( c ) + strlen( Ebigbuf ) > BIGBUFSIZE ) full = 1;
		else 	{
			addb( Ebigbuf, c );
			if( mode == 2 ) addb( Ebigbuf, "\n" );
			}
		}
	}
if( full ) Eerrmsg( 55, "Warning: Too much text - results truncated.", "" );
return( Ebigbuf );
}


/* ============ COPA_TXT (internal) ============= */
/* This function is called by the client version of copa_text() which gets
   results and sends them via pipe to server; it is ALSO called by the
   the C api version of copa_text(), which gets results and appends them
   to a large buffer.

   This function evaluates a text string. Txt can be literal, !command, or 
   combination of the two.
   Called repeatedly; returns portions of results, until there are
   no more, in which case NULL is returned.

Args:
   count: First call for a given string: count = 0; otherwise count > 0.
   cbuf: is a char buffer which will be left alone between groups of
     calls to this function.
Notes:
   The txt argument will not be modified.
   This function will return pointers which access cbuf.
*/

#include <stdio.h>

static int doing_command; /* 1 when in the midst of getting command results, 0 otherwise */
static int done;   /* 1 when next call should return NULL immediately */
static int trail_txt; /* -1 == no trailing text; otherwise holds position of beginning
				of trailing text (literal text coming after command) */
static FILE *comfp;
static char combuf[ SELECTIONMAX ]; /* command goes here - note size limit.. */  /* LIMIT */

/* ======= */
char *
/* copa_txt( char *txt, int count, char *cbuf, int cbufsize ) */
copa_txt( txt, count, cbuf, cbufsize )
char *txt;
int count;
char *cbuf;
int cbufsize;
{
int i, len, comstart, comend;


/* first call: look for any imbedded commands (lines beginning with !) */
if( count == 0 ) {
	done = 0;
	doing_command = 0;
	trail_txt = -1;
	comstart = -1;
	len = strlen( txt );
	for( i = 0; i < len; i++ ) {
		if( i == 0 || txt[i-1] == '\n' ) {
			if( txt[i] == '!' ) { 
				comstart = i + 1;
				/* find end of command.. */
				for( ; i < len; i++ ) if( txt[i] == '\n' ) break;
				comend = i;
				strncpy( combuf, &txt[ comstart ], comend-comstart );
				combuf[ comend-comstart ] = '\0';
				break;
				}
			}
		}

	if( comstart == -1 ) {    /* no embedded commands.. just return text */
		done = 1; 
		return( txt ); 
		}

	if( comend + 1 < strlen( txt ) ) {   /* see if trailing text exists.. */
		trail_txt = comend + 1;
		}

	if( comstart > -1 ) {     /* popen the command.. */
		comfp = popen( combuf, "r" );
		if( comfp == NULL ) doing_command = 0;
		else doing_command = 1;
		}

	if( comstart > 1 ) {   		/* some text before command, return it */
		strncpy( cbuf, txt, comstart-1 );
		cbuf[ comstart - 1 ] = '\0';
		doing_command = 1; /* for next time.. */
		return( cbuf );
		}
	}

if( done ) return( NULL );

if( doing_command ) {
	if( fgets( cbuf, cbufsize, comfp ) == NULL ) { /* no more results.. */
		doing_command = 0;
		pclose( comfp );
		if( trail_txt > -1 ) return( &txt[ trail_txt ] );
		else return( NULL );
		}
	else 	{			/* more results still to come.. */
		doing_command = 1;
		return( cbuf ); /* return a line of the results */
		}
	}

return( NULL );
}



/* =============================== */
/* append str to buffer */
static int
addb( bb, str )
char bb[], str[];
{
int len;

len = strlen( bb );
sprintf( &bb[ len ], "%s", str );
}


/* ======== */
/* test module */
/*
 * main()
 * {
 * int i, j;
 * char *c;
 * char cbuf[512];
 * 
 * for( j = 0; j < 2; j++ ) {
 * for( i = 0; ; i++ ) {
 * 	c = copa_txt( "Choice A\nChoice B\n!ls\nBottom", i, cbuf, 512 );
 * 	if( c == NULL ) break;
 * 	printf( "%s", c );
 * 	}
 * }
 * }
 */
