#include "elib.x"

/* ======================== */
/* ======================== */
/* ======================== */
/* edit the object or group */
/* ======================== */
Eeditobj( id, attr, value )
int id;
char attr[];
char value[];
{
int i, ip;

if( strcmp( EIgetobjname( id ), "group_begin" )==0 ) { /* update all objects in group.. */
	for( i = 0; ; i++ ) {
		if( i == 0 ) ip = Egetgroupobj( id, E_AT_BEGINNING );
		else ip = Egetgroupobj( id, E_NEXT );
		if( ip == E_NIL ) break;

		/* edit group begin,  don't edit group_end.  don't edit if attribute not legit.. */
		if( EIexists( ip, "", attr )) {
			EImodattr( ip, "", attr, value ); 
			Enulloutbb( ip );
			}
		}
	Egetgroupobj( id, E_DONE );
	}

else if( EIexists( id, "", attr )) {
	EImodattr( id, "", attr, value ); /* it's just a single object.. */
	Enulloutbb( id );
	}
else return( 0 );
return( 1 );
}

/* ====================== */
/* ====================== */
/* ====================== */
/* move an object or group */
/* ====================== */
Emoveobj( id, tx, ty )
int id;
double tx, ty; /* translation vector */
{
int i, len, ip;
char *name;

if( strcmp( EIgetobjname( id ), "group_begin" )==0 ) { /* update all objects in group.. */
	for( i = 0; ; i++ ) {
		if( i == 0 ) ip = Egetgroupobj( id, E_AT_BEGINNING );
		else ip = Egetgroupobj( id, E_NEXT );
		if( ip == E_NIL ) break;

		/* do a move on everything between (but not including) the begin and the end */
		name = EIgetobjname( ip );
		if( ! Esmember( name, "group_begin group_end", " " )) Edomov( ip, tx, ty );
		}
	Egetgroupobj( id, E_DONE );
	}
else Edomov( id, tx, ty ); /* it's just a single object.. */
return( 1 );
}

/* ==== */
static
Edomov( id, tx, ty )
int id;
double tx, ty; /* translation vector */
{
char value[100];
int n, k, len;
double *d1, *d2, *d3, *d4;

if( !EIexists( id, "*", "bb" )) return( 0 );
EIgetd( id, "*", "bb", &len );
if( len > 0 ) { 
	Enulloutbb( id );
	}

d1 = EIgetd( id, "*", "trl", &len );
if( len > 0 && EIwhere_was_it() == 1 ) { /* must be a user value, not inherited */
	d2 = d1 + 1;
	tx += *d1; ty += *d2;
	}
sprintf( value, "%g %g", tx, ty );
EImodattr( id, "", "*/trl", value );
return( 1 );
}

/* ====================== */
/* ====================== */
/* ====================== */
/* copy an object or group */
/* ====================== */
Ecopyobj( id, tx, ty )
int id;
double tx, ty; /* translation vector */
{
int i, len, ip;
char *name;

if( strcmp( EIgetobjname( id ), "group_begin" )==0 ) { 		/* copy all objects in group.. */
	for( i = 0; ; i++ ) {
		if( i == 0 ) ip = Egetgroupobj( id, E_AT_BEGINNING );
		else ip = Egetgroupobj( id, E_NEXT );
		if( ip == E_NIL ) break;

		/* copy everything, including begin and end */
		Edocopy( ip, tx, ty );
		}
	Egetgroupobj( id, E_DONE );
	}
else Edocopy( id, tx, ty ); /* it's just a single object.. */
return( 1 );
}

/* ================ */
static
Edocopy( id, tx, ty )
int id;
double tx, ty;
{
char value[100];
int newid;
int n, k, len;
double *d1, *d2, *d3, *d4;
char *name;

newid = EIcopy( id );
name = EIgetobjname( newid );

if( strcmp( name, "group_begin" )!=0 ) {
	if( !EIexists( id, "*", "trl" )) return( 0 );
	d1 = EIgetd( id, "*", "trl", &len ); 
	if( len > 0 && EIwhere_was_it() == 1 ) {
		d2 = d1 + 1;
		tx += *d1; ty += *d2;
		}
	
	sprintf( value, "%g %g", tx, ty );
	EImodattr( newid, "", "*/trl", value );
	}
Enulloutbb( newid );
}
/* ======================== */
/* ======================== */
/* ======================== */
/* delete an object or group */
/* ======================== */
Edelobj( id )
int id;
{
int i, len, ip;
char *name;

if( strcmp( EIgetobjname( id ), "group_begin" )==0 ) { /* update all objects in group.. */
	for( i = 0; ; i++ ) {
		if( i == 0 ) ip = Egetgroupobj( id, E_AT_BEGINNING );
		else ip = Egetgroupobj( id, E_NEXT );
		if( ip == E_NIL ) break;
	
		/* delete everything, including begin and end */
		Edodel( ip );
		}
	Egetgroupobj( id, E_DONE );
	}
else Edodel( id ); /* it's just a single object.. */
}
/* ======== */
static
Edodel( id )
int id;
{
Enulloutbb( id );
EIdelete( id );
}

/* ====================================================== */
/* ====================================================== */
/* ====================================================== */
/* This routine will return successive objects in a group */
/* starting with the group_begin and ending with the group_end. */
/* ============================================================ */
static
Egetgroupobj( group_procid, mode )
int group_procid;
int mode;
{
static int done = 0, *endid;
int len, i;

if( strcmp( EIgetobjname( group_procid ), "group_begin" ) !=0 ) return( E_NIL );

if( mode == E_AT_BEGINNING ) {
	endid = EIgeti( group_procid, "", "endid", &len );
	if( len < 1 ) { 
		fprintf( stderr, "id=%d: Matching group_end not found.\n", group_procid ); 
		return( E_NIL ); 
		}
	done = 0;
	EIgetnextobj( E_AT_BEGINNING, 0 ); /* initialize */
	while( 1 ) {
		i = EIgetnextobj( E_NEXT, 0 ); /* advance to current location in display list */
		if( i == group_procid ) break;
		else if( i == E_NIL ) { 
			fprintf( stderr, "Internal error. Source object not in order list.\n" ); 
			EIgetnextobj( E_DONE, 0 );
			return(0);
			}
		}
	return( i );
	}
else if( mode == E_NEXT ) {
	if( done ) return( E_NIL ); 
	i = EIgetnextobj( E_NEXT, 0 );
	if( i == *endid ) done = 1; 
	return( i );
	}
else if( mode == E_DONE ) {
	EIgetnextobj( E_DONE, 0 );
	return( E_NIL );
	}
else 	{
	fprintf( stderr, "Egetgroupobj: %d: Illegal mode\n", mode ); 
	return( E_NIL );
	}
}
