/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any for-profit endeavor is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/




#include <stdio.h>
#include <math.h>

#define E_SELECTION_LEN 512 	/* max length of a selection */     /* LIMIT */
#define E_GPBUF 512		/* general purpose buffer size */   /* LIMIT */
#define E_ANAMELEN 80		/* max attribute name length */

#define E_WAITFOR_WM 200000	/* in certain situations such as after remapping
				the window or after resizing, a delay seems to be
				necessary before the window manager responds to
				subsequent instructions.. 
				This is in microseconds.
				*/

#define YES 1
#define NO 0
#define STDFONT "/Helvetica"

/* clear drawing area to the opposite of current drawing color */
#define Eclr()			Epcode( 'z', Eeraseshade, 0.0, "" )

/* dot at x, y */
#define Edot( x, y )		Epcode( '.', (double)x, (double)y, "" )
#define Edotu( x, y )		Epcode( '.', Eax((double)x), Eay((double)y), "" )

/* move to x, y absolute */
#define Emov( x , y )		Epcode( 'M', (double)x , (double)y, "" )

/* line to x, y absolute */
#define Elin( x , y )		Epcode( 'L', (double)x , (double)y, "" )

/* move to x, y data */
#define Emovu( x , y )		Epcode( 'M', Eax((double) x ) , Eay((double) y ), "" )

/* line to x, y data */
#define Elinu( x , y )		Epcode( 'L', Eax((double) x ) , Eay((double) y ), "" )

/* path to x, y absolute (form a polygon to be shaded later) */
#define Epath( x , y )		Epcode( 'P', (double)x , (double)y, "" )

/* path to x, y data (form a polygon to be shaded later) */
#define Epathu( x , y )		Epcode( 'P', Eax((double) x ) , Eay((double) y ), "" )

/* do shading, within the previously defined polygon path.. the shade can be 0 to 1 */
#define Eshade( x )		Epcode( 'S', (double)x , 0.0, "" )

/* text string s starting at the current location  */
#define Etext( s )		Epcode( 'T', 0.0, 0.0, s )


/* center text around current "pen" position.. */
#define Ecentext( s )		Epcode( 'C', 0.0 , 0.0, s )

/* right justify text such that right edge of text is at current "pen" position.. */
#define Erightjust( s )		Epcode( 'J', 0.0, 0.0, s )

/* scaling factor for text */
#define Escaletext( x )		Epcode( 'e', x, 0.0, "" )

/* Eprint() is same as Egetclick() */
#define Eprint()		Egetclick()

/* internal: eject page (printers), end-of-plot (screens) */
#define Eshow()			Epcode( 'Z', 0.0, 0.0, "" )

/* internal: wait for user input */
#define Esit()		 Epcode( 'W', 0.0, 0.0, "" )

/* cycle notifier when running asynchronously.. */
#define Easync()	 Epcode( 'w', 0.0, 0.0, "" )

/* these can go around repetitive drawing operations to improve efficiency (sunview only) */
#define Ebatch_on()		Epcode( 'B', 0.0, 0.0, "" )
#define Ebatch_off()		Epcode( 'b', 0.0, 0.0, "" )

/* display everything that's waiting..(x only) */
#define Eflush()		Epcode( 'U', 0.0, 0.0, "" )

/* define a circle center and radius, for the benefit of object/pick package.. */
/* x, y define the center and r the radius. */ 
/* #define Ecircledef( x, y, r )	Epcode( 'X', x, y, Eftoa( r ) ) */

/* remove window.. */
#define Ewinappear()		Epcode( 'a', 0.0, 0.0, "" )
#define Ewindisappear()		Epcode( 'd', 0.0, 0.0, "" )

/* terminate */
#define Eendoffile()		Epcode( 'Q', 0.0, 0.0, "" )

/* 
Graphics notes:
- Origin is in lower left corner of "paper", regardless of orientation of paper.
- Format of i-code will be: "a x y s\n", where a is an op code, x and y
   are coordinates in inches, and s is a variable length string (may be null).
*/

#define E_LINEAR 0
#define E_LOG 1
#define E_YYMM 2

#define E_WHITE 1
#define E_BLACK 0
extern double Eax(), Eay(), Eux(), Euy(), Egetvaluef(), atof(), sqrt();
extern char *Eftoa(), *Egetok(), *Egetobjparent();
extern int *Ewhichobjects();

#define E_MOUSE_LEFT 1001
#define E_MOUSE_MIDDLE 1002
#define E_MOUSE_RIGHT 1003
#define E_EXPOSE 1010  /* window has been exposed and needs to be redrawn */
#define E_RESIZE 1011  /* window has been resized */
#define E_MESSAGE 2000

#define E_RA 0.5  /* vertical size of the reserved area.. */

#define E_SAVE 0
#define E_RESTORE 1

#define E_PUSH 0
#define E_POP 1
#define E_PEEK 2

#define E_TMPFILENM "/usr/tmp/elib" 
#define E_TMPDIR "/usr/tmp"

/* ipl database defines.. */
extern char *EIgetobjname(), *EIgetnextattr(), *EIgetc(), *EIgetpackagename(), *EIgetval();
extern double *EIgetd();
extern int *EIgeti();

/* Egetnextobj sequences.. */
#define E_AT_BEGINNING 0
#define E_AT_END 2
#define E_NEXT 1
#define E_PREVIOUS -1
#define E_DONE 3

/* ipl nil */
#define E_NIL -1

/* convenience macros */ 
#define Egetid( t )  EItaglookup( t, E_NIL )
#define Eraise( p )  EIraise( p )
#define Elower( p )  EIlower( p )




