/* small, lowlevel routines for graphics */
#include "elib.x"

/* linear, log, time, yymm, mmddyy, polar */

/* =========================== */
/* for setting up scaling in x */
Escale_x( xlow, xhi, datalow, datahi )
double 	xlow, 	/* absolute x location of left side of the area */
	xhi, 	/* absolute x location of the right side of the area */
	datalow, /* data-units x at the left side */
	datahi;	 /* data-units x at the right side */
{
EXlo = xlow;
EXhi = xhi;
EDXlo = datalow;
EDXhi = datahi;
if( datahi-datalow <= 0 || xhi-xlow <= 0 ) { fprintf( stderr, "Bad x scaling min/max values.\n" ); exit(); }
if( EScale_discipline_x == E_LINEAR )EScale_x = (xhi-xlow) / (datahi-datalow) ;
else if( EScale_discipline_x == E_LOG )EScale_x = (xhi-xlow) / log( datahi-datalow ) ;
else if( EScale_discipline_x == E_YYMM ) {
	EScale_x = (xhi-xlow) / ( Eyymm_to_i( datahi ) - Eyymm_to_i( datalow ));
	EDXlo = Eyymm_to_i( datalow );
	EDXhi = Eyymm_to_i( datahi );
	}
}

/* =========================== */
/* for setting up scaling in y */
Escale_y( ylow, yhi, datalow, datahi )
double 	ylow, 	/* absolute y location of low side of the area */
	yhi, 	/* absolute y location of high side of the area */
	datalow, /* data-units y at the low side */
	datahi;	 /* data-units y at the high side */
{
EYlo = ylow;
EYhi = yhi;
EDYlo = datalow;
EDYhi = datahi;
if( datahi-datalow <= 0 || yhi-ylow <= 0 ) { fprintf( stderr, "Bad y scaling min/max values.\n" ); exit(); }
if( EScale_discipline_y == E_LINEAR )EScale_y = (yhi-ylow) / (datahi-datalow) ;
else if( EScale_discipline_y == E_LOG )EScale_y = (yhi-ylow) / log( datahi-datalow ) ;
}

/* =========================== */
/* returns an absolute x location from a data value */
double Eax( d )
double d;
{
double f;
if( EScale_discipline_x == E_LINEAR ) return( EXlo + (( d - EDXlo ) * EScale_x ));
else if( EScale_discipline_x == E_LOG ) { 
	if( d-EDXlo > 0.0 )return( EXlo + ( log( d - EDXlo )*EScale_x )); 
	else return( EXlo );
	}
else if( EScale_discipline_x == E_YYMM ) {
	if( d >= 7000 ) d = Eyymm_to_i( d );
	return( EXlo + (( d - EDXlo) * EScale_x ));
	}
}

/* =========================== */
/* returns an absolute y location from a data value */
double Eay( d )
double d;
{
if( EScale_discipline_y == E_LINEAR ) return( EYlo + (( d - EDYlo ) * EScale_y ));
else if( EScale_discipline_y == E_LOG ) {
	if( d-EDYlo > 0.0 )return( EYlo + ( log( d - EDYlo )*EScale_y ));
	else return( EYlo );
	}
}


/* =========================== */
/* returns a data x location from an abs value */
double Edx( d )
double d;
{
if( EScale_discipline_x == E_LINEAR ) return( ( d - Eax( 0.0 ) ) / EScale_x );
else if( EScale_discipline_x == E_LOG ) return( exp( (d-EXlo) / EScale_x ) );
}


/* =========================== */
/* returns a user y location from an abs value */
double Edy( d )
double d;
{
if( EScale_discipline_y == E_LINEAR ) return( ( d - Eay( 0.0 ) ) / EScale_y );
else if( EScale_discipline_y == E_LOG ) return( exp( (d-EYlo) / EScale_y ) );
}


/* ============================ */
/* Returns an integer given a YYMM date.  Jan 1970 is zero. */

Eyymm_to_i( m )
double m;
{
int yr, mo;

yr = (int)(m) / 100;
if( yr < 70 ) yr += 100;
mo = (int)(m) % 100;
return( ((yr-70)*12 ) + mo );
}

/* ============================ */
/* Select the scaling method */
Escaletype( typ, axis )
char typ[];
char axis;
{
if( strcmp( typ, "linear" )==0 ) {
	if( axis == 'x' ) EScale_discipline_x = E_LINEAR;
	if( axis == 'y' ) EScale_discipline_y = E_LINEAR;
	}
else if( strcmp( typ, "log" )==0 ) {
	if( axis == 'x' ) EScale_discipline_x = E_LOG;
	if( axis == 'y' ) EScale_discipline_y = E_LOG;
	}
else if( strcmp( typ, "yymm" )==0 ) {
	if( axis == 'x' ) EScale_discipline_x = E_YYMM;
	}
}


