/* EINIT - low level elib initialization. 
/* 
   110995	scg	env var COPA_DPI to adjust for different screen res 

 */
#include "elib.x"
#define MAXSTAK 5

Einit( name, dev, ux, uy, upleftx, uplefty )
char name[];
char dev;     /* 'x' for x11; 'p' for postscript */
double ux, uy;  /* size of window in inches.. */
int upleftx, uplefty; /* point (in native window system coords ) of upper-left corner of window */
{
char msg[100];
int yr, mon, day, hr, min, sec, i;
char host[30]; 
FILE *lfp;
char *pix, *getenv();

Esysdate( &mon, &day, &yr ); Esystime( &hr, &min, &sec );

/* initialize graphics parameters.. */
Edev = dev;


#ifndef NOX11
if( dev == 'x' ) {
	pix = getenv( "COPA_DPI" );
	Epixelsinch = 0;
	if( pix != NULL && strlen( pix ) > 0 ) sscanf( pix, "%d", &Epixelsinch );
	if( Epixelsinch < 1 || Epixelsinch > 800 ) Epixelsinch = 75;
		
	Esetwinscale( (int)(ux*Epixelsinch), (int)(uy*Epixelsinch), ux, uy );
	EXWsetup( name, Epixelsinch, ux, uy, upleftx, uplefty );
	}
#endif
else if( dev == 'p' ) {
	EPSsetup( name, "-" );
	}

else { 
	fprintf( stderr, 
	  "Bad display device code (%c).  Use 'p' for PostScript or 'x' for X11.\n", dev ); 
	exit(); 
	}

EWinx = ux;  EWiny = uy;
EWinx_0 = ux;  EWiny_0 = uy; /* remember original size.. */
Esetdefaults(); 
Eerasecolor = 1; Eeraseshade = 1.0; 
/* Eclr(); */
}

/* =================================== */
/* resize/move window (code driven, not user driven) */
/*  Eresize( double ux, double uy, int upleftx, int uplefty ) */
Eresize( ux, uy, upleftx, uplefty )
double ux, uy;
int upleftx, uplefty;
{
#ifndef NOX11
if( Edev == 'x' ) {
	/* update elibs idea of window size and original size */
	if( ux >= 0 ) { EWinx = ux; EWinx_0 = ux; }
	if( uy >= 0 ) { EWiny = uy; EWiny_0 = uy; }
	/* update scaling */
	Esetwinscale( (int)(ux*Epixelsinch), (int)(uy*Epixelsinch), ux, uy );
	/* resize window */
	EXWresizewin( Epixelsinch, upleftx, uplefty, ux, uy );
	}
#endif
return( 0 );
}

/* =========================================== */
/* Egraphenv() - save/restore graphics env. */
/* Only issues a pcode call if a change needs to be made.. */
Egraphenv( mode )
int mode; /* E_PUSH  or  E_POP */
{
static char scurfont[MAXSTAK][30];
static int scurtextsize[MAXSTAK];
static int scurtextdirection[MAXSTAK];
static double scurlinewidth[MAXSTAK];
static int scurlinetype[MAXSTAK];
static double scurpatternfactor[MAXSTAK];
static int scurcolor[MAXSTAK];
static int spaper[MAXSTAK];
static double trx[MAXSTAK], try[MAXSTAK]; /* translation */
static int ss = 0;

if( mode == E_PUSH ) {
	if( ss > MAXSTAK-1 ) { fprintf(stderr,"graphic environment stack capacity exceeded.\n" ); return(0); } 
	strcpy( scurfont[ss], Ecurfont );
	scurtextsize[ss] = Ecurtextsize;
	scurtextdirection[ss] = Ecurtextdirection;
	scurlinewidth[ss] = Ecurlinewidth;
	scurlinetype[ss] = Ecurlinetype;
	scurpatternfactor[ss] = Ecurpatternfactor;
	scurcolor[ss] = Ecurcolor;
	spaper[ss] = Ecurpaper;
	Etrlget( &trx[ss], &try[ss] );
	ss++;
	}
else if( mode == E_POP ) {
	if( ss > 0 ) ss--;
	if( strcmp( scurfont[ss], Ecurfont ) != 0 ) Efont( scurfont[ss] );
	if( scurtextsize[ss] != Ecurtextsize ) Etextsize( scurtextsize[ss] );
	if( scurtextdirection[ss] != Ecurtextdirection ) Etextdir( scurtextdirection[ss] );
	if( scurlinewidth[ss] != Ecurlinewidth || scurlinetype[ss] != Ecurlinetype || 
	    scurpatternfactor[ss] != Ecurpatternfactor ) {
		Elinetype( scurlinetype[ss], scurlinewidth[ss], scurpatternfactor[ss] );
		}
	if( scurcolor[ss] != Ecurcolor ) {
		Esetdrawcolor( scurcolor[ss] );
		}
	if( spaper[ss] != Ecurpaper )Epaper( spaper[ss] );
	Etrlset( trx[ss], try[ss] );
	}
}

/* ====================================== */
Esetdefaults()
{
strcpy( Estandardfont, "/Helvetica" );
if( strcmp( Estandardfont, Ecurfont ) != 0 ) Efont( Estandardfont );
if( Ecurtextsize != 10 ) Etextsize( 10 );
if( Ecurtextdirection != 0 ) Etextdir( 0 );

Estandardlinewidth = 0.6;
if( Ecurlinewidth != 0.6 || Ecurlinetype != 0 || Ecurpatternfactor != 1.0 ) Elinetype( 0, 0.6, 1.0 );

if( Ecurcolor != E_BLACK ) {
	Esetdrawcolor( E_BLACK );
	}

Ependraw();
Escaletype( "linear", 'x' );
Escaletype( "linear", 'y' );
if( Ecurpaper != 0 )Epaper( 0 );
EEvent = 0;
}
