#include "elib.x"

/* event modes */
#define STRING 2	/* getting a \n terminated string */
#define EVENTS 3	/* getting any mouse-button or keyboard event */


/* info re: most recent event.. */
static int  Eevent_mode;
static double Eevx, Eevy;
static int Eeid;
static int Eallpick = 0;
static int Eidlist[40], Eidlistn=0;
static double savex = 0.0, savey = 0.0;
static int savec = 0;




/* ==================================== */
/* get mouse position (x, y) and event code.. */

Egetkey( x, y, e )
double *x, *y;
int *e;
{
char ans[20];

if( Edev == 'p' ) { Eshow(); exit(); }  /* postscript-- eject page and exit.. */
Eevent_mode = EVENTS;
Esit();
*x = Eevx; *y = Eevy; *e = Eeid;

EEvent = 0; /* reset for the benefit of later non-blocking gets */
}
  

/* =================================== */
/* wait until a key or button is hit.. */

Egetclick()
{
double x, y;
int e;
if( Edev == 'p' ) { Eshow(); return(0); }  /* postscript-- eject page.. */

Egetkey( &x, &y, &e );
}

/* ================================ */
/* This gets called by the driver when we are waiting for an event 
   and then a key or mouse event happens. Never called directly by users. */
Ehandle_event( x, y, e )
double x, y;
int e;
{
int i;
char id[4];
double trlx, trly, dx, dy;

/* set global vars for async processes.. moved here from below scg Nov 95 */
EEvent = e; EEventx = x; EEventy = y;

if( e == E_EXPOSE ) {
	Etrlget( &trlx, &trly ); /* we need to save, set to zero, then restore the trl setting.. */
	Etrlset( 0.0, 0.0 );

	Eredraw_entryfield();
	Eclr(); 	/* added scg 11-9-95 */
	Egenall();	/* regenerate picture.. */
	Etrlset( trlx, trly );
	return( 1 );
	}
else if( e == E_RESIZE ) {
	/* x and y are in pixels */
	Etrlget( &trlx, &trly ); /* we need to save, set to zero, then restore the trl setting.. */
	Etrlset( 0.0, 0.0 );

	EWinx = x / (double)Epixelsinch;
	EWiny = y / (double)Epixelsinch;

	/* calculate a new text scale factor.. */
	dx = ((double)EWinx / (double)EWinx_0);
	dy = ((double)EWiny / (double)EWiny_0);
	if( dx < dy ) Escaletext( dx );
	else Escaletext( dy ); 

	/* adjust graphics scaling.. */
	Esetwinscale( (int)(x), (int)(y), EWinx, EWiny );


	Eredraw_entryfield();

	Ealignall();  /* re-align everything.. */
	Eclr(); 
	Egenall();   /* redraw everything */
	Etrlset( trlx, trly );
	return( 1 );
	}

/* set global vars for async processes.. */
/* EEvent = e; EEventx = x; EEventy = y; */

/* user is clicking any mouse button or key.. */
Eevx = x; Eevy = y; Eeid = e;
return( 1 );
}

/* ================================== */
/* given an x,y mouse location, return the
   corresponding procid.  If > 1, selects the one "on top". */
/* Returns -1 if none found. */
Ewhichobj( x, y )
double x, y;
{
double fabs();
char *typ;
double *x1, *y1, *x2, *y2;
int len;
int id;
int found;


EIgetnextobj( E_AT_END, 2 ); /* initialize */
Eidlistn = 0;

/* search the bounding boxes, starting with latest and going backwards.. */
while( 1 ) {
	found = 0;
	id = EIgetnextobj( E_PREVIOUS, 2 );
	if( id < 0 ) break;

	if( ! EIexists( id, "*", "bbt" )) continue;
	typ = EIgetc( id, "*", "bbt", &len );

	x1 = EIgetd( id, "*", "bb", &len );
	if( len != 4 ) continue;

	EIgetc( id, "*", "display", &len );
	if( len < 1 ) continue; /* its invisible.. */

	y1 = x1; y1++; x2 = y1; x2++; y2 = x2; y2++;  /* set up pointers */

	/* box.. */
	if( *typ == 'B' ) {
	      	if( x > *x1 && x < *x2 && y > *y1 && y < *y2 ) found = 1;
	      	}

	/* line.. */
	else if( *typ == 'L' ) {
		if( Eispointonline( x, y, *x1, *y1, *x2, *y2 ) ) found = 1;
		}

	if( found && !Eallpick ) { EIgetnextobj( E_DONE, 2 ); return( id ); }
	else if( found && Eallpick ) { Eidlist[ Eidlistn++ ] = id; }
	}
EIgetnextobj( E_DONE, 2 );
if( Eallpick && Eidlistn > 0 ) return( 1 );
return( -1 );
}
		
/* ===================================== */
/* variation for returning a list of all picked objects, ordered
   from "top to bottom". */
/* returns -1 if none found */
int *
Ewhichobjects( n, x, y )
int *n;      /* number of ids that will be in list */
double x, y; /* absolute location */
{
int i, j;

Eallpick = 1;
Eidlistn = 0;
i = Ewhichobj( x, y );
Eallpick = 0;
*n = Eidlistn;
return( Eidlist );
}
/* ==================== */
/* the following routines provide a place to save/retrieve an event */
Esavekey( lx, ly, c )
double lx, ly;
int c;
{
savex = lx;
savey = ly;
savec = c;
return( 0 );
}

Eretrievekey( lx, ly, c )
double *lx, *ly;
int *c;
{
*lx = savex;
*ly = savey;
*c = savec;
return( 0 );
}

