/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any for-profit endeavor is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* constants */
#include <stdio.h>
#include <math.h>
#include "elib.d"

#define INSTALL_TMP "/usr/tmp"
#define PATHNAME_LEN 80
#define HBUFSIZ 4096
#define MAX_D_ROWS 1000
#define MAX_D_COLS 24
#define DATAITEM_LEN 20
#define YES 1
#define NO 0

/* map the NT macros to Elib calls */
/* we'll continue to use the ipl scaling mechanism, though. */
/* ------------------------------------------------- */
#define NTmov( x , y )		Emov( (double)x, (double)y )
#define NTlin( x , y )		Elin( (double)x, (double)y )
#define NTpath( x , y )		Epath( (double)x, (double)y )
#define NTl( x , y )		Elin( da_x((double) x ) , da_y((double) y) )
#define NTm( x , y )		Emov( da_x((double) x ) , da_y((double) y) )
#define NTp( x , y )		Epath( da_x((double) x ) , da_y((double) y) )
#define NTshade( x )		Eshade( (double)x )
#define NTtext( s )		Etext( s )
/* NTcentext and NTrightjust are now in stub.c */
#define NTfont( s )		Efont( s )
#define NTptsize( x )		{ Etextsize( (int)x ); Chsz = x; Chh = (x+2)/72.0; }
#define NTchardir( x )		{ Etextdir( (int)x ); Chd = x ; }
#define NTpaper( x )		{ Paper = (int) (x); Epaper( x ); }
#define NTlinetype( s, x, y )   { Elinetype( atoi( s ), x, y ); Lw = x; } 
#define NTnormline()		{ Enormline(); Lw = StdLw; }
#define NTshow()		{ if( Dev == 't' )Eprint(); else Eclr(); }
#define NTbatch_on()		Ebatch_on()
#define NTbatch_off()		Ebatch_off()
#define point( x, y, s, r )	Emark( (double)x, (double)y, s, r )

#define LINEAR 0
#define LOG 1
#define YYMM 2

#define WHITE 1
#define BLACK 0
extern double da_x(), da_y(), ab_x(), ab_y();


#define FONTNAME_LEN	30	
#define TMPFILE_PATH	INSTALL_TMP
#define NSLOTS 24	/* number of slots in ASmax[] */

#define MOUSE_LEFT 1001
#define MOUSE_MIDDLE 1002
#define MOUSE_RIGHT 1003

extern char *getln();
extern FILE *popen();

/* map gget to zood call.. */
#define gget( b, a )		EIget( b, EPcurp, "", a )

/* map gdp_exit to a return(0) */
#define gdp_exit()		return(0)
